/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.OnAlarm;
import org.apache.ode.bpel.compiler.bom.OnMessage;
import org.apache.ode.bpel.compiler.bom.PickActivity;
import org.apache.ode.bpel.compiler.v2.PickReceiveGenerator;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OPickReceive;

class PickGenerator
extends PickReceiveGenerator {
    PickGenerator() {
    }

    public OActivity newInstance(Activity src) {
        return new OPickReceive(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity output, Activity src) {
        OPickReceive opick = (OPickReceive)output;
        PickActivity pickDef = (PickActivity)src;
        opick.createInstanceFlag = pickDef.isCreateInstance();
        for (OnMessage sOnMessage : pickDef.getOnMessages()) {
            OPickReceive.OnMessage oOnMessage = this.compileOnMessage(sOnMessage.getVariable(), sOnMessage.getPartnerLink(), sOnMessage.getOperation(), sOnMessage.getMessageExchangeId(), sOnMessage.getPortType(), pickDef.isCreateInstance(), sOnMessage.getCorrelations());
            if (sOnMessage.getActivity() == null) {
                throw new CompilationException(__cmsgs.errEmptyOnMessage().setSource(sOnMessage));
            }
            oOnMessage.activity = this._context.compile(sOnMessage.getActivity());
            opick.onMessages.add(oOnMessage);
            if (oOnMessage.variable == null) continue;
            opick.variableWr.add(oOnMessage.variable);
        }
        try {
            for (OnAlarm onAlarmDef : pickDef.getOnAlarms()) {
                OPickReceive.OnAlarm oalarm = new OPickReceive.OnAlarm(this._context.getOProcess());
                oalarm.activity = this._context.compile(onAlarmDef.getActivity());
                if (onAlarmDef.getFor() != null && onAlarmDef.getUntil() == null) {
                    oalarm.forExpr = this._context.compileExpr(onAlarmDef.getFor());
                } else if (onAlarmDef.getFor() == null && onAlarmDef.getUntil() != null) {
                    oalarm.untilExpr = this._context.compileExpr(onAlarmDef.getUntil());
                } else {
                    throw new CompilationException(__cmsgs.errForOrUntilMustBeGiven().setSource(onAlarmDef));
                }
                if (pickDef.isCreateInstance()) {
                    throw new CompilationException(__cmsgs.errOnAlarmWithCreateInstance().setSource(onAlarmDef));
                }
                opick.onAlarms.add(oalarm);
            }
        }
        catch (CompilationException ce) {
            this._context.recoveredFromError(pickDef, ce);
        }
    }
}

