/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v2.PickGeneratorMessages;
import org.apache.ode.bpel.rapi.CorrelationSetModel;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OPickReceive;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.msg.MessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PickReceiveGenerator
extends DefaultActivityGenerator {
    protected static final CommonCompilationMessages __cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    protected static final PickGeneratorMessages __cmsgs = (PickGeneratorMessages)MessageBundle.getMessages(PickGeneratorMessages.class);

    PickReceiveGenerator() {
    }

    @Override
    public OActivity newInstance(Activity src) {
        return new OPickReceive(this._context.getOProcess(), this._context.getCurrent());
    }

    protected OPickReceive.OnMessage compileOnMessage(String varname, String plink, String operation, String messageExchangeId, QName portType, boolean createInstance, Collection<Correlation> correlations) {
        OPickReceive.OnMessage onMessage = new OPickReceive.OnMessage(this._context.getOProcess());
        onMessage.partnerLink = this._context.resolvePartnerLink(plink);
        onMessage.operation = this._context.resolveMyRoleOperation(onMessage.partnerLink, operation);
        if (onMessage.operation.getInput() != null && onMessage.operation.getInput().getMessage() != null) {
            onMessage.variable = this._context.resolveMessageVariable(varname, onMessage.operation.getInput().getMessage().getQName());
        }
        onMessage.messageExchangeId = messageExchangeId;
        if (portType != null && !portType.equals(onMessage.partnerLink.myRolePortType.getQName())) {
            throw new CompilationException(__cmsgsGeneral.errPortTypeMismatch(portType, onMessage.partnerLink.myRolePortType.getQName()));
        }
        if (createInstance) {
            onMessage.partnerLink.addCreateInstanceOperation(onMessage.operation);
        }
        for (Correlation correlation : correlations) {
            OScope.CorrelationSet cset = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case UNSET: 
                case NO: {
                    if (createInstance) {
                        throw new CompilationException(__cmsgsGeneral.errUseOfUninitializedCorrelationSet(correlation.getCorrelationSet()));
                    }
                    if (onMessage.matchCorrelation != null) {
                        throw new CompilationException(__cmsgs.errSecondNonInitiateCorrelationSet(correlation.getCorrelationSet()));
                    }
                    onMessage.matchCorrelation = cset;
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, (CorrelationSetModel)cset);
                    break;
                }
                case YES: {
                    onMessage.initCorrelations.add(cset);
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, (CorrelationSetModel)cset);
                    onMessage.partnerLink.addUniqueCorrelationSetForOperation(onMessage.operation, (CorrelationSetModel)cset);
                    break;
                }
                case JOIN: {
                    if (createInstance) {
                        onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, (CorrelationSetModel)cset);
                        onMessage.initCorrelations.add(cset);
                        onMessage.matchCorrelation = cset;
                        break;
                    }
                    throw new CompilationException(__cmsgs.errRendezvousNotSupported());
                }
                default: {
                    throw new AssertionError((Object)"Unexpected value for correlation set enumeration!");
                }
            }
            for (OProcess.OProperty property : cset.properties) {
                this._context.resolvePropertyAlias(onMessage.variable, property.name);
            }
        }
        if (!onMessage.partnerLink.hasMyRole()) {
            throw new CompilationException(__cmsgsGeneral.errNoMyRoleOnReceivePartnerLink(onMessage.partnerLink.getName()));
        }
        return onMessage;
    }
}

