/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2.xpath10;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.apache.ode.bpel.compiler.CompilationExceptionWrapper;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.compiler.v2.xpath10.XslCompileUriResolver;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OXslSheet;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;

class JaxenBpelHandler
extends JaxenHandler {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10Expression _out;
    private NSContext _nsContext;
    private String _bpelNsUril;

    JaxenBpelHandler(String bpelNsUri, OXPath10Expression out, NSContext nsContext, CompilerContext cctx) {
        this._bpelNsUril = bpelNsUri;
        this._cctx = cctx;
        this._nsContext = nsContext;
        this._out = out;
        assert (nsContext != null);
        assert (cctx != null);
        assert (out != null);
    }

    public void variableReference(String prefix, String variableName) throws JaxenException {
        super.variableReference(prefix, variableName);
        if ("ode".equals(prefix) && "pid".equals(variableName)) {
            return;
        }
        if (this._out instanceof OXPath10ExpressionBPEL20) {
            OXPath10ExpressionBPEL20 out = (OXPath10ExpressionBPEL20)this._out;
            try {
                if (out.isJoinExpression) {
                    OLink olink = this._cctx.resolveLink(variableName);
                    this._out.links.put(variableName, olink);
                } else {
                    int dot = variableName.indexOf(46);
                    if (dot != -1) {
                        variableName = variableName.substring(0, dot);
                    }
                    OScope.Variable var = this._cctx.resolveVariable(variableName);
                    this._out.vars.put(variableName, var);
                }
            }
            catch (CompilationException ce) {
                throw new CompilationExceptionWrapper(ce);
            }
        }
    }

    public void endXPath() throws JaxenException {
        super.endXPath();
    }

    public void endFunction() {
        super.endFunction();
        FunctionCallExpr c = (FunctionCallExpr)this.peekFrame().getLast();
        String prefix = c.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            return;
        }
        String ns = this._nsContext.getNamespaceURI(prefix);
        if (ns == null) {
            throw new CompilationException(__msgs.errUndeclaredFunctionPrefix(prefix, c.getFunctionName()));
        }
        if (this.isBpelNamespace(ns)) {
            if ("getVariableData".equals(c.getFunctionName())) {
                this.compileGetVariableData(c);
            } else if ("getVariableProperty".equals(c.getFunctionName())) {
                this.compileGetVariableProperty(c);
            } else if ("getLinkStatus".equals(c.getFunctionName())) {
                this.compileGetLinkStatus(c);
            } else if ("doXslTransform".equals(c.getFunctionName())) {
                this.compileDoXslTransform(c);
            } else {
                throw new CompilationException(__msgs.errUnknownBpelFunction(c.getFunctionName()));
            }
        }
    }

    private boolean isBpelNamespace(String ns) {
        return ns.equals(this._bpelNsUril);
    }

    private void compileGetLinkStatus(FunctionCallExpr c) throws CompilationException {
        List params = c.getParameters();
        if (params.size() != 1) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments(c.getFunctionName()));
        }
        String linkName = this.getLiteralFromExpression((Expr)params.get(0));
        OLink olink = this._cctx.resolveLink(linkName);
        this._out.links.put(linkName, olink);
    }

    private void compileGetVariableData(FunctionCallExpr c) throws CompilationException {
        List params = c.getParameters();
        if (params.size() < 1 || params.size() > 3) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments(c.getFunctionName()));
        }
        String varname = this.getLiteralFromExpression((Expr)params.get(0));
        String partname = params.size() > 1 ? this.getLiteralFromExpression((Expr)params.get(1)) : null;
        String locationstr = params.size() > 2 ? this.getLiteralFromExpression((Expr)params.get(2)) : null;
        OScope.Variable var = this._cctx.resolveVariable(varname);
        OMessageVarType.Part part = partname != null ? this._cctx.resolvePart(var, partname) : null;
        OExpression location = null;
        if (locationstr != null) {
            location = this._cctx.compileExpr(locationstr, this._nsContext);
        }
        this._out.addGetVariableDataSig(varname, partname, locationstr, new OXPath10Expression.OSigGetVariableData(this._cctx.getOProcess(), var, part, location));
    }

    private void compileGetVariableProperty(FunctionCallExpr c) throws CompilationException {
        List params = c.getParameters();
        if (params.size() != 2) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
        }
        String varName = this.getLiteralFromExpression((Expr)params.get(0));
        OScope.Variable v = this._cctx.resolveVariable(varName);
        this._out.vars.put(varName, v);
        String propName = this.getLiteralFromExpression((Expr)params.get(1));
        QName qname = this._nsContext.derefQName(propName);
        if (qname == null) {
            throw new CompilationException(__msgs.errInvalidQName(propName));
        }
        OProcess.OProperty property = this._cctx.resolveProperty(qname);
        this._cctx.resolvePropertyAlias(v, qname);
        this._out.properties.put(propName, property);
        this._out.vars.put(varName, v);
    }

    private void compileDoXslTransform(FunctionCallExpr c) throws CompilationException {
        List params = c.getParameters();
        if (params.size() < 2 || params.size() % 2 != 0) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
        }
        String xslUri = this.getLiteralFromExpression((Expr)params.get(0));
        OXslSheet xslSheet = this._cctx.compileXslt(xslUri);
        try {
            XslTransformHandler.getInstance().parseXSLSheet(this._cctx.getBaseResourceURI(), xslSheet.uri, xslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(this._cctx, this._out));
        }
        catch (Exception e) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments(xslUri));
        }
        this._out.xslSheets.put(xslSheet.uri, xslSheet);
    }

    private String getLiteralFromExpression(Expr expr) throws CompilationException {
        if ((expr = expr.simplify()) instanceof LiteralExpr) {
            return ((LiteralExpr)expr).getLiteral();
        }
        throw new CompilationException(__msgs.errLiteralExpected(expr.getText()));
    }
}

