/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2.xpath10.jaxp;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OVarType;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final Log __log = LogFactory.getLog(XPathVariableResolver.class);
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10Expression _oxpath;

    public JaxpVariableResolver(CompilerContext cctx, OXPath10Expression oxpath) {
        this._cctx = cctx;
        this._oxpath = oxpath;
    }

    public Object resolveVariable(QName variableName) {
        __log.debug((Object)("JAXP compiler: Resolving variable " + variableName));
        if (("ode".equals(variableName.getPrefix()) || "http://www.apache.org/ode/type/extension".equals(variableName.getNamespaceURI())) && "pid".equals(variableName.getLocalPart())) {
            return "";
        }
        try {
            String name = variableName.getLocalPart();
            if (this._oxpath instanceof OXPath10ExpressionBPEL20 && ((OXPath10ExpressionBPEL20)this._oxpath).isJoinExpression) {
                OLink olink = this._cctx.resolveLink(name);
                this._oxpath.links.put(name, olink);
                return Boolean.TRUE;
            }
            int dot = name.indexOf(46);
            if (dot != -1) {
                name = name.substring(0, dot);
            }
            OScope.Variable var = this._cctx.resolveVariable(name);
            this._oxpath.vars.put(name, var);
            return this.extractValue(var, var.type);
        }
        catch (CompilationException e) {
            throw new WrappedResolverException(e);
        }
    }

    private Object extractValue(OScope.Variable var, OVarType varType) {
        if (varType instanceof OXsdTypeVarType) {
            return this.generateFromType(((OXsdTypeVarType)varType).xsdType);
        }
        if (varType instanceof OElementVarType) {
            return this.generateFromType(((OElementVarType)varType).elementType);
        }
        if (varType instanceof OMessageVarType) {
            if (((OMessageVarType)varType).parts.size() == 0) {
                throw new WrappedResolverException(__msgs.errExpressionMessageNoPart(var.name));
            }
            return this.extractValue(var, ((OMessageVarType.Part)((OMessageVarType)varType).parts.values().iterator().next()).type);
        }
        return "";
    }

    private Object generateFromType(QName typeName) {
        if (typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            if (typeName.getLocalPart().equals("int") || typeName.getLocalPart().equals("integer") || typeName.getLocalPart().equals("short") || typeName.getLocalPart().equals("long") || typeName.getLocalPart().equals("byte") || typeName.getLocalPart().equals("float") || typeName.getLocalPart().equals("double") || typeName.getLocalPart().equals("nonPositiveInteger") || typeName.getLocalPart().equals("nonNegativeInteger") || typeName.getLocalPart().equals("negativeInteger") || typeName.getLocalPart().equals("unsignedLong") || typeName.getLocalPart().equals("unsignedInt") || typeName.getLocalPart().equals("unsignedShort") || typeName.getLocalPart().equals("unsignedByte")) {
                return 0;
            }
            if (typeName.getLocalPart().equals("boolean")) {
                return Boolean.TRUE;
            }
            if (typeName.getLocalPart().equals("string")) {
                return "";
            }
        }
        Document doc = DOMUtils.newDocument();
        doc.appendChild(doc.createElement("empty"));
        return doc.getDocumentElement();
    }
}

