/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2.xquery10.compiler;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.compiler.v2.ExpressionCompiler;
import org.apache.ode.bpel.compiler.v2.xpath10.XslCompilationErrorListener;
import org.apache.ode.bpel.compiler.v2.xpath20.JaxpFunctionResolver;
import org.apache.ode.bpel.compiler.v2.xpath20.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v2.OConstantVarType;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLValueExpression;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OVarType;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xpath20.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xquery10.OXQuery10ExpressionBPEL20;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.apache.xml.utils.XMLChar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQuery10ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Log __log = LogFactory.getLog(XQuery10ExpressionCompilerImpl.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XQuery10ExpressionCompilerImpl(String bpelNS) {
        this._bpelNS = bpelNS;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.rtrep.v2.xquery10.runtime.XQuery10ExpressionRuntime");
        TransformerFactoryImpl trsf = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)trsf);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xe = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener((ErrorListener)xe);
    }

    @Override
    public OExpression compileJoinCondition(Object source) throws CompilationException {
        return this._compile((Expression)source, true);
    }

    @Override
    public OExpression compile(Object source) throws CompilationException {
        return this._compile((Expression)source, false);
    }

    @Override
    public OLValueExpression compileLValue(Object source) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)source, false);
    }

    private OExpression _compile(Expression xquery, boolean isJoinCondition) throws CompilationException {
        OXQuery10ExpressionBPEL20 oexp = new OXQuery10ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, isJoinCondition);
        oexp.namespaceCtx = xquery.getNamespaceContext();
        this.doJaxpCompile(oexp, xquery);
        return oexp;
    }

    private void doJaxpCompile(OXQuery10ExpressionBPEL20 out, Expression source) throws CompilationException {
        Node node = source.getExpression();
        if (node == null) {
            throw new IllegalStateException("XQuery string and xpath node are both null");
        }
        if (node.getNodeType() != 3 && node.getNodeType() != 1 && node.getNodeType() != 4) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString((Node)node)));
        }
        String xqueryStr = DOMUtils.domToString((Node)node);
        if ((xqueryStr = xqueryStr.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString((Node)node), "empty string"));
        }
        try {
            QName typeQName;
            SaxonXQDataSource xqds = new SaxonXQDataSource();
            XQConnection xqconn = xqds.getConnection();
            __log.debug((Object)("Compiling expression " + xqueryStr));
            Configuration configuration = ((SaxonXQConnection)xqconn).getConfiguration();
            configuration.setAllNodesUntyped(true);
            configuration.setHostLanguage(51);
            XQStaticContext staticContext = xqconn.getStaticContext();
            JaxpFunctionResolver funcResolver = new JaxpFunctionResolver(this._compilerContext, (OXPath20ExpressionBPEL20)out, source.getNamespaceContext(), this._bpelNS);
            JaxpVariableResolver variableResolver = new JaxpVariableResolver(this._compilerContext, (OXPath10ExpressionBPEL20)out);
            XQueryDeclarations declarations = new XQueryDeclarations();
            NSContext nsContext = source.getNamespaceContext();
            Set prefixes = nsContext.getPrefixes();
            if (!nsContext.getUriSet().contains("http://www.apache.org/ode/type/extension")) {
                nsContext.register("ode", "http://www.apache.org/ode/type/extension");
            }
            for (String prefix : prefixes) {
                String uri = nsContext.getNamespaceURI(prefix);
                staticContext.declareNamespace(prefix, uri);
                if ("".equals(prefix)) {
                    declarations.declareDefaultElementNamespace(uri);
                    continue;
                }
                if ("bpws".equals(prefix)) {
                    declarations.declareNamespace("bpws", "java:org.apache.ode.bpel.compiler.v2.xquery10.compiler.XQuery10BpelFunctions");
                    continue;
                }
                declarations.declareNamespace(prefix, uri);
            }
            declarations.declareVariable(this.getQName(nsContext, "http://www.apache.org/ode/type/extension", "pid"), this.getQName(nsContext, "http://www.w3.org/2001/XMLSchema", "integer"));
            Map<URI, Source> schemaDocuments = this._compilerContext.getSchemaSources();
            for (URI schemaUri : schemaDocuments.keySet()) {
                Source schemaSource = schemaDocuments.get(schemaUri);
            }
            configuration.setSchemaValidationMode(4);
            List<OScope.Variable> variables = this._compilerContext.getAccessibleVariables();
            HashMap<QName, QName> variableTypes = new HashMap<QName, QName>();
            for (String variableName : this.getVariableNames(xqueryStr)) {
                OScope.Variable variable = this.getVariable(variables, variableName);
                if (variable == null) continue;
                OVarType type = variable.type;
                QName nameQName = this.getNameQName(variableName);
                typeQName = this.getTypeQName(variableName, type);
                variableTypes.put(nameQName, typeQName);
                String prefix = typeQName.getPrefix();
                if (prefix == null || "".equals(prefix.trim())) {
                    prefix = this.getPrefixForUri(nsContext, typeQName.getNamespaceURI());
                }
                declarations.declareVariable(variableName);
            }
            out.xquery = declarations.toString() + xqueryStr;
            xqconn.setStaticContext(staticContext);
            XQPreparedExpression exp = xqconn.prepareExpression(out.xquery);
            node.setUserData("function-resolver", funcResolver, null);
            exp.bindItem(XQConstants.CONTEXT_ITEM, xqconn.createItemFromNode(node, xqconn.createNodeType()));
            for (QName variable : exp.getAllUnboundExternalVariables()) {
                typeQName = (QName)variableTypes.get(variable);
                Object value = variableResolver.resolveVariable(variable);
                if (typeQName == null) continue;
                if (value.getClass().getName().startsWith("java.lang")) {
                    exp.bindAtomicValue(variable, value.toString(), xqconn.createAtomicType(4));
                    continue;
                }
                if (value instanceof Node) {
                    exp.bindNode(variable, (Node)value, xqconn.createNodeType());
                    continue;
                }
                if (!(value instanceof NodeList)) continue;
                NodeList nodeList = (NodeList)value;
                ArrayList<Node> nodeArray = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    nodeArray.add(nodeList.item(i));
                }
                XQSequence sequence = xqconn.createSequence(nodeArray.iterator());
                exp.bindSequence(variable, sequence);
            }
            try {
                exp.executeQuery();
            }
            catch (XQException xpee) {}
        }
        catch (XQException xqe) {
            __log.debug((Object)xqe);
            __log.info((Object)("Couldn't validate properly expression " + xqueryStr));
        }
        catch (WrappedResolverException wre) {
            if (wre._compilationMsg != null) {
                throw new CompilationException(wre._compilationMsg, (Throwable)wre);
            }
            if (wre.getCause() instanceof CompilationException) {
                throw (CompilationException)wre.getCause();
            }
            throw wre;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    private String getQName(NSContext nsContext, String uri, String localPart) {
        String prefix = this.getPrefixForUri(nsContext, uri);
        return prefix == null ? localPart : prefix + ":" + localPart;
    }

    private String getPrefixForUri(NSContext nsContext, String uri) {
        Set prefixes = nsContext.getPrefixes();
        for (String prefix : prefixes) {
            String anUri = nsContext.getNamespaceURI(prefix);
            if (anUri == null || !anUri.equals(uri)) continue;
            return prefix;
        }
        return null;
    }

    private List<String> getVariableNames(String xquery) {
        ArrayList<String> variableNames = new ArrayList<String>();
        int index = xquery.indexOf("$");
        while (index != -1) {
            StringBuffer variableName = new StringBuffer();
            char ch = xquery.charAt(++index);
            while (XMLChar.isNCName((int)ch)) {
                variableName.append(ch);
                ch = xquery.charAt(++index);
            }
            variableNames.add(variableName.toString());
            xquery = xquery.substring(index);
            index = xquery.indexOf("$");
        }
        return variableNames;
    }

    private OScope.Variable getVariable(List<OScope.Variable> variables, String variableName) {
        String declaredVariable = this.getVariableDeclaredName(variableName);
        for (OScope.Variable variable : variables) {
            if (!variable.name.equals(declaredVariable)) continue;
            return variable;
        }
        return null;
    }

    private String getVariableDeclaredName(String variableReference) {
        int dotIndex = variableReference.indexOf(".");
        return dotIndex >= 0 ? variableReference.substring(0, dotIndex) : variableReference;
    }

    private String getVariablePartName(String variableReference) {
        int dotIndex = variableReference.indexOf(".");
        return dotIndex >= 0 ? variableReference.substring(dotIndex + 1) : "";
    }

    private QName getNameQName(String variableName) {
        String prefix = null;
        String localName = null;
        int colonIndex = variableName.indexOf(":");
        if (colonIndex >= 0) {
            prefix = variableName.substring(0, colonIndex);
            localName = variableName.substring(colonIndex + 1);
        } else {
            prefix = "";
            localName = variableName;
        }
        return new QName(prefix, localName);
    }

    private QName getTypeQName(String variableName, OVarType type) {
        QName typeQName = null;
        if (type instanceof OConstantVarType) {
            typeQName = new QName("http://www.w3.org/2001/XMLSchema", "string", "xs");
        } else if (type instanceof OElementVarType) {
            typeQName = ((OElementVarType)type).elementType;
        } else if (type instanceof OMessageVarType) {
            OMessageVarType.Part part = (OMessageVarType.Part)((OMessageVarType)type).parts.get(this.getVariablePartName(variableName));
            if (part != null) {
                typeQName = this.getTypeQName(variableName, part.type);
            }
        } else if (type instanceof OXsdTypeVarType) {
            typeQName = ((OXsdTypeVarType)type).xsdType;
        }
        return typeQName;
    }

    private class XQueryDeclarations {
        StringBuffer declarations = new StringBuffer();

        public void declareVariable(String name, QName type) {
            this.declareVariable(name, type.getPrefix() + ":" + type.getLocalPart());
        }

        public void declareVariable(String name, String type) {
            this.declarations.append("declare variable ").append("$").append(name).append(" as ").append(type).append(" external ").append(";\n");
        }

        public void declareVariable(String name) {
            this.declarations.append("declare variable ").append("$").append(name).append(" external ").append(";\n");
        }

        public void declareNamespace(String prefix, String uri) {
            this.declarations.append("declare namespace ").append(prefix).append("=").append("\"" + uri + "\"").append(";\n");
        }

        public void declareDefaultElementNamespace(String uri) {
            this.declarations.append("declare default element namespace ").append("\"" + uri + "\"").append(";\n");
        }

        public String toString() {
            return this.declarations.toString();
        }
    }
}

