/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.test;

import java.util.ArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class MockTransactionManager
implements TransactionManager {
    ThreadLocal<TX> _transaction = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        if (this._transaction.get() != null) {
            throw new NotSupportedException("Transaction active (nested tx not supported): " + this._transaction.get());
        }
        this._transaction.set(new TX());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        if (this._transaction.get() == null) {
            throw new IllegalStateException("Transaction not active. ");
        }
        try {
            this._transaction.get().commit();
        }
        finally {
            this._transaction.set(null);
        }
    }

    public int getStatus() throws SystemException {
        if (this._transaction.get() == null) {
            return 6;
        }
        return this._transaction.get().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this._transaction.get();
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this._transaction.get() != null) {
            throw new IllegalStateException("Transaction is active in current thread: " + this._transaction.get());
        }
        try {
            this._transaction.set((TX)tx);
        }
        catch (ClassCastException cce) {
            throw new InvalidTransactionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this._transaction.get() == null) {
            throw new IllegalStateException("Transaction not active. ");
        }
        try {
            this._transaction.get().rollback();
        }
        finally {
            this._transaction.set(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this._transaction.get() == null) {
            throw new IllegalStateException("Transaction not active. ");
        }
        this._transaction.get().setRollbackOnly();
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction suspend() throws SystemException {
        try {
            Transaction transaction = this._transaction.get();
            return transaction;
        }
        finally {
            this._transaction.set(null);
        }
    }

    protected void doBegin(TX tx) {
    }

    protected void doCommit(TX tx) {
    }

    protected void doRollback(TX tx) {
    }

    public class TX
    implements Transaction {
        final ArrayList<XAResource> _resources = new ArrayList();
        final ArrayList<Synchronization> _synchros = new ArrayList();
        private int _status;

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            switch (this._status) {
                case 3: {
                    return;
                }
                case 1: {
                    this.rollback();
                    throw new RollbackException("Transaction was marked for rollback!");
                }
                case 0: {
                    this.fireBefore();
                    if (this._status == 1) {
                        this.rollback();
                        throw new RollbackException("Transaction was marked for rollback in beforeCompletion handler.");
                    }
                    this._status = 8;
                    try {
                        MockTransactionManager.this.doCommit(this);
                        this._status = 3;
                        break;
                    }
                    catch (Exception ex) {
                        this._status = 4;
                        throw new RollbackException("Transaction was rolled back due to commit failure.");
                    }
                    finally {
                        this.fireAfter();
                    }
                }
                default: {
                    throw new IllegalStateException("Unexpected transaction state.");
                }
            }
        }

        public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
            this._resources.remove(arg0);
            return true;
        }

        public boolean enlistResource(XAResource r) throws IllegalStateException, RollbackException, SystemException {
            return this._resources.add(r);
        }

        public int getStatus() throws SystemException {
            return this._status;
        }

        public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
            this._synchros.add(synch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() throws IllegalStateException, SystemException {
            switch (this._status) {
                case 4: {
                    return;
                }
                case 0: 
                case 1: {
                    this._status = 9;
                    try {
                        MockTransactionManager.this.doRollback(this);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break;
                    }
                    finally {
                        this._status = 4;
                        this.fireAfter();
                    }
                }
                default: {
                    throw new IllegalStateException("Unexpected transaction state.");
                }
            }
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            switch (this._status) {
                case 0: 
                case 1: {
                    this._status = 1;
                    break;
                }
                case 4: 
                case 9: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private void fireBefore() {
            for (Synchronization s : this._synchros) {
                try {
                    s.beforeCompletion();
                }
                catch (Throwable throwable) {}
            }
        }

        private void fireAfter() {
            for (Synchronization s : this._synchros) {
                try {
                    s.afterCompletion(this._status);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

