/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.dao.jpa.EventDAOImpl;
import org.apache.ode.dao.jpa.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.ode.dao.jpa.ScopeDAOImpl;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELDAOConnectionImpl
implements BpelDAOConnection {
    static final Log __log = LogFactory.getLog(BPELDAOConnectionImpl.class);
    EntityManager _em;

    public BPELDAOConnectionImpl(EntityManager em) {
        this._em = em;
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        throw new UnsupportedOperationException();
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        throw new UnsupportedOperationException();
    }

    public ProcessInstanceDAO getInstance(Long iid) {
        ProcessInstanceDAOImpl instance = (ProcessInstanceDAOImpl)this._em.find(ProcessInstanceDAOImpl.class, (Object)iid);
        return instance;
    }

    public void close() {
        this._em = null;
    }

    public MessageExchangeDAO createMessageExchange(char dir) {
        MessageExchangeDAOImpl ret = new MessageExchangeDAOImpl(dir);
        this._em.persist((Object)ret);
        return ret;
    }

    public ProcessDAO createProcess(QName pid, QName type, String guid, long version) {
        ProcessDAOImpl ret = new ProcessDAOImpl(pid, type, guid, version);
        this._em.persist((Object)ret);
        return ret;
    }

    public ProcessDAO getProcess(QName processId) {
        List l = this._em.createQuery("select x from ProcessDAOImpl x where x._processId = ?1").setParameter(1, (Object)processId.toString()).getResultList();
        if (l.size() == 0) {
            return null;
        }
        ProcessDAOImpl p = (ProcessDAOImpl)l.get(0);
        return p;
    }

    public ScopeDAO getScope(Long siidl) {
        return (ScopeDAO)this._em.find(ScopeDAOImpl.class, (Object)siidl);
    }

    public void insertBpelEvent(BpelEvent event, ProcessDAO process, ProcessInstanceDAO instance) {
        EventDAOImpl eventDao = new EventDAOImpl();
        eventDao.setTstamp(new Timestamp(System.currentTimeMillis()));
        eventDao.setType(BpelEvent.eventName((BpelEvent)event));
        String evtStr = event.toString();
        eventDao.setDetail(evtStr.substring(0, Math.min(254, evtStr.length())));
        if (process != null) {
            eventDao.setProcess((ProcessDAOImpl)process);
        }
        if (instance != null) {
            eventDao.setInstance((ProcessInstanceDAOImpl)instance);
        }
        if (event instanceof ScopeEvent) {
            eventDao.setScopeId(((ScopeEvent)event).getScopeId());
        }
        eventDao.setEvent(event);
        this._em.persist((Object)eventDao);
    }

    private static String dateFilter(String filter) {
        String date = Filter.getDateWithoutOp((String)filter);
        String op = filter.substring(0, filter.indexOf(date));
        Date dt = null;
        try {
            dt = ISO8601DateParser.parse((String)date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Timestamp ts = new Timestamp(dt.getTime());
        return op + " '" + ts.toString() + "'";
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter criteria) {
        StringBuffer query = new StringBuffer();
        query.append("select pi from ProcessInstanceDAOImpl as pi");
        if (criteria != null) {
            int m;
            ArrayList<String> clauses = new ArrayList<String>();
            if (criteria.getIidFilter() != null) {
                clauses.add(" pi._instanceId = " + criteria.getIidFilter());
            }
            if (criteria.getPidFilter() != null) {
                clauses.add(" pi._process._processId = '" + criteria.getPidFilter() + "'");
            }
            if (criteria.getNameFilter() != null) {
                String val = criteria.getNameFilter();
                if (val.endsWith("*")) {
                    val = val.substring(0, val.length() - 1) + "%";
                }
                clauses.add(" pi._process._processType like '%" + val + "'");
            }
            if (criteria.getNamespaceFilter() != null) {
                clauses.add(" pi._process._processType like '{" + criteria.getNamespaceFilter() + "%'");
            }
            if (criteria.getStartedDateFilter() != null) {
                for (String ds : criteria.getStartedDateFilter()) {
                    clauses.add(" pi._dateCreated " + BPELDAOConnectionImpl.dateFilter(ds));
                }
            }
            if (criteria.getLastActiveDateFilter() != null) {
                for (String ds : criteria.getLastActiveDateFilter()) {
                    clauses.add(" pi._lastActive " + BPELDAOConnectionImpl.dateFilter(ds));
                }
            }
            if (criteria.getStatusFilter() != null) {
                StringBuffer filters = new StringBuffer();
                List states = criteria.convertFilterState();
                for (m = 0; m < states.size(); ++m) {
                    filters.append(" pi._state = ").append(states.get(m));
                    if (m >= states.size() - 1) continue;
                    filters.append(" or");
                }
                clauses.add(" (" + filters.toString() + ")");
            }
            if (criteria.getPropertyValuesFilter() != null) {
                Map props = criteria.getPropertyValuesFilter();
                query.append(" inner join pi._rootScope._correlationSets as cs");
                int i = 0;
                for (String propKey : props.keySet()) {
                    query.append(" inner join cs._props as csp" + ++i);
                    clauses.add(" csp" + i + ".propertyKey = '" + propKey + "' and csp" + i + ".propertyValue = '" + ((String)props.get(propKey)).replaceAll("&#32;", " ") + "'");
                }
            }
            StringBuffer orderby = new StringBuffer("");
            if (criteria.getOrders() != null) {
                orderby.append(" order by");
                List orders = criteria.getOrders();
                for (m = 0; m < orders.size(); ++m) {
                    String field = (String)orders.get(m);
                    String ord = " asc";
                    if (field.startsWith("-")) {
                        ord = " desc";
                    }
                    String fieldName = " pi._instanceId";
                    if (field.endsWith("name") || field.endsWith("namespace")) {
                        fieldName = " pi._process._processType";
                    }
                    if (field.endsWith("version")) {
                        fieldName = " pi._process._version";
                    }
                    if (field.endsWith("status")) {
                        fieldName = " pi._state";
                    }
                    if (field.endsWith("started")) {
                        fieldName = " pi._dateCreated";
                    }
                    if (field.endsWith("last-active")) {
                        fieldName = " pi._lastActive";
                    }
                    orderby.append(fieldName + ord);
                    if (m >= orders.size() - 1) continue;
                    orderby.append(", ");
                }
            }
            if (clauses.size() > 0) {
                query.append(" where");
                for (int m2 = 0; m2 < clauses.size(); ++m2) {
                    query.append((String)clauses.get(m2));
                    if (m2 >= clauses.size() - 1) continue;
                    query.append(" and");
                }
            }
            query.append(orderby);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)query.toString());
        }
        Query pq = this._em.createQuery(query.toString());
        OpenJPAQuery kq = OpenJPAPersistence.cast((Query)pq);
        kq.getFetchPlan().setFetchBatchSize(criteria.getLimit());
        List ql = pq.getResultList();
        ArrayList<ProcessInstanceDAO> list = new ArrayList<ProcessInstanceDAO>();
        int num = 0;
        Iterator iterator = ql.iterator();
        while (iterator.hasNext() && num++ <= criteria.getLimit()) {
            ProcessInstanceDAO processInstanceDAO = (ProcessInstanceDAO)iterator.next();
            list.add(processInstanceDAO);
        }
        return list;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String expression) {
        return this.instanceQuery(new InstanceFilter(expression));
    }

    public void setEntityManger(EntityManager em) {
        this._em = em;
    }

    public MessageExchangeDAO getMessageExchange(String mexid) {
        return (MessageExchangeDAO)this._em.find(MessageExchangeDAOImpl.class, (Object)mexid);
    }

    public EntityManager getEntityManager() {
        return this._em;
    }
}

