/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.MessageRouteDAOImpl;
import org.apache.ode.dao.jpa.OpenJPADAO;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity
@Table(name="ODE_CORRELATOR")
@NamedQueries(value={@NamedQuery(name="RouteByCKey", query="SELECT route FROM MessageRouteDAOImpl as route WHERE route._correlationKey = :ckey and route._correlator._process._processType = :ptype and route._correlator._correlatorKey = :corrkey")})
public class CorrelatorDAOImpl
extends OpenJPADAO
implements CorrelatorDAO,
PersistenceCapable {
    @Id
    @Column(name="CORRELATOR_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _correlatorId;
    @Basic
    @Column(name="CORRELATOR_KEY")
    private String _correlatorKey;
    @OneToMany(targetEntity=MessageRouteDAOImpl.class, mappedBy="_correlator", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Collection<MessageRouteDAOImpl> _routes;
    @OneToMany(targetEntity=MessageExchangeDAOImpl.class, mappedBy="_correlator", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<MessageExchangeDAOImpl> _exchanges;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="PROC_ID")
    private ProcessDAOImpl _process;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl;
    private transient Object pcDetachedState;

    public CorrelatorDAOImpl() {
        CorrelatorDAOImpl.pcSet_routes(this, new ArrayList());
        CorrelatorDAOImpl.pcSet_exchanges(this, new ArrayList());
    }

    public CorrelatorDAOImpl(String correlatorKey, ProcessDAOImpl process) {
        CorrelatorDAOImpl.pcSet_routes(this, new ArrayList());
        CorrelatorDAOImpl.pcSet_exchanges(this, new ArrayList());
        CorrelatorDAOImpl.pcSet_correlatorKey(this, correlatorKey);
        CorrelatorDAOImpl.pcSet_process(this, process);
    }

    public void addRoute(String routeGroupId, ProcessInstanceDAO target, int index, CorrelationKey correlationKey) {
        MessageRouteDAOImpl mr = new MessageRouteDAOImpl(correlationKey, routeGroupId, index, (ProcessInstanceDAOImpl)target, this);
        CorrelatorDAOImpl.pcGet_routes(this).add(mr);
    }

    public MessageExchangeDAO dequeueMessage(CorrelationKey correlationKey) {
        Iterator itr = CorrelatorDAOImpl.pcGet_exchanges(this).iterator();
        while (itr.hasNext()) {
            MessageExchangeDAOImpl mex = (MessageExchangeDAOImpl)itr.next();
            if (!mex.getCorrelationKeys().contains(correlationKey)) continue;
            itr.remove();
            return mex;
        }
        return null;
    }

    public void enqueueMessage(MessageExchangeDAO mex, CorrelationKey[] correlationKeys) {
        MessageExchangeDAOImpl mexImpl = (MessageExchangeDAOImpl)mex;
        for (CorrelationKey key : correlationKeys) {
            mexImpl.addCorrelationKey(key);
        }
        CorrelatorDAOImpl.pcGet_exchanges(this).add(mexImpl);
        mexImpl.setCorrelator(this);
    }

    public MessageRouteDAO findRoute(CorrelationKey correlationKey) {
        Query qry = this.getEM().createNamedQuery("RouteByCKey");
        qry.setParameter("ckey", (Object)correlationKey.toCanonicalString());
        qry.setParameter("ptype", (Object)CorrelatorDAOImpl.pcGet_process(this).getType().toString());
        qry.setParameter("corrkey", (Object)CorrelatorDAOImpl.pcGet_correlatorKey(this));
        List routes = qry.getResultList();
        if (routes.size() > 0) {
            return (MessageRouteDAO)routes.get(0);
        }
        return null;
    }

    public String getCorrelatorId() {
        return CorrelatorDAOImpl.pcGet_correlatorKey(this);
    }

    public void removeRoutes(String routeGroupId, ProcessInstanceDAO target) {
        ((ProcessInstanceDAOImpl)target).removeRoutes(routeGroupId);
    }

    void removeLocalRoutes(String routeGroupId, ProcessInstanceDAO target) {
        Iterator itr = CorrelatorDAOImpl.pcGet_routes(this).iterator();
        while (itr.hasNext()) {
            MessageRouteDAOImpl mr = (MessageRouteDAOImpl)itr.next();
            if (!mr.getGroupId().equals(routeGroupId) || !mr.getTargetInstance().equals(target)) continue;
            itr.remove();
            this.getEM().remove((Object)mr);
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"_correlatorId", "_correlatorKey", "_exchanges", "_process", "_routes"};
        Class[] classArray = new Class[5];
        Class clazz = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = CorrelatorDAOImpl.class$("java.lang.Long"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CorrelatorDAOImpl.class$("java.lang.String"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = CorrelatorDAOImpl.class$("java.util.Collection"));
        classArray[2] = clazz3;
        Class clazz4 = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = CorrelatorDAOImpl.class$("java.util.Collection"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 5, 5, 10};
        Class clazz5 = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"CorrelatorDAOImpl", (PersistenceCapable)new CorrelatorDAOImpl());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._correlatorId = null;
        this._correlatorKey = null;
        this._exchanges = null;
        this._process = null;
        this._routes = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        CorrelatorDAOImpl correlatorDAOImpl = new CorrelatorDAOImpl();
        if (bl) {
            correlatorDAOImpl.pcClearFields();
        }
        correlatorDAOImpl.pcStateManager = stateManager;
        correlatorDAOImpl.pcCopyKeyFieldsFromObjectId(object);
        return correlatorDAOImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        CorrelatorDAOImpl correlatorDAOImpl = new CorrelatorDAOImpl();
        if (bl) {
            correlatorDAOImpl.pcClearFields();
        }
        correlatorDAOImpl.pcStateManager = stateManager;
        return correlatorDAOImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._correlatorId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._correlatorKey = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._exchanges = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._process = (ProcessDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._routes = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._correlatorId);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._correlatorKey);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._exchanges);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._process);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._routes);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(CorrelatorDAOImpl correlatorDAOImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._correlatorId = correlatorDAOImpl._correlatorId;
                return;
            }
            case 1: {
                this._correlatorKey = correlatorDAOImpl._correlatorKey;
                return;
            }
            case 2: {
                this._exchanges = correlatorDAOImpl._exchanges;
                return;
            }
            case 3: {
                this._process = correlatorDAOImpl._process;
                return;
            }
            case 4: {
                this._routes = correlatorDAOImpl._routes;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        CorrelatorDAOImpl correlatorDAOImpl = (CorrelatorDAOImpl)object;
        if (correlatorDAOImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(correlatorDAOImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(0 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this._correlatorId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        return new LongId(clazz, this._correlatorId);
    }

    private static final Long pcGet_correlatorId(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._correlatorId;
        }
        int n = pcInheritedFieldCount + 0;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._correlatorId;
    }

    private static final void pcSet_correlatorId(CorrelatorDAOImpl correlatorDAOImpl, Long l) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._correlatorId = l;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 0, (Object)correlatorDAOImpl._correlatorId, (Object)l, 0);
    }

    private static final String pcGet_correlatorKey(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._correlatorKey;
        }
        int n = pcInheritedFieldCount + 1;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._correlatorKey;
    }

    private static final void pcSet_correlatorKey(CorrelatorDAOImpl correlatorDAOImpl, String string) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._correlatorKey = string;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingStringField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 1, correlatorDAOImpl._correlatorKey, string, 0);
    }

    private static final Collection pcGet_exchanges(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._exchanges;
        }
        int n = pcInheritedFieldCount + 2;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._exchanges;
    }

    private static final void pcSet_exchanges(CorrelatorDAOImpl correlatorDAOImpl, Collection collection) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._exchanges = collection;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 2, correlatorDAOImpl._exchanges, (Object)collection, 0);
    }

    private static final ProcessDAOImpl pcGet_process(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._process;
        }
        int n = pcInheritedFieldCount + 3;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._process;
    }

    private static final void pcSet_process(CorrelatorDAOImpl correlatorDAOImpl, ProcessDAOImpl processDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._process = processDAOImpl;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 3, (Object)correlatorDAOImpl._process, (Object)processDAOImpl, 0);
    }

    private static final Collection pcGet_routes(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._routes;
        }
        int n = pcInheritedFieldCount + 4;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._routes;
    }

    private static final void pcSet_routes(CorrelatorDAOImpl correlatorDAOImpl, Collection collection) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._routes = collection;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 4, correlatorDAOImpl._routes, (Object)collection, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

