/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.OpenJPADAO;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ODE_PROCESS")
@NamedQueries(value={@NamedQuery(name="InstanceByCKey", query="SELECT cs._scope._processInstance FROM CorrelationSetDAOImpl as cs WHERE cs._correlationKey = :ckey"), @NamedQuery(name="CorrelatorByKey", query="SELECT c FROM CorrelatorDAOImpl as c WHERE c._correlatorKey = :ckey AND c._process = :process")})
public class ProcessDAOImpl
extends OpenJPADAO
implements PersistenceCapable,
ProcessDAO {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Basic
    @Column(name="PROCESS_ID")
    private String _processId;
    @Transient
    private int _numInstances;
    @Basic
    @Column(name="PROCESS_TYPE")
    private String _processType;
    @Basic
    @Column(name="GUID")
    private String _guid;
    @Basic
    @Column(name="VERSION")
    private long _version;
    @OneToMany(targetEntity=CorrelatorDAOImpl.class, mappedBy="_process", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<CorrelatorDAOImpl> _correlators;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl;
    private transient Object pcDetachedState;

    public ProcessDAOImpl() {
        ProcessDAOImpl.pcSet_correlators(this, new ArrayList());
    }

    public ProcessDAOImpl(QName pid, QName type, String guid, long version) {
        ProcessDAOImpl.pcSet_correlators(this, new ArrayList());
        ProcessDAOImpl.pcSet_processId(this, pid.toString());
        ProcessDAOImpl.pcSet_processType(this, type.toString());
        ProcessDAOImpl.pcSet_guid(this, guid);
        ProcessDAOImpl.pcSet_version(this, version);
    }

    public CorrelatorDAO addCorrelator(String correlator) {
        CorrelatorDAOImpl corr = new CorrelatorDAOImpl(correlator, this);
        ProcessDAOImpl.pcGet_correlators(this).add(corr);
        return corr;
    }

    public CorrelatorDAO getCorrelator(String correlatorId) {
        Query qry = this.getEM().createNamedQuery("CorrelatorByKey");
        qry.setParameter("ckey", (Object)correlatorId);
        qry.setParameter("process", (Object)this);
        List res = qry.getResultList();
        if (res.size() == 0) {
            return null;
        }
        return (CorrelatorDAO)res.get(0);
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO instantiatingCorrelator) {
        ProcessInstanceDAOImpl inst = new ProcessInstanceDAOImpl((CorrelatorDAOImpl)instantiatingCorrelator, this);
        this.getEM().persist((Object)inst);
        ++this._numInstances;
        return inst;
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey ckey) {
        Query qry = this.getEM().createNamedQuery("InstanceByCKey");
        qry.setParameter("ckey", (Object)ckey.toCanonicalString());
        return qry.getResultList();
    }

    public ProcessInstanceDAO getInstance(Long iid) {
        return (ProcessInstanceDAO)this.getEM().find(ProcessInstanceDAOImpl.class, (Object)iid);
    }

    public QName getProcessId() {
        return QName.valueOf(ProcessDAOImpl.pcGet_processId(this));
    }

    public QName getType() {
        return QName.valueOf(ProcessDAOImpl.pcGet_processType(this));
    }

    public void delete() {
        this.getEM().remove((Object)this);
    }

    public int getNumInstances() {
        return this._numInstances;
    }

    public long getVersion() {
        return ProcessDAOImpl.pcGet_version(this);
    }

    public void instanceCompleted(ProcessInstanceDAO instance) {
    }

    public void removeRoutes(String routeId, ProcessInstanceDAO target) {
        for (CorrelatorDAOImpl c : ProcessDAOImpl.pcGet_correlators(this)) {
            c.removeLocalRoutes(routeId, target);
        }
    }

    public String getGuid() {
        return ProcessDAOImpl.pcGet_guid(this);
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"_correlators", "_guid", "_id", "_processId", "_processType", "_version"};
        Class[] classArray = new Class[6];
        Class clazz = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = ProcessDAOImpl.class$("java.util.Collection"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ProcessDAOImpl.class$("java.lang.String"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = ProcessDAOImpl.class$("java.lang.Long"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ProcessDAOImpl.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ProcessDAOImpl.class$("java.lang.String"));
        classArray[5] = Long.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = ProcessDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"ProcessDAOImpl", (PersistenceCapable)new ProcessDAOImpl());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._correlators = null;
        this._guid = null;
        this._id = null;
        this._processId = null;
        this._processType = null;
        this._version = 0L;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        ProcessDAOImpl processDAOImpl = new ProcessDAOImpl();
        if (bl) {
            processDAOImpl.pcClearFields();
        }
        processDAOImpl.pcStateManager = stateManager;
        processDAOImpl.pcCopyKeyFieldsFromObjectId(object);
        return processDAOImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        ProcessDAOImpl processDAOImpl = new ProcessDAOImpl();
        if (bl) {
            processDAOImpl.pcClearFields();
        }
        processDAOImpl.pcStateManager = stateManager;
        return processDAOImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 6;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._correlators = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._guid = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._processId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._processType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this._version = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._correlators);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._guid);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._id);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._processId);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._processType);
                return;
            }
            case 5: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this._version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(ProcessDAOImpl processDAOImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._correlators = processDAOImpl._correlators;
                return;
            }
            case 1: {
                this._guid = processDAOImpl._guid;
                return;
            }
            case 2: {
                this._id = processDAOImpl._id;
                return;
            }
            case 3: {
                this._processId = processDAOImpl._processId;
                return;
            }
            case 4: {
                this._processType = processDAOImpl._processType;
                return;
            }
            case 5: {
                this._version = processDAOImpl._version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        ProcessDAOImpl processDAOImpl = (ProcessDAOImpl)object;
        if (processDAOImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(processDAOImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(2 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this._id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = ProcessDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = ProcessDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        return new LongId(clazz, this._id);
    }

    private static final Collection pcGet_correlators(ProcessDAOImpl processDAOImpl) {
        if (processDAOImpl.pcStateManager == null) {
            return processDAOImpl._correlators;
        }
        int n = pcInheritedFieldCount + 0;
        processDAOImpl.pcStateManager.accessingField(n);
        return processDAOImpl._correlators;
    }

    private static final void pcSet_correlators(ProcessDAOImpl processDAOImpl, Collection collection) {
        if (processDAOImpl.pcStateManager == null) {
            processDAOImpl._correlators = collection;
            return;
        }
        processDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processDAOImpl, pcInheritedFieldCount + 0, processDAOImpl._correlators, (Object)collection, 0);
    }

    private static final String pcGet_guid(ProcessDAOImpl processDAOImpl) {
        if (processDAOImpl.pcStateManager == null) {
            return processDAOImpl._guid;
        }
        int n = pcInheritedFieldCount + 1;
        processDAOImpl.pcStateManager.accessingField(n);
        return processDAOImpl._guid;
    }

    private static final void pcSet_guid(ProcessDAOImpl processDAOImpl, String string) {
        if (processDAOImpl.pcStateManager == null) {
            processDAOImpl._guid = string;
            return;
        }
        processDAOImpl.pcStateManager.settingStringField((PersistenceCapable)processDAOImpl, pcInheritedFieldCount + 1, processDAOImpl._guid, string, 0);
    }

    private static final Long pcGet_id(ProcessDAOImpl processDAOImpl) {
        if (processDAOImpl.pcStateManager == null) {
            return processDAOImpl._id;
        }
        int n = pcInheritedFieldCount + 2;
        processDAOImpl.pcStateManager.accessingField(n);
        return processDAOImpl._id;
    }

    private static final void pcSet_id(ProcessDAOImpl processDAOImpl, Long l) {
        if (processDAOImpl.pcStateManager == null) {
            processDAOImpl._id = l;
            return;
        }
        processDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processDAOImpl, pcInheritedFieldCount + 2, (Object)processDAOImpl._id, (Object)l, 0);
    }

    private static final String pcGet_processId(ProcessDAOImpl processDAOImpl) {
        if (processDAOImpl.pcStateManager == null) {
            return processDAOImpl._processId;
        }
        int n = pcInheritedFieldCount + 3;
        processDAOImpl.pcStateManager.accessingField(n);
        return processDAOImpl._processId;
    }

    private static final void pcSet_processId(ProcessDAOImpl processDAOImpl, String string) {
        if (processDAOImpl.pcStateManager == null) {
            processDAOImpl._processId = string;
            return;
        }
        processDAOImpl.pcStateManager.settingStringField((PersistenceCapable)processDAOImpl, pcInheritedFieldCount + 3, processDAOImpl._processId, string, 0);
    }

    private static final String pcGet_processType(ProcessDAOImpl processDAOImpl) {
        if (processDAOImpl.pcStateManager == null) {
            return processDAOImpl._processType;
        }
        int n = pcInheritedFieldCount + 4;
        processDAOImpl.pcStateManager.accessingField(n);
        return processDAOImpl._processType;
    }

    private static final void pcSet_processType(ProcessDAOImpl processDAOImpl, String string) {
        if (processDAOImpl.pcStateManager == null) {
            processDAOImpl._processType = string;
            return;
        }
        processDAOImpl.pcStateManager.settingStringField((PersistenceCapable)processDAOImpl, pcInheritedFieldCount + 4, processDAOImpl._processType, string, 0);
    }

    private static final long pcGet_version(ProcessDAOImpl processDAOImpl) {
        if (processDAOImpl.pcStateManager == null) {
            return processDAOImpl._version;
        }
        int n = pcInheritedFieldCount + 5;
        processDAOImpl.pcStateManager.accessingField(n);
        return processDAOImpl._version;
    }

    private static final void pcSet_version(ProcessDAOImpl processDAOImpl, long l) {
        if (processDAOImpl.pcStateManager == null) {
            processDAOImpl._version = l;
            return;
        }
        processDAOImpl.pcStateManager.settingLongField((PersistenceCapable)processDAOImpl, pcInheritedFieldCount + 5, processDAOImpl._version, l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

