/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelInstanceWorker
implements Runnable {
    private static final Log __log = LogFactory.getLog(BpelInstanceWorker.class);
    final ODEProcess _process;
    final Long _iid;
    final Contexts _contexts;
    private boolean _running = false;
    private ArrayList<Runnable> _todoQueue = new ArrayList();
    private final ThreadLocal<Long> _activeInstance = new ThreadLocal();
    private Thread _workerThread;
    private CachedState _cachedState;

    BpelInstanceWorker(ODEProcess process, Long iid) {
        this._process = process;
        this._iid = iid;
        this._contexts = this._process._contexts;
    }

    Long getIID() {
        return this._iid;
    }

    synchronized void enqueue(Runnable runnable) {
        __log.debug((Object)("enqueue: for instance " + this._process.getPID() + "#" + this._iid + ": " + runnable));
        this._todoQueue.add(runnable);
        if (!this._running) {
            this._running = true;
            this._process.enqueueRunnable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execInCurrentThread(Callable<T> callable) throws Exception {
        if (this.isWorkerThread()) {
            return this.doInstanceWork(callable);
        }
        final Semaphore ready = new Semaphore(0);
        final Semaphore finished = new Semaphore(0);
        this.enqueue(new Runnable(){

            public void run() {
                ready.release();
                try {
                    finished.acquire();
                }
                catch (InterruptedException ie) {
                    __log.error((Object)"Thread interrupted.", (Throwable)ie);
                    throw new BpelEngineException("Thread interrupted.", (Throwable)ie);
                }
            }
        });
        try {
            ready.acquire();
        }
        catch (InterruptedException ex) {
            __log.error((Object)"Thread interrupted.", (Throwable)ex);
            throw new BpelEngineException("Thread interrupted.", (Throwable)ex);
        }
        try {
            T t = this.doInstanceWork(callable);
            return t;
        }
        finally {
            finished.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        __log.debug((Object)("Starting worker thread " + Thread.currentThread() + " for instance IID " + this.instanceId()));
        this._activeInstance.set(this._iid);
        this._workerThread = Thread.currentThread();
        try {
            while (true) {
                Runnable next;
                BpelInstanceWorker bpelInstanceWorker = this;
                synchronized (bpelInstanceWorker) {
                    block11: {
                        if (!this._todoQueue.isEmpty()) break block11;
                        this._running = false;
                        __log.debug((Object)("Worker thread " + Thread.currentThread() + " for instance IID " + this._iid + " ran out of work. "));
                        return;
                    }
                    next = this._todoQueue.remove(0);
                }
                try {
                    this.doInstanceWork(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            next.run();
                            return null;
                        }
                    });
                }
                catch (Throwable t) {
                    __log.fatal((Object)("Unexpected error in instance " + this._iid + " thread " + Thread.currentThread() + "; the error was not handled, it is likely that this has corrupted the state of the" + "instance!"), t);
                }
            }
        }
        finally {
            this._activeInstance.set(null);
            this._workerThread = null;
        }
    }

    private <T> T doInstanceWork(Callable<T> work) throws Exception {
        __log.debug((Object)("Doing work for instance " + this.instanceId() + " in thread " + Thread.currentThread()));
        this._activeInstance.set(this._iid);
        try {
            T t = work.call();
            return t;
        }
        catch (Exception ex) {
            __log.error((Object)("Work for instance " + this.instanceId() + " in thread " + Thread.currentThread() + " resulted in an exception."), (Throwable)ex);
            throw ex;
        }
        finally {
            this._activeInstance.set(null);
            __log.debug((Object)("Finished work for instance " + this.instanceId() + " in thread " + Thread.currentThread()));
        }
    }

    public String toString() {
        return "{BpelInstanceWorker for " + this.instanceId() + "}";
    }

    boolean isWorkerThread() {
        return this._activeInstance.get() != null;
    }

    Object getCachedState(Object uuid) {
        CachedState cs = this._cachedState;
        if (cs != null && cs.uuid.equals(uuid)) {
            return cs.state;
        }
        return null;
    }

    void setCachedState(Object uuid, Object state) {
        this._cachedState = new CachedState(uuid, state);
    }

    private String instanceId() {
        return this._process.getPID() + "#" + this._iid;
    }

    private class CachedState {
        final Object uuid;
        final Object state;

        CachedState(Object uuid, Object state) {
            this.uuid = uuid;
            this.state = state;
        }
    }
}

