/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.ODEProcess;

class BpelInstanceWorkerCache {
    private HashMap<Long, WeakReference<BpelInstanceWorker>> _cache = new HashMap();
    private ReferenceQueue<BpelInstanceWorker> _refQ = new ReferenceQueue();
    private ODEProcess _process;

    public BpelInstanceWorkerCache(ODEProcess process) {
        this._process = process;
    }

    synchronized BpelInstanceWorker get(long iid) {
        BpelInstanceWorker worker;
        this.expungeStaleEntries();
        WeakReference<BpelInstanceWorker> wref = this._cache.get(iid);
        if (wref == null) {
            worker = new BpelInstanceWorker(this._process, iid);
            wref = new WeakReference<BpelInstanceWorker>(worker, this._refQ);
            this._cache.put(iid, wref);
        } else {
            worker = (BpelInstanceWorker)wref.get();
            if (worker == null) {
                worker = new BpelInstanceWorker(this._process, iid);
                wref = new WeakReference<BpelInstanceWorker>(worker, this._refQ);
                this._cache.put(iid, wref);
            }
        }
        return worker;
    }

    private void expungeStaleEntries() {
        Reference<BpelInstanceWorker> x;
        while ((x = this._refQ.poll()) != null) {
            this._cache.values().remove(x);
        }
    }
}

