/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.rapi.CorrelationSet;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rapi.NoSuchOperationException;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRTInstanceContext;
import org.apache.ode.bpel.rapi.PartnerLink;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.Selector;
import org.apache.ode.bpel.rapi.UninitializedPartnerEPR;
import org.apache.ode.bpel.rapi.UninitializedVariableException;
import org.apache.ode.bpel.rapi.Variable;
import org.apache.ode.bpel.rapi.VariableContext;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.QNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelRuntimeContextImpl
implements OdeRTInstanceContext {
    private static final Log __log = LogFactory.getLog(BpelRuntimeContextImpl.class);
    private ProcessInstanceDAO _dao;
    private final Long _iid;
    private MessageExchangeDAO _instantiatingMessageExchange;
    private BpelInstanceWorker _instanceWorker;
    private ODEProcess _bpelProcess;
    private Contexts _contexts;
    private boolean _forceFlush;
    private boolean _forceRollback;
    private int _retryCount;
    private boolean _atomicScope;
    final OdeRTInstance _rti;
    private long _maxReductionTimeMs = 2000000L;
    private boolean _instanceCleanedUp = false;

    public BpelRuntimeContextImpl(BpelInstanceWorker instanceWorker, ProcessInstanceDAO instanceDAO, OdeRTInstance rti) {
        this._instanceWorker = instanceWorker;
        this._bpelProcess = instanceWorker._process;
        this._contexts = instanceWorker._contexts;
        this._dao = instanceDAO;
        this._iid = instanceDAO.getInstanceId();
        this._rti = rti;
        this._rti.setContext((OdeRTInstanceContext)this);
    }

    public String toString() {
        return "{BpelRuntimeCtx PID=" + this._bpelProcess.getPID() + ", IID=" + this._iid + "}";
    }

    public Long getPid() {
        return this._iid;
    }

    public long genId() {
        return this._dao.genMonotonic();
    }

    public int getRetryCount() {
        return this._retryCount;
    }

    public void setRetryCount(int retryCount) {
        this._retryCount = retryCount;
    }

    public boolean isCorrelationInitialized(CorrelationSet correlationSet) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(correlationSet.getScopeId()));
        CorrelationSetDAO cs = scopeDAO.getCorrelationSet(correlationSet.getName());
        return cs.getValue() != null;
    }

    public boolean isVariableInitialized(Variable var) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(var.getScopeId()));
        XmlDataDAO dataDAO = scopeDAO.getVariable(var.getName());
        return !dataDAO.isNull();
    }

    public Node initializeVariable(Variable variable, Node initData) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO dataDAO = scopeDAO.getVariable(variable.getName());
        dataDAO.set(initData);
        return dataDAO.get();
    }

    public boolean isPartnerRoleEndpointInitialized(PartnerLink pLink) {
        PartnerLinkDAO spl = this.fetchPartnerLinkDAO(pLink);
        return spl.getPartnerEPR() != null || this._bpelProcess.getInitialPartnerRoleEPR(pLink.getModel()) != null;
    }

    public void completedFault(FaultInfo faultData) {
        if (ODEProcess.__log.isDebugEnabled()) {
            ODEProcess.__log.debug((Object)("ProcessImpl completed with fault '" + faultData.getFaultName() + "'"));
        }
        this._dao.setFault(faultData.getFaultName(), faultData.getExplanation(), faultData.getFaultLineNo(), faultData.getActivityId(), faultData.getFaultMessage());
        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
        evt.setOldState(this._dao.getState());
        this._dao.setState((short)40);
        evt.setNewState((short)40);
        this.sendEvent((ProcessInstanceEvent)evt);
        this.sendEvent((ProcessInstanceEvent)new ProcessCompletionEvent(faultData.getFaultName()));
        this._dao.finishCompletion();
        this._instanceCleanedUp = this._dao.delete(this._bpelProcess.getCleanupCategories(false));
    }

    public void completedOk() {
        if (ODEProcess.__log.isDebugEnabled()) {
            ODEProcess.__log.debug((Object)("ProcessImpl " + this._bpelProcess.getPID() + " completed OK."));
        }
        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
        evt.setOldState(this._dao.getState());
        this._dao.setState((short)30);
        evt.setNewState((short)30);
        this.sendEvent((ProcessInstanceEvent)evt);
        this.sendEvent((ProcessInstanceEvent)new ProcessCompletionEvent(null));
        this._dao.finishCompletion();
        this._instanceCleanedUp = this._dao.delete(this._bpelProcess.getCleanupCategories(true));
    }

    public Long createScopeInstance(Long parentScopeId, String name, int modelId) {
        if (ODEProcess.__log.isTraceEnabled()) {
            ODEProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"createScopeInstance", (Object[])new Object[]{"parentScopeId", parentScopeId, "name", name}));
        }
        ScopeDAO parent = null;
        if (parentScopeId != null) {
            parent = this._dao.getScope(parentScopeId);
        }
        ScopeDAO scopeDao = this._dao.createScope(parent, name, modelId);
        return scopeDao.getScopeInstanceId();
    }

    public void initializePartnerLinks(Long parentScopeId, Collection<? extends PartnerLinkModel> partnerLinks) {
        if (ODEProcess.__log.isTraceEnabled()) {
            ODEProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"initializeEndpointReferences", (Object[])new Object[]{"parentScopeId", parentScopeId, "partnerLinks", partnerLinks}));
        }
        ScopeDAO parent = this._dao.getScope(parentScopeId);
        for (PartnerLinkModel partnerLinkModel : partnerLinks) {
            PartnerLinkDAO pdao = parent.createPartnerLink(partnerLinkModel.getId(), partnerLinkModel.getName(), partnerLinkModel.getMyRoleName(), partnerLinkModel.getPartnerRoleName());
            if (!partnerLinkModel.hasMyRole()) continue;
            pdao.setMySessionId(new GUID().toString());
        }
    }

    public void select(String selectChannelId, Date timeout, Selector[] selectors) {
        if (ODEProcess.__log.isTraceEnabled()) {
            ODEProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"select", (Object[])new Object[]{"pickResponseChannel", selectChannelId, "timeout", timeout, "selectors", selectors}));
        }
        ProcessDAO processDao = this._dao.getProcess();
        if (this._dao.getState() == 0) {
            ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
            evt.setOldState((short)0);
            this._dao.setState((short)10);
            evt.setNewState((short)10);
            this.sendEvent((ProcessInstanceEvent)evt);
        }
        ArrayList<CorrelatorDAO> correlators = new ArrayList<CorrelatorDAO>(selectors.length);
        for (Selector selector : selectors) {
            String correlatorId = ODEProcess.genCorrelatorId(selector.getPartnerLink().getModel(), selector.getOperation());
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)("SELECT: " + selectChannelId + ": USING CORRELATOR " + correlatorId));
            }
            correlators.add(processDao.getCorrelator(correlatorId));
        }
        if (this._instantiatingMessageExchange != null && this._dao.getState() == 10) {
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)("SELECT: " + selectChannelId + ": CHECKING for NEW INSTANCE match"));
            }
            for (int i = 0; i < correlators.size(); ++i) {
                CorrelatorDAO ci = (CorrelatorDAO)correlators.get(i);
                if (!ci.equals(this._dao.getInstantiatingCorrelator())) continue;
                this.injectMyRoleMessageExchange(selectChannelId, i, this._instantiatingMessageExchange);
                if (ODEProcess.__log.isDebugEnabled()) {
                    ODEProcess.__log.debug((Object)("SELECT: " + selectChannelId + ": FOUND match for NEW instance mexRef=" + this._instantiatingMessageExchange));
                }
                return;
            }
        }
        if (timeout != null) {
            this.registerTimer(selectChannelId, timeout);
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)("SELECT: " + selectChannelId + "REGISTERED TIMEOUT for " + timeout));
            }
        }
        for (int i = 0; i < selectors.length; ++i) {
            CorrelatorDAO correlator = (CorrelatorDAO)correlators.get(i);
            Selector selector = selectors[i];
            correlator.addRoute(selectChannelId, this._dao, i, selector.getCorrelationKey());
            this.scheduleCorrelatorMatcher(correlator.getCorrelatorId(), selector.getCorrelationKey());
            if (!ODEProcess.__log.isDebugEnabled()) continue;
            ODEProcess.__log.debug((Object)("SELECT: " + selectChannelId + ": ADDED ROUTE " + correlator.getCorrelatorId() + ": " + selector.getCorrelationKey() + " --> " + this._dao.getInstanceId()));
        }
    }

    public CorrelationKey readCorrelation(CorrelationSet cset) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(cset.getScopeId()));
        CorrelationSetDAO cs = scopeDAO.getCorrelationSet(cset.getName());
        return cs.getValue();
    }

    public Element fetchPartnerRoleEndpointReferenceData(PartnerLink pLink) {
        EndpointReference e;
        PartnerLinkDAO pl = this.fetchPartnerLinkDAO(pLink);
        Element epr = pl.getPartnerEPR();
        if (epr == null && (e = this._bpelProcess.getInitialPartnerRoleEPR(pLink.getModel())) != null) {
            epr = e.toXML().getDocumentElement();
        }
        return epr;
    }

    public Element fetchMyRoleEndpointReferenceData(PartnerLink pLink) {
        return this._bpelProcess.getInitialMyRoleEPR(pLink.getModel()).toXML().getDocumentElement();
    }

    private PartnerLinkDAO fetchPartnerLinkDAO(PartnerLink pLink) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(pLink.getScopeId()));
        return scopeDAO.getPartnerLink(pLink.getModel().getId());
    }

    public String readVariableProperty(Variable variable, QName property) throws UninitializedVariableException {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO dataDAO = scopeDAO.getVariable(variable.getName());
        if (dataDAO.isNull()) {
            throw new UninitializedVariableException();
        }
        return dataDAO.getProperty(QNameUtils.fromQName((QName)property));
    }

    public Node fetchVariableData(Variable variable, boolean forWriting) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO dataDAO = scopeDAO.getVariable(variable.getName());
        if (dataDAO.isNull()) {
            return null;
        }
        return dataDAO.get();
    }

    public void writeEndpointReference(PartnerLink partnerLink, Element data) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Writing endpoint reference " + partnerLink.getName() + " with value " + DOMUtils.domToString((Node)data)));
        }
        PartnerLinkDAO eprDAO = this.fetchPartnerLinkDAO(partnerLink);
        eprDAO.setPartnerEPR(data);
    }

    public String fetchEndpointSessionId(PartnerLink pLink, boolean isMyEPR) throws FaultException {
        PartnerLinkDAO dao = this.fetchPartnerLinkDAO(pLink);
        return isMyEPR ? dao.getMySessionId() : dao.getPartnerSessionId();
    }

    public Node convertEndpointReference(Element sourceNode, Node targetNode) {
        QName nodeQName = targetNode.getNodeType() == 3 ? new QName("http://www.w3.org/2001/XMLSchema", "string") : new QName(targetNode.getNamespaceURI(), targetNode.getLocalName());
        return this._contexts.eprContext.convertEndpoint(nodeQName, sourceNode).toXML();
    }

    public void commitChanges(Variable variable, Node changes) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO dataDAO = scopeDAO.getVariable(variable.getName());
        dataDAO.set(changes);
    }

    public void writeVariableProperty(Variable variable, QName property, String value) throws UninitializedVariableException {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO dataDAO = scopeDAO.getVariable(variable.getName());
        if (dataDAO.isNull()) {
            throw new UninitializedVariableException();
        }
        dataDAO.setProperty(QNameUtils.fromQName((QName)property), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(String mexId, PartnerLink plink, String opName, Element msg, QName fault) throws NoSuchOperationException {
        MessageExchange.AckType ackType;
        ProcessMessageExchangeEvent evt = new ProcessMessageExchangeEvent();
        evt.setMexId(mexId);
        evt.setOperation(opName);
        evt.setPortType(plink.getModel().getMyRolePortType().getQName());
        MessageExchangeDAO myrolemex = this._dao.getConnection().getMessageExchange(mexId);
        Operation operation = plink.getModel().getMyRoleOperation(opName);
        if (operation == null || operation.getOutput() == null) {
            throw new NoSuchOperationException();
        }
        MessageDAO message = myrolemex.createMessage(operation.getOutput().getMessage().getQName());
        this.buildOutgoingMessage(message, msg);
        myrolemex.setResponse(message);
        if (fault != null) {
            ackType = MessageExchange.AckType.FAULT;
            myrolemex.setFault(fault);
            evt.setAspect((short)2);
        } else {
            ackType = MessageExchange.AckType.RESPONSE;
            evt.setAspect((short)1);
        }
        MessageExchange.Status previousStatus = myrolemex.getStatus();
        myrolemex.setStatus(MessageExchange.Status.ACK);
        myrolemex.setAckType(ackType);
        try {
            this._bpelProcess.onMyRoleMexAck(myrolemex, previousStatus);
        }
        catch (Throwable throwable) {
            if (myrolemex.getPipedMessageExchangeId() != null) {
                myrolemex.release(this._bpelProcess.isCleanupCategoryEnabled(myrolemex.getAckType() == MessageExchange.AckType.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
            }
            throw throwable;
        }
        if (myrolemex.getPipedMessageExchangeId() != null) {
            myrolemex.release(this._bpelProcess.isCleanupCategoryEnabled(myrolemex.getAckType() == MessageExchange.AckType.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        }
        this.sendEvent((ProcessInstanceEvent)evt);
    }

    public void writeCorrelation(CorrelationSet cset, QName[] propNames, CorrelationKey correlation) throws FaultException {
        Collection instances;
        ProcessDAO processDAO = this._dao.getProcess();
        if (correlation.isUnique() && (instances = processDAO.findInstance(correlation, false)).size() != 0) {
            __log.debug((Object)("Not creating a new instance for process " + processDAO.getProcessId() + "; unique correlation constraint would be violated!"));
            throw new FaultException(cset.getOwner().getConstantsModel().getDuplicateInstance());
        }
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(cset.getScopeId()));
        CorrelationSetDAO cs = scopeDAO.getCorrelationSet(cset.getName());
        cs.setValue(propNames, correlation);
        CorrelationSetWriteEvent cswe = new CorrelationSetWriteEvent(cset.getName(), correlation);
        cswe.setScopeId(Long.valueOf(cset.getScopeId()));
        this.sendEvent((ProcessInstanceEvent)cswe);
    }

    public void terminate() {
        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
        evt.setOldState(this._dao.getState());
        this._dao.setState((short)60);
        evt.setNewState((short)60);
        this.sendEvent((ProcessInstanceEvent)evt);
        this.sendEvent((ProcessInstanceEvent)new ProcessTerminationEvent());
        this._dao.finishCompletion();
    }

    public void registerTimer(String timerChannelId, Date timeToFire) {
        WorkEvent we = new WorkEvent();
        we.setIID(this._dao.getInstanceId());
        we.setProcessId(this._bpelProcess.getPID());
        we.setChannel(timerChannelId);
        we.setType(WorkEvent.Type.TIMER);
        this._bpelProcess.scheduleWorkEvent(we, timeToFire);
    }

    private void scheduleCorrelatorMatcher(String correlatorId, CorrelationKey key) {
        WorkEvent we = new WorkEvent();
        we.setIID(this._dao.getInstanceId());
        we.setProcessId(this._bpelProcess.getPID());
        we.setType(WorkEvent.Type.MATCHER);
        we.setCorrelatorId(correlatorId);
        we.setCorrelationKey(key);
        this._bpelProcess.scheduleWorkEvent(we, null);
    }

    public String invoke(String requestId, PartnerLink partnerLink, Operation operation, Element outgoingMessage) throws UninitializedPartnerEPR {
        EndpointReference partnerEpr;
        MessageExchangeDAO mexDao = this._dao.getConnection().createMessageExchange(new GUID().toString(), 'P');
        mexDao.setStatus(MessageExchange.Status.REQ);
        mexDao.setOperation(operation.getName());
        mexDao.setPortType(partnerLink.getModel().getPartnerRolePortType().getQName());
        mexDao.setPartnerLinkModelId(partnerLink.getModel().getId());
        PartnerRoleChannel partnerRoleChannel = this._bpelProcess.getPartnerRoleChannel(partnerLink.getModel());
        PartnerLinkDAO plinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        Element partnerEPR = plinkDAO.getPartnerEPR();
        if (partnerEPR == null) {
            partnerEpr = partnerRoleChannel.getInitialEndpointReference();
            if (partnerEpr == null) {
                throw new UninitializedPartnerEPR();
            }
        } else {
            partnerEpr = this._contexts.eprContext.resolveEndpointReference(partnerEPR);
        }
        mexDao.setEPR(partnerEpr.toXML().getDocumentElement());
        mexDao.setPartnerLink(plinkDAO);
        mexDao.setProcess(this._dao.getProcess());
        mexDao.setInstance(this._dao);
        mexDao.setPattern(operation.getOutput() != null ? MessageExchange.MessageExchangePattern.REQUEST_RESPONSE : MessageExchange.MessageExchangePattern.REQUEST_ONLY);
        mexDao.setChannel(requestId);
        MessageDAO message = mexDao.createMessage(operation.getInput().getMessage().getQName());
        mexDao.setRequest(message);
        mexDao.setTimeout(30000L);
        mexDao.setProperty("org.apache.ode.bpel.myRoleTransacted", Boolean.valueOf(this._atomicScope).toString());
        message.setType(operation.getInput().getMessage().getQName());
        this.buildOutgoingMessage(message, outgoingMessage);
        ProcessMessageExchangeEvent evt = new ProcessMessageExchangeEvent();
        evt.setOperation(operation.getName());
        evt.setPortType(partnerLink.getModel().getPartnerRolePortType().getQName());
        evt.setAspect((short)3);
        evt.setMexId(mexDao.getMessageExchangeId());
        this.sendEvent((ProcessInstanceEvent)evt);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INVOKING PARTNER: partnerLink=" + partnerLink + ", op=" + operation.getName() + " channel=" + requestId + ")"));
        }
        this._bpelProcess.invokePartner(mexDao);
        if (mexDao.getPattern().equals((Object)MessageExchange.MessageExchangePattern.REQUEST_ONLY)) {
            mexDao.setStatus(MessageExchange.Status.ASYNC);
            boolean succeeded = mexDao.getAckType() != MessageExchange.AckType.FAILURE && mexDao.getAckType() != MessageExchange.AckType.FAULT;
            mexDao.release(this._bpelProcess.isCleanupCategoryEnabled(succeeded, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        }
        switch (mexDao.getStatus()) {
            case ACK: {
                if (mexDao.getChannel() == null) break;
                this.injectPartnerResponse(mexDao.getMessageExchangeId(), mexDao.getChannel());
                break;
            }
            case ASYNC: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected MEX status: " + mexDao.getStatus()));
            }
        }
        return mexDao.getMessageExchangeId();
    }

    private void buildOutgoingMessage(MessageDAO message, Element outgoingElmt) {
        if (outgoingElmt == null) {
            return;
        }
        Document doc = DOMUtils.newDocument();
        Element header = doc.createElement("header");
        NodeList parts = outgoingElmt.getChildNodes();
        for (int m = 0; m < parts.getLength(); ++m) {
            Element part;
            if (parts.item(m).getNodeType() == 3 || (part = (Element)parts.item(m)).getAttribute("headerPart") == null || part.getAttribute("headerPart").length() <= 0) continue;
            header.appendChild(doc.importNode(part, true));
            outgoingElmt.removeChild(part);
        }
        message.setData(outgoingElmt);
        message.setHeader(header);
    }

    public void executeCreateInstance(MessageExchangeDAO instantiatingMessageExchange) {
        if (instantiatingMessageExchange == null) {
            throw new NullPointerException();
        }
        this._instantiatingMessageExchange = instantiatingMessageExchange;
        this._rti.onCreateInstance(instantiatingMessageExchange.getMessageExchangeId());
        this.execute();
    }

    void execute() {
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("MUST RUN IN TRANSACTION!");
        }
        long maxTime = System.currentTimeMillis() + this._maxReductionTimeMs;
        boolean canReduce = true;
        while (ProcessState.canExecute((short)this._dao.getState()) && System.currentTimeMillis() < maxTime && canReduce && !this._forceFlush && !this._forceRollback) {
            canReduce = this._rti.execute();
        }
        if (!this._instanceCleanedUp) {
            this._dao.setLastActiveTime(new Date());
        }
        if (!ProcessState.isFinished((short)this._dao.getState())) {
            if (this._forceRollback) {
                this.rollbackState();
            } else {
                this.saveState();
            }
            if (ProcessState.canExecute((short)this._dao.getState()) && canReduce) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MaxTime exceeded for instance # " + this._iid));
                }
                try {
                    WorkEvent we = new WorkEvent();
                    we.setIID(this._iid);
                    we.setRetryCount(this._retryCount);
                    we.setProcessId(this._bpelProcess.getPID());
                    we.setType(WorkEvent.Type.RESUME);
                    this._contexts.scheduler.schedulePersistedJob(we.getDetail(), new Date());
                }
                catch (ContextException e) {
                    __log.error((Object)"Failed to schedule resume task.", (Throwable)e);
                    throw new BpelEngineException((Throwable)e);
                }
            }
        }
    }

    private void saveState() {
        Object cachedState;
        if (this._bpelProcess.isInMemory()) {
            try {
                ((ProcessInstanceDaoImpl)this._dao).setSoup(this._rti.saveState(null));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            cachedState = this._rti.saveState((OutputStream)bos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int newcount = this._dao.getExecutionStateCounter() + 1;
        this._dao.setExecutionStateCounter(newcount);
        this._dao.setExecutionState(bos.toByteArray());
        this._instanceWorker.setCachedState(newcount, cachedState);
        __log.debug((Object)("CACHE SAVE: #" + newcount + " for instance " + this._dao.getInstanceId()));
    }

    private void rollbackState() {
        this._contexts.setRollbackOnly();
        int newcount = this._dao.getExecutionStateCounter();
        this._dao.setExecutionStateCounter(newcount);
        this._instanceWorker.setCachedState(newcount, null);
        __log.debug((Object)("CACHE SAVE: #" + newcount + " for instance " + this._dao.getInstanceId()));
    }

    void injectMyRoleMessageExchange(String responseChannelId, int idx, MessageExchangeDAO mexdao) {
        if (this._dao.getState() == 10) {
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)"INPUTMSGMATCH: Changing process instance state from ready to active");
            }
            this._dao.setState((short)20);
            ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
            evt.setOldState((short)10);
            evt.setNewState((short)20);
            this.sendEvent((ProcessInstanceEvent)evt);
        }
        this._rti.onSelectEvent(responseChannelId, mexdao.getMessageExchangeId(), idx);
    }

    boolean injectTimerEvent(String timerResponseChannel) {
        this._dao.getProcess().removeRoutes(timerResponseChannel, this._dao);
        if (ProcessState.isFinished((short)this._dao.getState())) {
            return false;
        }
        this._rti.onTimerEvent(timerResponseChannel);
        return true;
    }

    public boolean cancelTimer(String timerId) {
        return true;
    }

    public void cancelSelect(String selectId) {
        this._dao.getProcess().removeRoutes(selectId, this._dao);
    }

    void injectPartnerResponse(String mexid, String invokeId) {
        OdeRTInstance.InvokeResponseType irt;
        if (invokeId == null) {
            throw new NullPointerException("Null responseChannelId");
        }
        if (mexid == null) {
            throw new NullPointerException("Null mexId");
        }
        if (ODEProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("<invoke> response for mexid " + mexid + " and channel " + invokeId));
        }
        MessageExchangeDAO mex = this._dao.getConnection().getMessageExchange(mexid);
        ProcessMessageExchangeEvent evt = new ProcessMessageExchangeEvent();
        evt.setPortType(mex.getPortType());
        evt.setMexId(mexid);
        evt.setOperation(mex.getOperation());
        MessageExchange.Status status = mex.getStatus();
        switch (mex.getAckType()) {
            case FAULT: {
                irt = OdeRTInstance.InvokeResponseType.FAULT;
                evt.setAspect((short)5);
                break;
            }
            case RESPONSE: {
                irt = OdeRTInstance.InvokeResponseType.REPLY;
                evt.setAspect((short)4);
                break;
            }
            case FAILURE: {
                irt = OdeRTInstance.InvokeResponseType.FAILURE;
                evt.setAspect((short)6);
                break;
            }
            default: {
                String msg = "Invalid response state for mex " + mexid + ": " + status;
                __log.error((Object)msg);
                return;
            }
        }
        this.sendEvent((ProcessInstanceEvent)evt);
        this._rti.onInvokeResponse(invokeId, irt, mexid);
    }

    public void sendEvent(ProcessInstanceEvent event) {
        event.setProcessId(this._dao.getProcess().getProcessId());
        event.setProcessName(this._dao.getProcess().getType());
        event.setProcessInstanceId(this._dao.getInstanceId());
        this._bpelProcess._debugger.onEvent((BpelEvent)event);
        List scopeNames = null;
        if (event instanceof ScopeEvent) {
            scopeNames = ((ScopeEvent)event).getParentScopesNames();
        }
        this._bpelProcess.saveEvent(event, this._dao, scopeNames);
    }

    public void noreply(String mexId, FaultInfo optionalFaultData) {
        MessageExchangeDAO mexDao = this._dao.getConnection().getMessageExchange(mexId);
        if (mexDao != null) {
            MessageExchange.Status status = mexDao.getStatus();
            if (mexDao.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_ONLY) {
                mexDao.setAckType(MessageExchange.AckType.ONEWAY);
                mexDao.setStatus(MessageExchange.Status.COMPLETED);
                return;
            }
            mexDao.setAckType(MessageExchange.AckType.FAILURE);
            mexDao.setFailureType(MessageExchange.FailureType.NO_RESPONSE);
            if (optionalFaultData != null) {
                mexDao.setFaultExplanation(optionalFaultData.toString());
            }
            mexDao.setFaultExplanation("Process did not respond.");
            mexDao.setStatus(MessageExchange.Status.ACK);
            this._bpelProcess.onMyRoleMexAck(mexDao, status);
        }
    }

    public Element getPartnerResponse(String mexId) {
        return this.mergeHeaders(this._getPartnerResponse(mexId));
    }

    public Element getMyRequest(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        if (dao == null) {
            String msg = "Engine requested non-existent message exchange: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        if (dao.getDirection() != 'M') {
            String msg = "Engine requested my-role request for a partner-role mex: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        MessageDAO request = dao.getRequest();
        if (request == null) {
            String msg = "Engine requested request for message exchange that did not have one: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        return this.mergeHeaders(request);
    }

    private Element mergeHeaders(MessageDAO msg) {
        Element data = msg.getData();
        if (msg.getHeader() != null) {
            if (data == null) {
                Document doc = DOMUtils.newDocument();
                data = doc.createElement("message");
                doc.appendChild(data);
            }
            NodeList headerParts = msg.getHeader().getChildNodes();
            for (int m = 0; m < headerParts.getLength(); ++m) {
                if (headerParts.item(m).getNodeType() != 1) continue;
                Element headerPart = (Element)headerParts.item(m);
                headerPart.setAttribute("headerPart", "true");
                data.appendChild(data.getOwnerDocument().importNode(headerPart, true));
            }
        }
        return data;
    }

    public QName getPartnerFault(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        if (dao == null) {
            String msg = "Engine requested non-existent message exchange: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        return dao.getFault();
    }

    public QName getPartnerResponseType(String mexId) {
        return this._getPartnerResponse(mexId).getType();
    }

    public String getPartnerFaultExplanation(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        return dao != null ? dao.getFaultExplanation() : null;
    }

    private MessageDAO _getPartnerResponse(String mexId) {
        MessageDAO response;
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        if (dao == null) {
            String msg = "Engine requested non-existent message exchange: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        if (dao.getDirection() != 'P') {
            String msg = "Engine requested partner response for a my-role mex: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        MessageExchange.Status status = dao.getStatus();
        if (status == MessageExchange.Status.ACK) {
            response = dao.getResponse();
            if (response == null) {
                String msg = "Engine requested response for message exchange that did not have one: " + mexId;
                __log.fatal((Object)msg);
                throw new BpelEngineException(msg);
            }
        } else {
            String msg = "Engine requested response while the message exchange " + mexId + " was in the state " + status;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        return response;
    }

    public void releasePartnerMex(String mexId, boolean instanceSucceeded) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        dao.release(this._bpelProcess.isCleanupCategoryEnabled(instanceSucceeded, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
    }

    public Element getSourceEPR(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        String epr = dao.getProperty("org.apache.ode.bpel.partnerRoleEPR");
        if (epr == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((String)epr);
        }
        catch (Exception ex) {
            __log.error((Object)("Invalid value for SEP property org.apache.ode.bpel.partnerRoleEPR: " + epr));
            return null;
        }
    }

    public String getSourceSessionId(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        return dao.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
    }

    public void registerActivityForRecovery(String channel, long activityId, String reason, Date dateTime, Element details, String[] actions, int retries) {
        if (reason == null) {
            reason = "Unspecified";
        }
        if (dateTime == null) {
            dateTime = new Date();
        }
        __log.info((Object)("ActivityRecovery: Registering activity " + activityId + ", failure reason: " + reason + " on channel " + channel));
        this._dao.createActivityRecovery(channel, (long)((int)activityId), reason, dateTime, details, actions, retries);
    }

    public void unregisterActivityForRecovery(String channel) {
        this._dao.deleteActivityRecovery(channel);
    }

    void recoverActivity(String channel, long activityId, String action, FaultInfo fault) {
        this._rti.recoverActivity(channel, activityId, action, fault);
        this.execute();
    }

    public String fetchMySessionId(PartnerLink pLink) {
        String sessionId = this.fetchPartnerLinkDAO(pLink).getMySessionId();
        assert (sessionId != null) : "Session ID should always be set!";
        return sessionId;
    }

    public String fetchPartnersSessionId(PartnerLink pLink) {
        return this.fetchPartnerLinkDAO(pLink).getPartnerSessionId();
    }

    public void initializePartnersSessionId(PartnerLink pLink, String session) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("initializing partner " + pLink + "  sessionId to " + session));
        }
        this.fetchPartnerLinkDAO(pLink).setPartnerSessionId(session);
    }

    public void forceFlush() {
        this._forceFlush = true;
    }

    public void forceRollback() {
        this._forceRollback = true;
    }

    public Node readExtVar(Variable variable, Node reference) throws ExternalVariableModuleException {
        ExternalVariableModule.Value val = this._bpelProcess.getEVM().read(variable, reference, this._iid);
        return val.value;
    }

    public VariableContext.ValueReferencePair writeExtVar(Variable variable, Node reference, Node value) throws ExternalVariableModuleException {
        VariableContext.ValueReferencePair vrp = new VariableContext.ValueReferencePair();
        ExternalVariableModule.Value val = this._bpelProcess.getEVM().write(variable, reference, value, this._iid);
        vrp.reference = val.locator.reference;
        vrp.value = val.value;
        return vrp;
    }

    public URI getBaseResourceURI() {
        return this._bpelProcess.getBaseResourceURI();
    }

    protected OdeConfigProperties getProperties() {
        return this._bpelProcess.getProperties();
    }

    public int getAtomicScopeRetryDelay() {
        return this.getProperties().getAtomicScopeRetryDelay();
    }

    public boolean isAtomicScopeFirstTry() {
        return this._retryCount == 0;
    }

    public boolean isAtomicScopeRetryable() {
        return this._retryCount < this.getProperties().getAtomicScopeRetryCount();
    }

    public void setAtomicScopeRetriedOnce() {
        ++this._retryCount;
    }

    public void setAtomicScopeRetriesDone() {
        this._retryCount = this.getProperties().getAtomicScopeRetryCount();
    }

    public void setAtomicScope(boolean atomicScope) {
        this._atomicScope = atomicScope;
        this._bpelProcess._server.setTransacted(atomicScope);
    }

    public boolean isAtomicScope() {
        return this._atomicScope;
    }

    public Node getProcessProperty(QName propertyName) {
        return this._bpelProcess.getProcessProperty(propertyName);
    }
}

