/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BrokeredReliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.BrokeredTransactedMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.BrokeredUnreliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeCache;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelServerImpl
implements BpelServer,
Scheduler.JobProcessor {
    private static final Log __log = LogFactory.getLog(BpelServerImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static Long __processMaxAge;
    private Random _random = new Random(System.currentTimeMillis());
    private static double _delayMean;
    private final HashMap<QName, ODEProcess> _registeredProcesses = new HashMap();
    private final HashMap<QName, List<ODEProcess>> _serviceMap = new HashMap();
    private final MyRoleMessageExchangeCache _myRoleMexCache = new MyRoleMessageExchangeCache();
    private State _state = State.SHUTDOWN;
    Contexts _contexts = new Contexts();
    private DehydrationPolicy _dehydrationPolicy;
    private OdeConfigProperties _properties;
    private ExecutorService _exec;
    BpelDatabase _db;
    private ReadWriteLock _mngmtLock = new ReentrantReadWriteLock();
    private final AtomicLong _lastTimeOfServerCallable = new AtomicLong(System.currentTimeMillis());
    private SharedEndpoints _sharedEps;

    protected void waitForQuiessence() {
        long ltime;
        do {
            this._mngmtLock.writeLock().lock();
            this._mngmtLock.writeLock().unlock();
            ltime = this._lastTimeOfServerCallable.get();
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this._mngmtLock.writeLock().lock();
            this._mngmtLock.writeLock().unlock();
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this._lastTimeOfServerCallable.get() != ltime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this._mngmtLock.writeLock().lock();
        try {
            String errmsg;
            if (!this.checkState(State.INIT, State.RUNNING)) {
                __log.debug((Object)"start() ignored -- already started");
                return;
            }
            __log.debug((Object)"BPEL SERVER starting.");
            if (this._exec == null) {
                ThreadFactory threadFactory = new ThreadFactory(){
                    int threadNumber = 0;

                    public Thread newThread(Runnable r) {
                        ++this.threadNumber;
                        Thread t = new Thread(r, "ODEServerImpl-" + this.threadNumber);
                        t.setDaemon(true);
                        return t;
                    }
                };
                this._exec = Executors.newCachedThreadPool(threadFactory);
            }
            if (this._contexts.txManager == null) {
                errmsg = "Transaction manager not specified; call setTransactionManager(...)!";
                __log.fatal((Object)errmsg);
                throw new IllegalStateException(errmsg);
            }
            if (this._contexts.scheduler == null) {
                errmsg = "Scheduler not specified; call setScheduler(...)!";
                __log.fatal((Object)errmsg);
                throw new IllegalStateException(errmsg);
            }
            this._contexts.scheduler.start();
            this._state = State.RUNNING;
            __log.info((Object)__msgs.msgServerStarted());
            if (this._dehydrationPolicy != null) {
                new Thread(new ProcessDefReaper()).start();
            }
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public BpelDatabase getBpelDb() {
        return this._db;
    }

    public void registerExternalVariableEngine(ExternalVariableModule eve) {
        this._contexts.externalVariableEngines.put(eve.getName(), eve);
    }

    public void registerBpelEventListener(BpelEventListener listener) {
        listener.startup(this._properties.getProperties());
        this._contexts.eventListeners.add(listener);
    }

    public void unregisterBpelEventListener(BpelEventListener listener) {
        if (this._contexts.eventListeners.remove(listener)) {
            try {
                listener.shutdown();
            }
            catch (Exception e) {
                __log.warn((Object)("Stopping BPEL event listener " + listener.getClass().getName() + " failed, nevertheless it has been unregistered."), (Throwable)e);
            }
        }
    }

    private void unregisterBpelEventListeners() {
        for (BpelEventListener l : this._contexts.eventListeners) {
            this.unregisterBpelEventListener(l);
        }
    }

    public void registerExtensionBundle(ExtensionBundleRuntime bundle) {
        this._contexts.extensionRegistry.put(bundle.getNamespaceURI(), bundle);
        bundle.registerExtensionActivities();
    }

    public void unregisterExtensionBundle(String nsURI) {
        this._contexts.extensionRegistry.remove(nsURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.RUNNING, State.INIT)) {
                __log.debug((Object)"stop() ignored -- already stopped");
                return;
            }
            __log.debug((Object)"BPEL SERVER STOPPING");
            this._contexts.scheduler.stop();
            this._state = State.INIT;
            __log.info((Object)__msgs.msgServerStopped());
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.SHUTDOWN, State.INIT)) {
                return;
            }
            __log.debug((Object)"BPEL SERVER initializing ");
            this._db = new BpelDatabase(this._contexts);
            this._state = State.INIT;
            this._sharedEps = new SharedEndpoints();
            this._sharedEps.init();
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            this.stop();
            this.unregisterBpelEventListeners();
            this._sharedEps = null;
            this._db = null;
            this._state = State.SHUTDOWN;
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ProcessConf conf) {
        if (conf == null) {
            throw new NullPointerException("must specify non-null process configuration.");
        }
        __log.debug((Object)("register: " + conf.getProcessId()));
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            __log.debug((Object)"register(...) interrupted.", (Throwable)ie);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            if (this._registeredProcesses.containsKey(conf.getProcessId())) {
                __log.debug((Object)("skipping doRegister" + conf.getProcessId() + ") -- process is already registered"));
                return;
            }
            __log.debug((Object)("Registering process " + conf.getProcessId() + " with server."));
            ODEProcess process = new ODEProcess(this, conf, null, this._myRoleMexCache);
            for (Endpoint e : process.getServiceNames()) {
                __log.debug((Object)("Register process: serviceId=" + e + ", process=" + process));
                List<ODEProcess> processes = this._serviceMap.get(e.serviceName);
                if (processes == null) {
                    processes = new ArrayList<ODEProcess>();
                    this._serviceMap.put(e.serviceName, processes);
                }
                for (int i = 0; i < processes.size(); ++i) {
                    ODEProcess cachedVersion = processes.get(i);
                    __log.debug((Object)("cached version " + cachedVersion.getPID() + " vs registering version " + process.getPID()));
                    if (!cachedVersion.getProcessType().equals(process.getProcessType())) continue;
                    processes.remove(cachedVersion);
                }
                processes.add(process);
            }
            process.activate(this._contexts);
            this._registeredProcesses.put(process.getPID(), process);
            if (this._dehydrationPolicy == null) {
                process.hydrate();
            }
            __log.info((Object)__msgs.msgProcessRegistered(conf.getProcessId()));
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void unregister(QName pid) throws BpelEngineException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("unregister: " + pid));
        }
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            __log.debug((Object)"unregister() interrupted.", (Throwable)ie);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            ODEProcess p = this._registeredProcesses.remove(pid);
            if (p == null) {
                return;
            }
            p.deactivate();
            for (List<ODEProcess> processes : this._serviceMap.values()) {
                __log.debug((Object)("removing process " + pid + "; handle " + p + "; exists " + processes.contains(p)));
                processes.remove(p);
            }
            __log.info((Object)__msgs.msgProcessUnregistered(pid));
        }
        catch (Exception ex) {
            __log.error((Object)__msgs.msgProcessUnregisterFailed(pid), (Throwable)ex);
            throw new BpelEngineException((Throwable)ex);
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void cleanupProcess(QName pid) throws BpelEngineException {
        this.deleteProcessDAO(pid);
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._contexts.globalIntereceptors.add(interceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._contexts.globalIntereceptors.remove(interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ODEProcess> route(QName service, Message request) {
        this._mngmtLock.readLock().lock();
        try {
            List<ODEProcess> list = this._serviceMap.get(service);
            return list;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    private final boolean checkState(State i, State j) {
        if (this._state == i) {
            return true;
        }
        if (this._state == j) {
            return false;
        }
        return false;
    }

    private boolean deleteProcessDAO(final QName pid) {
        try {
            return this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection conn) throws Exception {
                    ProcessDAO proc = conn.getProcess(pid);
                    if (proc != null) {
                        proc.delete();
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception ex) {
            String errmsg = "DbError";
            __log.error((Object)errmsg, (Throwable)ex);
            throw new BpelEngineException(errmsg, (Throwable)ex);
        }
    }

    public void onScheduledJob(final Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        this._mngmtLock.readLock().lock();
        try {
            final WorkEvent we = new WorkEvent(jobInfo.jobDetail);
            ODEProcess process = this._registeredProcesses.get(we.getProcessId());
            if (process == null) {
                this._contexts.execTransaction(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        BpelServerImpl.this._contexts.scheduler.jobCompleted(jobInfo.jobName);
                        Date future = new Date(System.currentTimeMillis() + 60000L);
                        __log.info((Object)__msgs.msgReschedulingJobForInactiveProcess(we.getProcessId(), jobInfo.jobName, future));
                        BpelServerImpl.this._contexts.scheduler.schedulePersistedJob(we.getDetail(), future);
                        return null;
                    }
                });
                return;
            }
            if (we.getType().equals((Object)WorkEvent.Type.INVOKE_CHECK)) {
                PartnerRoleMessageExchange mex;
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("handleWorkEvent: InvokeCheck event for mexid " + we.getMexId()));
                }
                if ((mex = (PartnerRoleMessageExchange)this.getMessageExchange(we.getMexId())).getStatus() == MessageExchange.Status.ASYNC || mex.getStatus() == MessageExchange.Status.ACK) {
                    String msg = "Dangling invocation (mexId=" + we.getMexId() + "), forcing it into a failed state.";
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)msg);
                    }
                    mex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, msg, null);
                }
                return;
            }
            process.handleWorkEvent(jobInfo);
        }
        catch (Exception ex) {
            throw new Scheduler.JobProcessorException((Throwable)ex, jobInfo.jobDetail.get("inmem") == null);
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    public void setTransactionManager(TransactionManager txm) {
        this._contexts.txManager = txm;
    }

    public void setDehydrationPolicy(DehydrationPolicy dehydrationPolicy) {
        this._dehydrationPolicy = dehydrationPolicy;
    }

    public void setConfigProperties(OdeConfigProperties properties) {
        this._properties = properties;
    }

    public OdeConfigProperties getConfigProperties() {
        return this._properties;
    }

    public void setMessageExchangeContext(MessageExchangeContext mexContext) throws BpelEngineException {
        this._contexts.mexContext = mexContext;
    }

    public void setScheduler(Scheduler scheduler) throws BpelEngineException {
        this._contexts.scheduler = scheduler;
    }

    public void setEndpointReferenceContext(EndpointReferenceContext eprContext) throws BpelEngineException {
        this._contexts.eprContext = eprContext;
    }

    public void setDaoConnectionFactory(BpelDAOConnectionFactory daoCF) throws BpelEngineException {
        this._contexts.dao = daoCF;
    }

    public void setBindingContext(BindingContext bc) {
        this._contexts.bindingContext = bc;
    }

    public SharedEndpoints getSharedEndpoints() {
        return this._sharedEps;
    }

    public void setExecutor(ExecutorService exec) {
        this._exec = exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyRoleMessageExchange createMessageExchange(InvocationStyle istyle, QName targetService, String operation, String clientKey) throws BpelEngineException {
        this._mngmtLock.readLock().lock();
        try {
            List<ODEProcess> targets = this.route(targetService, null);
            if (targets == null || targets.size() == 0) {
                throw new BpelEngineException("NoSuchService: " + targetService);
            }
            if (targets.size() == 1) {
                ODEProcess target = targets.get(0);
                MyRoleMessageExchange myRoleMessageExchange = this.createNewMyRoleMex(target, istyle, targetService, operation, clientKey);
                return myRoleMessageExchange;
            }
            ArrayList<MyRoleMessageExchange> meps = new ArrayList<MyRoleMessageExchange>();
            for (ODEProcess target : targets) {
                meps.add(this.createNewMyRoleMex(target, istyle, targetService, operation, clientKey));
            }
            MyRoleMessageExchange myRoleMessageExchange = this.createNewMyRoleMex(targets.get(0), meps, istyle);
            return myRoleMessageExchange;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    private MyRoleMessageExchange createNewMyRoleMex(ODEProcess process, InvocationStyle istyle, QName targetService, String operation, String clientKey) {
        if (istyle == InvocationStyle.RELIABLE || istyle == InvocationStyle.TRANSACTED) {
            this.assertTransaction();
        } else {
            this.assertNoTransaction();
        }
        return process.createNewMyRoleMex(istyle, targetService, operation);
    }

    private MyRoleMessageExchange createNewMyRoleMex(ODEProcess target, List<MyRoleMessageExchange> meps, InvocationStyle istyle) throws BpelEngineException {
        String mexId = new GUID().toString();
        MyRoleMessageExchange template = meps.get(0);
        switch (istyle) {
            case RELIABLE: {
                return new BrokeredReliableMyRoleMessageExchangeImpl(target, meps, mexId, template);
            }
            case TRANSACTED: {
                return new BrokeredTransactedMyRoleMessageExchangeImpl(target, meps, mexId, template);
            }
            case UNRELIABLE: {
                return new BrokeredUnreliableMyRoleMessageExchangeImpl(target, meps, mexId, template);
            }
        }
        throw new BpelEngineException("Unsupported Invocation Style: " + istyle);
    }

    public MessageExchange getMessageExchange(final String mexId) throws BpelEngineException {
        this._mngmtLock.readLock().lock();
        try {
            Callable<MessageExchange> loadMex;
            block8: {
                final MessageExchangeDAO inmemdao = this.getInMemMexDAO(mexId);
                loadMex = new Callable<MessageExchange>(){

                    @Override
                    public MessageExchange call() {
                        ODEProcess process;
                        MessageExchangeDAO mexdao;
                        MessageExchangeDAO messageExchangeDAO = mexdao = inmemdao == null ? (mexdao = BpelServerImpl.this._contexts.dao.getConnection().getMessageExchange(mexId)) : inmemdao;
                        if (mexdao == null) {
                            return null;
                        }
                        ProcessDAO pdao = mexdao.getProcess();
                        ODEProcess oDEProcess = process = pdao == null ? null : (ODEProcess)BpelServerImpl.this._registeredProcesses.get(pdao.getProcessId());
                        if (process == null) {
                            String errmsg = __msgs.msgProcessNotActive(pdao.getProcessId());
                            __log.error((Object)errmsg);
                            throw new BpelEngineException(errmsg);
                        }
                        InvocationStyle istyle = mexdao.getInvocationStyle();
                        if (istyle == InvocationStyle.RELIABLE || istyle == InvocationStyle.TRANSACTED) {
                            BpelServerImpl.this.assertTransaction();
                        }
                        switch (mexdao.getDirection()) {
                            case 'P': {
                                return process.createPartnerRoleMex(mexdao);
                            }
                            case 'M': {
                                return process.lookupMyRoleMex(mexdao);
                            }
                        }
                        String errmsg = "BpelEngineImpl: internal error, invalid MexDAO direction: " + mexId;
                        __log.fatal((Object)errmsg);
                        throw new BpelEngineException(errmsg);
                    }
                };
                try {
                    if (inmemdao == null && !this._contexts.isTransacted()) break block8;
                    MessageExchange messageExchange = (MessageExchange)loadMex.call();
                    return messageExchange;
                }
                catch (ContextException e) {
                    throw new BpelEngineException((Throwable)e);
                }
                catch (Exception e) {
                    throw new BpelEngineException((Throwable)e);
                }
            }
            MessageExchange messageExchange = this.enqueueTransaction(loadMex).get();
            return messageExchange;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    public MessageExchange getMessageExchangeByForeignKey(String foreignKey) throws BpelEngineException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InvocationStyle> getSupportedInvocationStyle(QName serviceId) {
        this._mngmtLock.readLock().lock();
        try {
            List<ODEProcess> processes = this.route(serviceId, null);
            if (processes == null || processes.size() == 0) {
                throw new BpelEngineException("No such service: " + serviceId);
            }
            HashSet<InvocationStyle> istyles = new HashSet<InvocationStyle>();
            for (ODEProcess process : processes) {
                Set<InvocationStyle> pistyles = process.getSupportedInvocationStyle(serviceId);
                if (istyles.isEmpty()) {
                    istyles.addAll(pistyles);
                    continue;
                }
                for (InvocationStyle istyle : istyles) {
                    if (pistyles.contains(istyle)) continue;
                    istyles.remove(istyle);
                }
            }
            HashSet<InvocationStyle> hashSet = istyles;
            return hashSet;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageExchangeDAO getInMemMexDAO(String mexId) {
        this._mngmtLock.readLock().lock();
        try {
            for (ODEProcess p : this._registeredProcesses.values()) {
                MessageExchangeDAO mexDao = p.getInMemMexDAO(mexId);
                if (mexDao == null) continue;
                MessageExchangeDAO messageExchangeDAO = mexDao;
                return messageExchangeDAO;
            }
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessModel getProcessModel(QName processId) {
        this._mngmtLock.readLock().lock();
        try {
            ODEProcess process = this._registeredProcesses.get(processId);
            if (process == null) {
                ProcessModel processModel = null;
                return processModel;
            }
            ProcessModel processModel = process.getProcessModel();
            return processModel;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    <T> Future<T> enqueueTransaction(Callable<T> transaction) throws ContextException {
        return this._exec.submit(new ServerCallable<T>(new TransactedCallable<T>(transaction)));
    }

    void enqueueRunnable(Runnable runnable) {
        this._exec.submit(new ServerRunnable(runnable));
    }

    void scheduleRunnable(final Runnable runnable) {
        this.assertTransaction();
        this._contexts.registerCommitSynchronizer(new Runnable(){

            public void run() {
                BpelServerImpl.this._exec.submit(new ServerRunnable(runnable));
            }
        });
    }

    protected void assertTransaction() {
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("Operation must be performed in a transaction!");
        }
    }

    protected void assertNoTransaction() {
        if (this._contexts.isTransacted()) {
            throw new BpelEngineException("Operation must be performed outside of a transaction!");
        }
    }

    void fireEvent(BpelEvent event) {
        for (BpelEventListener l : this._contexts.eventListeners) {
            l.onEvent(event);
        }
    }

    private void debuggingDelay() {
        if (_delayMean != 0.0) {
            try {
                long delay = this.randomExp(_delayMean);
                __log.warn((Object)("Debugging delay has been activated; delaying transaction for " + delay + "ms."));
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long randomExp(double mean) {
        double u = this._random.nextDouble();
        return (long)(-Math.log(u) * mean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODEProcess getBpelProcess(QName processId) {
        this._mngmtLock.readLock().lock();
        try {
            ODEProcess oDEProcess = this._registeredProcesses.get(processId);
            return oDEProcess;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    private void ticktock() {
        this._lastTimeOfServerCallable.set(System.currentTimeMillis());
    }

    public void setTransacted(boolean atomicScope) {
    }

    static {
        _delayMean = 0.0;
        try {
            String processMaxAge = System.getProperty("ode.process.maxage");
            if (processMaxAge != null && processMaxAge.length() > 0) {
                __processMaxAge = Long.valueOf(processMaxAge);
                __log.info((Object)("Process definition max age adjusted. Max age = " + __processMaxAge + "ms."));
            }
        }
        catch (Throwable t) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Could not parse ode.process.maxage environment variable.", t);
            }
            __log.info((Object)"Could not parse ode.process.maxage environment variable; reaping disabled.");
        }
    }

    class TransactedRunnable
    implements Runnable {
        Runnable _work;

        TransactedRunnable(Runnable work) {
            this._work = work;
        }

        public void run() {
            BpelServerImpl.this._contexts.execTransaction(this._work);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransactedCallable<T>
    implements Callable<T> {
        Callable<T> _work;

        TransactedCallable(Callable<T> work) {
            this._work = work;
        }

        @Override
        public T call() throws Exception {
            return BpelServerImpl.this._contexts.execTransaction(this._work);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServerCallable<T>
    implements Callable<T> {
        final Callable<T> _work;

        ServerCallable(Callable<T> work) {
            this._work = work;
        }

        @Override
        public T call() throws Exception {
            BpelServerImpl.this.ticktock();
            BpelServerImpl.this._mngmtLock.readLock().lock();
            try {
                BpelServerImpl.this.ticktock();
                T t = this._work.call();
                return t;
            }
            catch (Exception ex) {
                BpelServerImpl.this.ticktock();
                __log.fatal((Object)"Internal Error", (Throwable)ex);
                throw ex;
            }
            finally {
                BpelServerImpl.this._mngmtLock.readLock().unlock();
                BpelServerImpl.this.ticktock();
            }
        }
    }

    class ServerRunnable
    implements Runnable {
        final Runnable _work;

        ServerRunnable(Runnable work) {
            this._work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BpelServerImpl.this.ticktock();
            BpelServerImpl.this._mngmtLock.readLock().lock();
            try {
                BpelServerImpl.this.ticktock();
                this._work.run();
                BpelServerImpl.this.ticktock();
            }
            catch (Throwable ex) {
                BpelServerImpl.this.ticktock();
                __log.fatal((Object)"Internal Error", ex);
            }
            finally {
                BpelServerImpl.this._mngmtLock.readLock().unlock();
            }
        }
    }

    private class ProcessDefReaper
    implements Runnable {
        private ProcessDefReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            __log.debug((Object)"Starting process definition reaper thread.");
            long pollingTime = 10000L;
            try {
                block5: while (true) {
                    Thread.sleep(pollingTime);
                    BpelServerImpl.this._mngmtLock.writeLock().lockInterruptibly();
                    try {
                        ArrayList<ODEProcess> candidates = new ArrayList<ODEProcess>(BpelServerImpl.this._registeredProcesses.values());
                        CollectionsX.remove_if(candidates, (MemberOfFunction)new MemberOfFunction<ODEProcess>(){

                            public boolean isMember(ODEProcess o) {
                                return !o.hintIsHydrated();
                            }
                        });
                        List<ODEProcess> ripped = BpelServerImpl.this._dehydrationPolicy.markForDehydration(candidates);
                        Iterator<ODEProcess> i$ = ripped.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block5;
                            ODEProcess process = i$.next();
                            __log.debug((Object)("Dehydrating process " + process.getPID()));
                            process.dehydrate();
                        }
                    }
                    finally {
                        BpelServerImpl.this._mngmtLock.writeLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                __log.info((Object)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SHUTDOWN,
        INIT,
        RUNNING;

    }
}

