/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.List;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.TransactedMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredTransactedMyRoleMessageExchangeImpl
extends TransactedMyRoleMessageExchangeImpl {
    private List<MyRoleMessageExchange> subscribers;
    private MyRoleMessageExchange template;

    public BrokeredTransactedMyRoleMessageExchangeImpl(ODEProcess process, List<MyRoleMessageExchange> subscribers, String mexId, MyRoleMessageExchange template) {
        super(process, mexId, null, template.getOperation(), template.getServiceName());
        this.subscribers = subscribers;
        this.template = template;
    }

    @Override
    public MessageExchange.Status invokeTransacted() {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.invokeTransacted();
        }
        return MessageExchange.Status.COMPLETED;
    }

    @Override
    public MessageExchange.AckType getAckType() {
        return this.template.getAckType();
    }

    @Override
    public MessageExchange.Status getStatus() {
        return this.template.getStatus();
    }

    @Override
    public EndpointReference getEndpointReference() throws BpelEngineException {
        return this.template.getEndpointReference();
    }

    @Override
    public Message getResponse() {
        return this.template.getResponse();
    }

    @Override
    public void setRequest(Message request) {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.setRequest(this.cloneMessage(request));
        }
    }

    @Override
    public void setTimeout(long timeout) {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.setTimeout(timeout);
        }
    }
}

