/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.UnreliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredUnreliableMyRoleMessageExchangeImpl
extends UnreliableMyRoleMessageExchangeImpl {
    private List<MyRoleMessageExchange> subscribers;
    private MyRoleMessageExchange template;

    public BrokeredUnreliableMyRoleMessageExchangeImpl(ODEProcess process, List<MyRoleMessageExchange> subscribers, String mexId, MyRoleMessageExchange template) {
        super(process, mexId, null, template.getOperation(), template.getServiceName());
        this.subscribers = subscribers;
        this.template = template;
    }

    @Override
    public Future<MessageExchange.Status> invokeAsync() {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.invokeAsync();
        }
        return new CompletedFuture();
    }

    @Override
    public MessageExchange.Status invokeBlocking() throws BpelEngineException, TimeoutException {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.invokeBlocking();
        }
        return MessageExchange.Status.COMPLETED;
    }

    @Override
    public MessageExchange.AckType getAckType() {
        return this.template.getAckType();
    }

    @Override
    public EndpointReference getEndpointReference() throws BpelEngineException {
        return this.template.getEndpointReference();
    }

    @Override
    public Message getResponse() {
        return this.template.getResponse();
    }

    @Override
    public void setRequest(Message request) {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.setRequest(this.cloneMessage(request));
        }
    }

    @Override
    public void setTimeout(long timeout) {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            subscriber.setTimeout(timeout);
        }
    }

    @Override
    public MessageExchange.Status getStatus() {
        return this.template.getStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompletedFuture
    implements Future<MessageExchange.Status> {
        private CompletedFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public MessageExchange.Status get() throws InterruptedException, ExecutionException {
            return MessageExchange.Status.COMPLETED;
        }

        @Override
        public MessageExchange.Status get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return MessageExchange.Status.COMPLETED;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

