/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Contexts {
    private static final Log __log = LogFactory.getLog(Contexts.class);
    TransactionManager txManager;
    MessageExchangeContext mexContext;
    Scheduler scheduler;
    EndpointReferenceContext eprContext;
    BindingContext bindingContext;
    BpelDAOConnectionFactory dao;
    final List<MessageExchangeInterceptor> globalIntereceptors = new CopyOnWriteArrayList<MessageExchangeInterceptor>();
    final List<BpelEventListener> eventListeners = new CopyOnWriteArrayList<BpelEventListener>();
    final Map<String, ExtensionBundleRuntime> extensionRegistry = new ConcurrentHashMap<String, ExtensionBundleRuntime>();
    final HashMap<QName, ExternalVariableModule> externalVariableEngines = new HashMap();

    Contexts() {
    }

    public boolean isTransacted() {
        try {
            return this.txManager.getStatus() == 0;
        }
        catch (SystemException e) {
            throw new BpelEngineException((Throwable)e);
        }
    }

    public void execTransaction(final Runnable transaction) {
        try {
            this.execTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    transaction.run();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new BpelEngineException((Throwable)e);
        }
    }

    public <T> T execTransaction(Callable<T> transaction) throws Exception {
        try {
            this.txManager.begin();
        }
        catch (Exception ex) {
            String errmsg = "Internal Error, could not begin transaction.";
            throw new BpelEngineException(errmsg, (Throwable)ex);
        }
        boolean success = false;
        try {
            T retval = transaction.call();
            success = this.txManager.getStatus() != 1;
            T t = retval;
            return t;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (success) {
                try {
                    this.txManager.commit();
                }
                catch (Exception ex) {
                    __log.error((Object)"Commit failed.", (Throwable)ex);
                    throw new BpelEngineException("Commit failed.", (Throwable)ex);
                }
            }
            try {
                this.txManager.rollback();
            }
            catch (Exception ex) {
                __log.error((Object)"Transaction rollback failed.", (Throwable)ex);
            }
        }
    }

    public void setRollbackOnly() {
        try {
            this.txManager.setRollbackOnly();
        }
        catch (SystemException se) {
            __log.error((Object)"Transaction set rollback only failed.", (Throwable)se);
        }
    }

    public void registerCommitSynchronizer(final Runnable runnable) {
        try {
            this.txManager.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int status) {
                    if (status == 3) {
                        runnable.run();
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (Exception ex) {
            throw new BpelEngineException("Error registering synchronizer.", (Throwable)ex);
        }
    }
}

