/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.ODEProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountLRUDehydrationPolicy
implements DehydrationPolicy {
    private long _processMaxAge = 1200000L;
    private int _processMaxCount = 1000;

    @Override
    public List<ODEProcess> markForDehydration(List<ODEProcess> runningProcesses) {
        ArrayList<ODEProcess> ripped = new ArrayList<ODEProcess>();
        if (this._processMaxAge > 0L) {
            long now = System.currentTimeMillis();
            for (ODEProcess process : runningProcesses) {
                if (now - process.getLastUsed() <= this._processMaxAge) continue;
                ripped.add(process);
            }
        }
        if (runningProcesses.size() - ripped.size() > this._processMaxCount) {
            runningProcesses.removeAll(ripped);
            Collections.sort(runningProcesses, new Comparator<ODEProcess>(){

                @Override
                public int compare(ODEProcess p1, ODEProcess p2) {
                    if (p1.getLastUsed() > p2.getLastUsed()) {
                        return -1;
                    }
                    if (p1.getLastUsed() < p2.getLastUsed()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (int m = this._processMaxCount; m < runningProcesses.size(); ++m) {
                ripped.add(runningProcesses.get(m));
            }
        }
        return ripped;
    }

    public void setProcessMaxAge(long processMaxAge) {
        this._processMaxAge = processMaxAge;
    }

    public void setProcessMaxCount(int processMaxCount) {
        this._processMaxCount = processMaxCount;
    }
}

