/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.MemBackedMessageImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MessageExchangeImpl
implements MessageExchange {
    static final String WSDL2_EXTENSIONS_NS = "http://www.w3.org/ns/wsdl-extensions";
    static final QName SAFE_ATTRIBUTE = new QName("http://www.w3.org/ns/wsdl-extensions", "safe");
    private static final Log __log = LogFactory.getLog(MessageExchangeImpl.class);
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    final Contexts _contexts;
    final ODEProcess _process;
    final PartnerLinkModel _oplink;
    final String _mexId;
    final PortType _portType;
    final Operation _operation;
    Long _iid;
    EndpointReference _epr;
    MessageImpl _request;
    long _timeout = 30000L;
    private volatile MessageExchange.Status _status = MessageExchange.Status.NEW;
    volatile QName _fault;
    volatile String _explanation;
    volatile MessageImpl _response;
    private volatile int _syncdummy;
    final HashSet<Change> _changes = new HashSet();
    final HashMap<String, String> _properties = new HashMap();
    final HashSet<String> _loadedProperties = new HashSet();
    final HashSet<String> _modifiedProperties = new HashSet();
    protected MessageExchange.FailureType _failureType;
    private Set<String> _propNames;
    private MessageExchange.AckType _ackType;

    public MessageExchangeImpl(ODEProcess process, Long iid, String mexId, PartnerLinkModel oplink, PortType ptype, Operation operation) {
        this._process = process;
        this._contexts = process._contexts;
        this._mexId = mexId;
        this._iid = iid;
        this._oplink = oplink;
        this._portType = ptype;
        this._operation = operation;
    }

    public boolean equals(Object other) {
        return this._mexId.equals(((MessageExchangeImpl)other)._mexId);
    }

    Long getIID() {
        return this._iid;
    }

    void load(MessageExchangeDAO dao) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"INMEM MessageExchange loading.");
        }
        this._epr = this._contexts.eprContext.resolveEndpointReference(dao.getEPR());
        this._timeout = dao.getTimeout();
        this._iid = dao.getInstance() != null ? dao.getInstance().getInstanceId() : null;
        this._ackType = dao.getAckType();
        this._status = dao.getStatus();
        this._fault = dao.getFault();
        this._explanation = dao.getFaultExplanation();
    }

    void save(MessageExchangeDAO dao) {
        dao.setPartnerLinkModelId(this._oplink.getId());
        dao.setOperation(this._operation.getName());
        dao.setStatus(this._status);
        dao.setInvocationStyle(this.getInvocationStyle());
        dao.setFault(this._fault);
        dao.setFaultExplanation(this._explanation);
        dao.setTimeout(this._timeout);
        dao.setFailureType(this._failureType);
        dao.setAckType(this._ackType);
        if (this._changes.contains((Object)Change.EPR)) {
            this._changes.remove((Object)Change.EPR);
            if (this._epr != null) {
                dao.setEPR(this._epr.toXML().getDocumentElement());
            } else {
                dao.setEPR(null);
            }
        }
        for (String modprop : this._modifiedProperties) {
            dao.setProperty(modprop, this._properties.get(modprop));
        }
        this._modifiedProperties.clear();
    }

    void save() {
        this.doInTX(new InDbAction<Void>(){

            @Override
            public Void call(MessageExchangeDAO mexdao) {
                MessageExchangeImpl.this.save(mexdao);
                return null;
            }
        });
    }

    public abstract InvocationStyle getInvocationStyle();

    public boolean isSafe() {
        Object val = this.getOperation().getExtensionAttribute(SAFE_ATTRIBUTE);
        if (val == null) {
            return false;
        }
        try {
            return Boolean.valueOf(val.toString());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getMessageExchangeId() throws BpelEngineException {
        return this._mexId;
    }

    public String getOperationName() throws BpelEngineException {
        return this.getOperation().getName();
    }

    public MessageExchange.MessageExchangePattern getMessageExchangePattern() {
        return this._operation.getOutput() == null ? MessageExchange.MessageExchangePattern.REQUEST_ONLY : MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
    }

    public boolean isTransactional() throws BpelEngineException {
        switch (this.getInvocationStyle()) {
            case TRANSACTED: 
            case RELIABLE: {
                return true;
            }
        }
        return false;
    }

    public QName getFault() {
        return this._fault;
    }

    public Message getFaultResponse() {
        return this._fault == null ? null : this.getResponse();
    }

    public String getFaultExplanation() {
        return this._explanation;
    }

    public MessageExchange.Status getStatus() {
        return this._status;
    }

    public MessageExchange.AckType getAckType() {
        return this._ackType;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public PortType getPortType() {
        return this._portType;
    }

    public Message getRequest() {
        if (this._request != null) {
            return this._request;
        }
        this._request = this.doInTX(new InDbAction<MessageImpl>(){

            @Override
            public MessageImpl call(MessageExchangeDAO dao) {
                MessageDAO req = dao.getRequest();
                if (req == null) {
                    return null;
                }
                return new MemBackedMessageImpl(req.getHeader(), req.getData(), req.getType(), true);
            }
        });
        return this._request;
    }

    public Message getResponse() {
        if (this._response != null) {
            return this._response;
        }
        this._response = this.doInTX(new InDbAction<MessageImpl>(){

            @Override
            public MessageImpl call(MessageExchangeDAO dao) {
                MessageDAO req = dao.getResponse();
                if (req == null) {
                    return null;
                }
                return new MemBackedMessageImpl(req.getHeader(), req.getData(), req.getType(), true);
            }
        });
        return this._response;
    }

    void request() {
        this._status = MessageExchange.Status.REQ;
    }

    void ack(MessageExchange.AckType ackType) {
        this._status = MessageExchange.Status.ACK;
        this._ackType = ackType;
    }

    public Message createMessage(QName msgType) {
        return new MemBackedMessageImpl(null, null, msgType, false);
    }

    public void setEndpointReference(EndpointReference ref) {
        this._epr = ref;
        this._changes.add(Change.EPR);
    }

    public EndpointReference getEndpointReference() throws BpelEngineException {
        if (this._epr != null) {
            return this._epr;
        }
        this._epr = this.doInTX(new InDbAction<EndpointReference>(){

            @Override
            public EndpointReference call(MessageExchangeDAO mexdao) {
                Element eprdao = null;
                if (mexdao != null) {
                    eprdao = mexdao.getEPR();
                }
                MessageExchangeImpl.this._epr = eprdao == null ? null : MessageExchangeImpl.this._contexts.eprContext.resolveEndpointReference(mexdao.getEPR());
                return MessageExchangeImpl.this._epr;
            }
        });
        return this._epr;
    }

    public String getProperty(final String key) {
        if (!this._loadedProperties.contains(key)) {
            this._properties.put(key, this.doInTX(new InDbAction<String>(){

                @Override
                public String call(MessageExchangeDAO mexdao) {
                    return mexdao.getProperty(key);
                }
            }));
            this._loadedProperties.add(key);
        }
        return this._properties.get(key);
    }

    public void setProperty(String key, String value) {
        this._properties.put(key, value);
        this._loadedProperties.add(key);
        this._modifiedProperties.add(key);
    }

    public Set<String> getPropertyNames() {
        if (this._propNames != null) {
            return this._propNames;
        }
        this._propNames = this.doInTX(new InDbAction<Set<String>>(){

            @Override
            public Set<String> call(MessageExchangeDAO mexdao) {
                return mexdao.getPropertyNames();
            }
        });
        return this._propNames;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public void release() {
        __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
        this._changes.add(Change.RELEASE);
        this._process.releaseMessageExchange(this.getMessageExchangeId());
    }

    public String toString() {
        return "MEX[" + this._mexId + "]";
    }

    protected void assertTransaction() {
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("Operation must be performed in a transaction!");
        }
    }

    protected <T> T doInTX(final InDbAction<T> action) {
        if (this.isTransactional()) {
            this.assertTransaction();
            return action.call(this.getDAO());
        }
        try {
            return this._process.enqueueTransaction(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    MessageExchangeImpl.this.assertTransaction();
                    return action.call(MessageExchangeImpl.this.getDAO());
                }
            }).get();
        }
        catch (Exception ie) {
            __log.error((Object)"Internal error executing transaction.", (Throwable)ie);
            throw new BpelEngineException("Internal Error", (Throwable)ie);
        }
    }

    protected MessageExchangeDAO getDAO() {
        this.assertTransaction();
        return this._process.loadMexDao(this._mexId);
    }

    void sync() {
        ++this._syncdummy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InDbAction<T> {
        public T call(MessageExchangeDAO var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Change {
        EPR,
        ACK,
        RELEASE,
        REQUEST;

    }
}

