/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MessageImpl
implements Message {
    boolean _readOnly = false;

    MessageImpl() {
    }

    public Element getPart(String partName) {
        Element message = this.getMessage();
        NodeList eltList = message.getElementsByTagName(partName);
        if (eltList.getLength() == 0) {
            return null;
        }
        return (Element)eltList.item(0);
    }

    public void setPart(String partName, Element content) {
        Element message = this.getMessage();
        if (message == null) {
            Document doc = DOMUtils.newDocument();
            message = doc.createElement("message");
            doc.appendChild(message);
        }
        message.appendChild(message.getOwnerDocument().importNode(content, true));
        this.setMessage(message);
    }

    public Element getHeaderPart(String partName) {
        Element header = this.getHeader();
        if (header == null) {
            return null;
        }
        NodeList eltList = header.getElementsByTagName(partName);
        if (eltList.getLength() == 0) {
            return null;
        }
        return (Element)eltList.item(0);
    }

    public void setHeaderPart(String name, Element content) {
        Element header = this.getHeader();
        if (header == null) {
            Document doc = DOMUtils.newDocument();
            header = doc.createElement("header");
            doc.appendChild(header);
        }
        Element part = this.replaceHeader(name, header);
        header.appendChild(part);
        part.appendChild(header.getOwnerDocument().importNode(content, true));
        this.setHeader(header);
    }

    public void setHeaderPart(String name, String content) {
        Element header = this.getHeader();
        if (header == null) {
            Document doc = DOMUtils.newDocument();
            header = doc.createElement("header");
            doc.appendChild(header);
        }
        Element part = this.replaceHeader(name, header);
        header.appendChild(part);
        part.setTextContent(content);
        this.setHeader(header);
    }

    public abstract void setMessage(Element var1);

    public abstract Element getMessage();

    public abstract void setHeader(Element var1);

    public abstract Element getHeader();

    public abstract QName getType();

    public List<String> getParts() {
        ArrayList<String> parts = new ArrayList<String>();
        Element message = this.getMessage();
        NodeList nodeList = message.getChildNodes();
        for (int m = 0; m < nodeList.getLength(); ++m) {
            Node node = nodeList.item(m);
            if (node.getNodeType() != 1) continue;
            parts.add(node.getLocalName());
        }
        return parts;
    }

    public Map<String, Node> getHeaderParts() {
        HashMap<String, Node> l = new HashMap<String, Node>();
        Element header = this.getHeader();
        if (header != null) {
            NodeList children = header.getChildNodes();
            for (int m = 0; m < children.getLength(); ++m) {
                if (children.item(m).getNodeType() != 1) continue;
                Element part = (Element)children.item(m);
                Node node = DOMUtils.findChildByType((Element)part, (int)1);
                if (node == null) {
                    node = DOMUtils.findChildByType((Element)part, (int)3);
                }
                if (part.getLocalName() == null) {
                    l.put(part.getNodeName(), node);
                    continue;
                }
                l.put(part.getLocalName(), node);
            }
        }
        return l;
    }

    protected void makeReadOnly() {
        this._readOnly = true;
    }

    protected void checkWrite() {
        if (this._readOnly) {
            throw new IllegalStateException("write attempted to read-only message.");
        }
    }

    private Element replaceHeader(String name, Element header) {
        NodeList nodeList = header.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node node = nodeList.item(index);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            header.removeChild(node);
        }
        Element part = header.getOwnerDocument().createElement(name);
        header.appendChild(part);
        return part;
    }
}

