/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ODEProcess;

class MyRoleMessageExchangeCache {
    private static final int CLEANUP_PERIOD = 20;
    private Map<String, WeakReference<MyRoleMessageExchangeImpl>> _cache = new ConcurrentHashMap<String, WeakReference<MyRoleMessageExchangeImpl>>();
    private int _inserts = 0;

    MyRoleMessageExchangeCache() {
    }

    void put(MyRoleMessageExchangeImpl mex) {
        WeakReference<MyRoleMessageExchangeImpl> ref;
        ++this._inserts;
        if (this._inserts > 20) {
            this.cleanup();
        }
        if ((ref = this._cache.get(mex.getMessageExchangeId())) != null && ref.get() != null) {
            throw new IllegalStateException("InternalError: duplicate myrolemex registration!");
        }
        this._cache.put(mex.getMessageExchangeId(), new WeakReference<MyRoleMessageExchangeImpl>(mex));
    }

    MyRoleMessageExchangeImpl get(MessageExchangeDAO mexdao, ODEProcess process) {
        MyRoleMessageExchangeImpl mex;
        WeakReference<MyRoleMessageExchangeImpl> ref = this._cache.get(mexdao.getMessageExchangeId());
        MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = mex = ref == null ? null : (MyRoleMessageExchangeImpl)ref.get();
        if (mex == null) {
            mex = process.recreateMyRoleMex(mexdao);
            this._cache.put(mexdao.getMessageExchangeId(), new WeakReference<MyRoleMessageExchangeImpl>(mex));
        }
        return mex;
    }

    private void cleanup() {
        Iterator<WeakReference<MyRoleMessageExchangeImpl>> i = this._cache.values().iterator();
        while (i.hasNext()) {
            WeakReference<MyRoleMessageExchangeImpl> ref = i.next();
            if (ref.get() != null) continue;
            i.remove();
        }
        this._inserts = 0;
    }
}

