/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MyRoleMessageExchangeImpl
extends MessageExchangeImpl
implements MyRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(MyRoleMessageExchangeImpl.class);
    protected final QName _callee;
    protected MyRoleMessageExchange.CorrelationStatus _cstatus;
    protected String _clientId;

    public MyRoleMessageExchangeImpl(ODEProcess process, String mexId, PartnerLinkModel oplink, Operation operation, QName callee) {
        super(process, null, mexId, oplink, oplink != null ? oplink.getMyRolePortType() : null, operation);
        this._callee = callee;
    }

    public MyRoleMessageExchange.CorrelationStatus getCorrelationStatus() {
        return this._cstatus;
    }

    @Override
    void load(MessageExchangeDAO dao) {
        super.load(dao);
        this._cstatus = dao.getCorrelationStatus() == null ? null : MyRoleMessageExchange.CorrelationStatus.valueOf((String)dao.getCorrelationStatus());
        this._clientId = dao.getPartnersKey();
    }

    @Override
    public void save(MessageExchangeDAO dao) {
        super.save(dao);
        dao.setCorrelationStatus(this._cstatus == null ? null : this._cstatus.toString());
        dao.setPartnersKey(this._clientId);
        dao.setCallee(this._callee);
        if (this._changes.contains((Object)MessageExchangeImpl.Change.REQUEST)) {
            this._changes.remove((Object)MessageExchangeImpl.Change.REQUEST);
            MessageDAO requestDao = dao.createMessage(this._request.getType());
            requestDao.setData(this._request.getMessage());
            requestDao.setHeader(this._request.getHeader());
            dao.setRequest(requestDao);
        }
    }

    public MessageExchange.FailureType getFailureType() {
        if (this.getStatus() != MessageExchange.Status.ACK || this.getAckType() != MessageExchange.AckType.FAILURE) {
            throw new IllegalStateException("MessageExchange did not fail!");
        }
        return this._failureType;
    }

    public String getClientId() {
        return this._clientId;
    }

    public Future<MessageExchange.Status> invokeAsync() {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public MessageExchange.Status invokeBlocking() throws BpelEngineException, TimeoutException {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public void invokeReliable() {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public MessageExchange.Status invokeTransacted() throws BpelEngineException {
        throw new BpelEngineException("Unsupported InvocationStyle");
    }

    public void setRequest(Message request) {
        this._request = (MessageImpl)request;
        this._changes.add(MessageExchangeImpl.Change.REQUEST);
    }

    public QName getServiceName() {
        return this._callee;
    }

    @Override
    public String toString() {
        try {
            return "{MyRoleMex#" + this._mexId + " [Client " + this._clientId + "] calling " + this._callee + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable t) {
            return "{MyRoleMex#???}";
        }
    }

    public void complete() {
    }

    public void release(boolean instanceSucceeded) {
        if (this._process.isCleanupCategoryEnabled(instanceSucceeded, ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
            }
            this._process.releaseMessageExchange(this.getMessageExchangeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageExchangeDAO doInvoke() {
        if (this.getStatus() != MessageExchange.Status.NEW) {
            throw new IllegalStateException("Invalid state: " + this.getStatus());
        }
        this.request();
        MessageExchangeDAO dao = this._process.createMessageExchange(this.getMessageExchangeId(), 'M');
        this.save(dao);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("invoke() EPR= " + this._epr + " ==> " + this._process));
        }
        try {
            this._process.invokeProcess(dao);
        }
        finally {
            if (dao.getStatus() == MessageExchange.Status.ACK) {
                this._failureType = dao.getFailureType();
                this._fault = dao.getFault();
                this._explanation = dao.getFaultExplanation();
                this.ack(dao.getAckType());
            }
        }
        return dao;
    }

    protected Message cloneMessage(Message message) {
        Message clone = this.createMessage(message.getType());
        clone.setMessage((Element)message.getMessage().cloneNode(true));
        Map headerParts = message.getHeaderParts();
        for (String partName : headerParts.keySet()) {
            clone.setHeaderPart(partName, (Element)((Node)headerParts.get(partName)).cloneNode(true));
        }
        Map parts = message.getHeaderParts();
        for (String partName : parts.keySet()) {
            clone.setHeaderPart(partName, (Element)((Node)parts.get(partName)).cloneNode(true));
        }
        return clone;
    }

    protected abstract void onAsyncAck(MessageExchangeDAO var1);
}

