/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.BpelInstanceWorkerCache;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.DbBackedMessageImpl;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.InterceptorContextImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeCache;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.NStateLatch;
import org.apache.ode.bpel.engine.PartnerLinkMyRoleImpl;
import org.apache.ode.bpel.engine.PartnerLinkPartnerRoleImpl;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ReliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.TransactedMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.UnreliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.engine.extvar.ExternalVariableManager;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.FailMessageExchangeException;
import org.apache.ode.bpel.intercept.FaultMessageExchangeException;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.rapi.ConstantsModel;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRuntime;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.Serializer;
import org.apache.ode.bpel.runtime.InvalidInstanceException;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODEProcess {
    static final Log __log = LogFactory.getLog(ODEProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private volatile Map<PartnerLinkModel, PartnerLinkPartnerRoleImpl> _partnerRoles;
    private volatile Map<PartnerLinkModel, PartnerLinkMyRoleImpl> _myRoles;
    private volatile Map<Endpoint, PartnerLinkMyRoleImpl> _endpointToMyRoleMap;
    private Map<Endpoint, EndpointReference> _myEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, EndpointReference> _partnerEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, PartnerRoleChannel> _partnerChannels = new HashMap<Endpoint, PartnerRoleChannel>();
    private SharedEndpoints _sharedEps;
    final QName _pid;
    private volatile ProcessModel _processModel;
    private boolean _hydratedOnce = false;
    private volatile long _lastUsed;
    volatile OdeRuntime _runtime;
    public DebuggerSupport _debugger;
    final ProcessConf _pconf;
    private final List<MessageExchangeInterceptor> _mexInterceptors = new ArrayList<MessageExchangeInterceptor>();
    HydrationLatch _hydrationLatch;
    protected Contexts _contexts;
    final BpelInstanceWorkerCache _instanceWorkerCache = new BpelInstanceWorkerCache(this);
    private final Set<InvocationStyle> _invocationStyles;
    private final BpelDAOConnectionFactoryImpl _inMemDao;
    final BpelServerImpl _server;
    private MyRoleMessageExchangeCache _myRoleMexCache;
    private ExternalVariableConf _extVarConf;
    private ExternalVariableManager _evm;

    ODEProcess(BpelServerImpl server, ProcessConf conf, BpelEventListener debugger, MyRoleMessageExchangeCache mexCache) {
        this._server = server;
        this._pid = conf.getProcessId();
        this._pconf = conf;
        this._hydrationLatch = new HydrationLatch();
        this._contexts = server._contexts;
        this._inMemDao = new BpelDAOConnectionFactoryImpl(this._contexts.txManager);
        this._myRoleMexCache = mexCache;
        HashSet<InvocationStyle> istyles = new HashSet<InvocationStyle>();
        istyles.add(InvocationStyle.UNRELIABLE);
        if (!conf.isTransient()) {
            istyles.add(InvocationStyle.RELIABLE);
        } else {
            istyles.add(InvocationStyle.TRANSACTED);
        }
        this._invocationStyles = Collections.unmodifiableSet(istyles);
    }

    public URI getBaseResourceURI() {
        return this._pconf.getBaseURI();
    }

    void initExternalVariables() {
        List conf = this._pconf.getExtensionElement(ExternalVariableConf.EXTVARCONF_ELEMENT);
        this._extVarConf = new ExternalVariableConf(conf);
        this._evm = new ExternalVariableManager(this._pid, this._extVarConf, this._contexts.externalVariableEngines);
    }

    public OdeConfigProperties getProperties() {
        return this._server.getConfigProperties();
    }

    public String toString() {
        return "ODEProcess[" + this._pid + "]";
    }

    public ExternalVariableManager getEVM() {
        return this._evm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverActivity(ProcessInstanceDAO instanceDAO, final String channel, final long activityId, final String action, final FaultInfo fault) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Recovering activity in process " + instanceDAO.getInstanceId() + " with action " + action));
        }
        this._hydrationLatch.latch(1);
        try {
            this.markused();
            BpelInstanceWorker iworker = this._instanceWorkerCache.get(instanceDAO.getInstanceId());
            OdeRTInstance rti = this._runtime.newInstance(this.getState(iworker, instanceDAO));
            final BpelRuntimeContextImpl processInstance = new BpelRuntimeContextImpl(iworker, instanceDAO, rti);
            try {
                iworker.execInCurrentThread(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        processInstance.recoverActivity(channel, activityId, action, fault);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new BpelEngineException((Throwable)e);
            }
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeProcess(final MessageExchangeDAO mexdao) {
        block41: {
            QName faultQname;
            Document document;
            InvocationStyle istyle = mexdao.getInvocationStyle();
            ConstantsModel constants = null;
            this._hydrationLatch.latch(1);
            try {
                PartnerLinkMyRoleImpl target = this.getMyRoleForService(mexdao.getCallee());
                constants = target._process.getProcessModel().getConstantsModel();
                MessageExchange.Status oldstatus = mexdao.getStatus();
                if (target == null) {
                    String errmsg = __msgs.msgMyRoleRoutingFailure(mexdao.getMessageExchangeId());
                    __log.error((Object)errmsg);
                    MexDaoUtil.setFailed(mexdao, MessageExchange.FailureType.UNKNOWN_ENDPOINT, errmsg);
                    this.onMyRoleMexAck(mexdao, oldstatus);
                    return;
                }
                Operation op = target._plinkDef.getMyRoleOperation(mexdao.getOperation());
                if (op == null) {
                    String errmsg = __msgs.msgMyRoleRoutingFailure(mexdao.getMessageExchangeId());
                    __log.error((Object)errmsg);
                    MexDaoUtil.setFailed(mexdao, MessageExchange.FailureType.UNKNOWN_OPERATION, errmsg);
                    this.onMyRoleMexAck(mexdao, oldstatus);
                    return;
                }
                mexdao.setPattern(op.getOutput() == null ? MessageExchange.MessageExchangePattern.REQUEST_ONLY : MessageExchange.MessageExchangePattern.REQUEST_RESPONSE);
                if (!this.processInterceptors(mexdao, InterceptorInvoker.__onProcessInvoked)) {
                    __log.debug((Object)("Aborting processing of mex " + mexdao.getMessageExchangeId() + " due to interceptors."));
                    this.onMyRoleMexAck(mexdao, oldstatus);
                    return;
                }
                if (op.getOutput() == null) {
                    mexdao.setStatus(MessageExchange.Status.ACK);
                    mexdao.setAckType(MessageExchange.AckType.ONEWAY);
                    this.onMyRoleMexAck(mexdao, oldstatus);
                }
                mexdao.setProcess(this.getProcessDAO());
                this.markused();
                MyRoleMessageExchange.CorrelationStatus cstatus = target.invokeMyRole(mexdao);
                if (cstatus == null) {
                } else if (cstatus == MyRoleMessageExchange.CorrelationStatus.CREATE_INSTANCE) {
                    this.doInstanceWork(mexdao.getInstance().getInstanceId(), new Callable<Void>(){

                        @Override
                        public Void call() {
                            ODEProcess.this.executeCreateInstance(mexdao);
                            return null;
                        }
                    });
                } else if (cstatus == MyRoleMessageExchange.CorrelationStatus.MATCHED) {
                    if (this.isInMemory()) {
                        __log.warn((Object)("In-memory process " + this._pid + " is participating in a non-createinstance exchange!"));
                    }
                    if (mexdao.getInstance().getState() == 60) {
                        throw new InvalidInstanceException("Trying to invoke terminated process instance", 1);
                    }
                    if (op.getOutput() != null && mexdao.getInstance().getState() == 50) {
                        throw new InvalidInstanceException("Trying to invoke suspended instance", 2);
                    }
                    if (istyle == InvocationStyle.TRANSACTED) {
                        this.doInstanceWork(mexdao.getInstance().getInstanceId(), new Callable<Void>(){

                            @Override
                            public Void call() {
                                ODEProcess.this.executeContinueInstanceMyRoleRequestReceived(mexdao);
                                return null;
                            }
                        });
                    } else if (istyle == InvocationStyle.P2P_TRANSACTED) {
                        this.executeContinueInstanceMyRoleRequestReceived(mexdao);
                    } else {
                        WorkEvent we = new WorkEvent();
                        we.setType(WorkEvent.Type.MYROLE_INVOKE);
                        we.setIID(mexdao.getInstance().getInstanceId());
                        we.setMexId(mexdao.getMessageExchangeId());
                        we.setProcessId(mexdao.getInstance().getProcess().getProcessId());
                        this.scheduleWorkEvent(we, null);
                    }
                } else if (cstatus == MyRoleMessageExchange.CorrelationStatus.QUEUED) {
                    // empty if block
                }
            }
            catch (InvalidProcessException ipe) {
                QName faultQName = null;
                if (constants != null) {
                    document = DOMUtils.newDocument();
                    Element faultElement = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                    Element faultDetail = document.createElementNS("http://www.apache.org/ode/type/extension", "fault");
                    faultElement.appendChild(faultDetail);
                    switch (ipe.getCauseCode()) {
                        case 2: {
                            faultQName = constants.getDuplicateInstance();
                            faultDetail.setTextContent("Found a duplicate instance with the same message key");
                            break;
                        }
                        case 1: {
                            faultQName = constants.getRetiredProcess();
                            faultDetail.setTextContent("The process you're trying to instantiate has been retired");
                            break;
                        }
                        default: {
                            faultQName = constants.getUnknownFault();
                        }
                    }
                    MexDaoUtil.setFaulted(mexdao, faultQName, faultElement);
                }
            }
            catch (InvalidInstanceException iie) {
                faultQname = null;
                if (constants != null) {
                    document = DOMUtils.newDocument();
                    Element faultElement = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                    Element faultDetail = document.createElementNS("http://www.apache.org/ode/type/extension", "fault");
                    faultElement.appendChild(faultDetail);
                    switch (iie.getCauseCode()) {
                        case 1: {
                            faultQname = new QName("ode", "TerminatedInstance");
                            faultDetail.setTextContent(iie.getMessage());
                            break;
                        }
                        case 2: {
                            faultQname = new QName("ode", "SuspendedInstance");
                            faultDetail.setTextContent(iie.getMessage());
                            break;
                        }
                        default: {
                            faultQname = constants.getUnknownFault();
                        }
                    }
                    MexDaoUtil.setFaulted(mexdao, faultQname, faultElement);
                }
            }
            catch (BpelEngineException bee) {
                faultQname = null;
                document = DOMUtils.newDocument();
                Element faultElement = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                Element faultDetail = document.createElementNS("http://www.apache.org/ode/type/extension", "fault");
                faultElement.appendChild(faultDetail);
                faultQname = new QName("ode", "BpelEngineException");
                faultDetail.setTextContent(bee.getMessage());
                MexDaoUtil.setFaulted(mexdao, faultQname, faultElement);
            }
            finally {
                this._hydrationLatch.release(1);
                if (mexdao.getStatus() != MessageExchange.Status.ACK) {
                    mexdao.setStatus(MessageExchange.Status.ASYNC);
                }
                if ($assertionsDisabled || mexdao.getStatus() == MessageExchange.Status.ACK || mexdao.getStatus() == MessageExchange.Status.ASYNC) break block41;
                throw new AssertionError();
            }
        }
    }

    void executeCreateInstance(MessageExchangeDAO mexdao) {
        assert (this._hydrationLatch.isLatched(1));
        BpelInstanceWorker worker = this._instanceWorkerCache.get(mexdao.getInstance().getInstanceId());
        assert (worker.isWorkerThread());
        BpelRuntimeContextImpl rtictx = new BpelRuntimeContextImpl(worker, mexdao.getInstance(), this._runtime.newInstance(this.getState(worker, mexdao.getInstance())));
        rtictx.executeCreateInstance(mexdao);
    }

    void executeContinueInstanceMyRoleRequestReceived(MessageExchangeDAO mexdao) {
        assert (this._hydrationLatch.isLatched(1));
        assert (mexdao != null);
        assert (mexdao.getInstance() != null);
        BpelInstanceWorker worker = this._instanceWorkerCache.get(mexdao.getInstance().getInstanceId());
        assert (worker.isWorkerThread());
        OdeRTInstance rti = this._runtime.newInstance(this.getState(worker, mexdao.getInstance()));
        BpelRuntimeContextImpl instance = new BpelRuntimeContextImpl(worker, mexdao.getInstance(), rti);
        int amp = mexdao.getChannel().indexOf(38);
        String groupId = mexdao.getChannel().substring(0, amp);
        int idx = Integer.valueOf(mexdao.getChannel().substring(amp + 1));
        instance.injectMyRoleMessageExchange(groupId, idx, mexdao);
        instance.execute();
    }

    void executeContinueInstanceResume(ProcessInstanceDAO instanceDao, int retryCount) {
        BpelInstanceWorker worker = this._instanceWorkerCache.get(instanceDao.getInstanceId());
        assert (worker.isWorkerThread());
        OdeRTInstance rti = this._runtime.newInstance(this.getState(worker, instanceDao));
        BpelRuntimeContextImpl brc = new BpelRuntimeContextImpl(worker, instanceDao, rti);
        brc.setRetryCount(retryCount);
        brc.execute();
    }

    void executeContinueInstanceTimerReceived(ProcessInstanceDAO instanceDao, String timerChannel) {
        BpelInstanceWorker worker = this._instanceWorkerCache.get(instanceDao.getInstanceId());
        assert (worker.isWorkerThread());
        OdeRTInstance rti = this._runtime.newInstance(this.getState(worker, instanceDao));
        BpelRuntimeContextImpl brc = new BpelRuntimeContextImpl(worker, instanceDao, rti);
        if (brc.injectTimerEvent(timerChannel)) {
            brc.execute();
        }
    }

    private void executeContinueInstanceMatcherEvent(ProcessInstanceDAO instanceDao, String correlatorId, CorrelationKey correlationKey) {
        CorrelatorDAO correlator;
        MessageRouteDAO mroute;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("MatcherEvent handling: correlatorId=" + correlatorId + ", ckey=" + correlationKey));
        }
        if ((mroute = (correlator = instanceDao.getProcess().getCorrelator(correlatorId)).findRoute(correlationKey)) == null) {
            __log.debug((Object)"MatcherEvent handling: nothing to do, route no longer in DB");
            return;
        }
        MessageExchangeDAO mexdao = correlator.dequeueMessage(correlationKey);
        if (mexdao != null) {
            __log.debug((Object)"MatcherEvent handling: found matching message in DB (i.e. message arrived before <receive>)");
            correlator.removeRoutes(mroute.getGroupId(), instanceDao);
            mexdao.setInstance(instanceDao);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("SELECT: " + mroute.getGroupId() + ": matched to MESSAGE " + mexdao + " on CKEY " + correlationKey));
            }
            BpelInstanceWorker worker = this._instanceWorkerCache.get(instanceDao.getInstanceId());
            assert (worker.isWorkerThread());
            OdeRTInstance rti = this._runtime.newInstance(this.getState(worker, mexdao.getInstance()));
            BpelRuntimeContextImpl brc = new BpelRuntimeContextImpl(worker, instanceDao, rti);
            brc.injectMyRoleMessageExchange(mroute.getGroupId(), mroute.getIndex(), mexdao);
            brc.execute();
            mexdao.release(true);
        } else {
            __log.debug((Object)"MatcherEvent handling: nothing to do, no matching message in DB");
        }
    }

    void executeContinueInstancePartnerRoleResponseReceived(MessageExchangeDAO mexdao) {
        assert (this._hydrationLatch.isLatched(1));
        ProcessInstanceDAO instanceDao = mexdao.getInstance();
        if (instanceDao == null) {
            throw new BpelEngineException("InternalError: No instance for partner mex " + mexdao);
        }
        BpelInstanceWorker worker = this._instanceWorkerCache.get(mexdao.getInstance().getInstanceId());
        assert (worker.isWorkerThread());
        OdeRTInstance rti = this._runtime.newInstance(this.getState(worker, mexdao.getInstance()));
        BpelRuntimeContextImpl brc = new BpelRuntimeContextImpl(worker, mexdao.getInstance(), rti);
        String jobId = mexdao.getProperty("invokeCheckJobId");
        if (jobId != null) {
            this._contexts.scheduler.cancelJob(jobId);
        }
        brc.injectPartnerResponse(mexdao.getMessageExchangeId(), mexdao.getChannel());
        brc.execute();
    }

    void enqueueInstanceTransaction(Long instanceId, Runnable runnable) {
        if (instanceId == null) {
            throw new NullPointerException("instanceId was null!");
        }
        BpelInstanceWorker iworker = this._instanceWorkerCache.get(instanceId);
        BpelServerImpl bpelServerImpl = this._server;
        bpelServerImpl.getClass();
        iworker.enqueue(bpelServerImpl.new BpelServerImpl.TransactedRunnable(runnable));
    }

    private <T> T doInstanceWork(Long instanceId, Callable<T> callable) {
        try {
            BpelInstanceWorker iworker = this._instanceWorkerCache.get(instanceId);
            return iworker.execInCurrentThread(new ProcessCallable<T>(callable));
        }
        catch (Exception ex) {
            throw new BpelEngineException((Throwable)ex);
        }
    }

    private PartnerLinkMyRoleImpl getMyRoleForService(QName serviceName) {
        assert (this._hydrationLatch.isLatched(1));
        for (Map.Entry<Endpoint, PartnerLinkMyRoleImpl> e : this._endpointToMyRoleMap.entrySet()) {
            if (!e.getKey().serviceName.equals(serviceName)) continue;
            return e.getValue();
        }
        return null;
    }

    boolean processInterceptors(MessageExchangeDAO mexdao, InterceptorInvoker invoker) {
        InterceptorContextImpl ictx = new InterceptorContextImpl(this._contexts.dao.getConnection(), mexdao, this.getProcessDAO(), this._pconf);
        try {
            for (MessageExchangeInterceptor interceptor : this._mexInterceptors) {
                invoker.invoke(interceptor, ictx);
            }
            for (MessageExchangeInterceptor interceptor : this._server._contexts.globalIntereceptors) {
                invoker.invoke(interceptor, ictx);
            }
        }
        catch (FailMessageExchangeException e) {
            MexDaoUtil.setFailed(mexdao, MessageExchange.FailureType.ABORTED, e.getMessage());
            return false;
        }
        catch (FaultMessageExchangeException e) {
            MexDaoUtil.setFaulted(mexdao, e.getFaultName(), e.getFaultData());
            return false;
        }
        return true;
    }

    void handleWorkEvent(final Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        assert (!this._contexts.isTransacted()) : "work events must be received outside of a transaction";
        this.markused();
        final WorkEvent we = new WorkEvent(jobInfo.jobDetail);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)ObjectPrinter.stringifyMethodEnter((String)"handleWorkEvent", (Object[])new Object[]{"jobInfo", jobInfo}));
        }
        this.enqueueInstanceTransaction(we.getIID(), new Runnable(){

            public void run() {
                ODEProcess.this._contexts.scheduler.jobCompleted(jobInfo.jobName);
                ODEProcess.this.execInstanceEvent(we);
            }
        });
    }

    <T> Future<T> enqueueTransaction(Callable<T> tx) {
        return this._server.enqueueTransaction(new ProcessCallable<T>(tx));
    }

    private Object getState(BpelInstanceWorker worker, ProcessInstanceDAO instanceDAO) {
        ExecutionQueueImpl state = (ExecutionQueueImpl)worker.getCachedState(instanceDAO.getExecutionStateCounter());
        if (state != null) {
            return state;
        }
        if (this.isInMemory()) {
            ProcessInstanceDaoImpl inmem = (ProcessInstanceDaoImpl)instanceDAO;
            if (inmem.getSoup() != null) {
                state = (ExecutionQueueImpl)inmem.getSoup();
            }
        } else {
            byte[] daoState = instanceDAO.getExecutionState();
            if (daoState != null) {
                state = new ExecutionQueueImpl(this.getClass().getClassLoader());
                state.setReplacementMap((ReplacementMap)this._runtime.getReplacementMap(instanceDAO.getProcess().getProcessId()));
                ByteArrayInputStream iis = new ByteArrayInputStream(daoState);
                try {
                    state.read((InputStream)iis);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return state;
    }

    private void execInstanceEvent(WorkEvent we) {
        MessageExchangeDAO mexDao;
        BpelInstanceWorker worker = this._instanceWorkerCache.get(we.getIID());
        assert (worker.isWorkerThread());
        ProcessInstanceDAO instanceDAO = this.getProcessDAO().getInstance(we.getIID());
        MessageExchangeDAO messageExchangeDAO = mexDao = we.getMexId() == null ? null : this.loadMexDao(we.getMexId());
        if (instanceDAO == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("handleWorkEvent: no ProcessInstance found with iid " + we.getIID() + "; ignoring."));
            }
            return;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("handleWorkEvent: " + (Object)((Object)we.getType()) + " event for process instance " + we.getIID()));
        }
        switch (we.getType()) {
            case MYROLE_INVOKE: {
                this.executeContinueInstanceMyRoleRequestReceived(mexDao);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("handleWorkEvent: releasing myrole mex dao: " + mexDao));
                }
                mexDao.release(true);
                break;
            }
            case TIMER: {
                this.executeContinueInstanceTimerReceived(instanceDAO, we.getChannel());
                break;
            }
            case RESUME: {
                this.executeContinueInstanceResume(instanceDAO, we.getRetryCount());
                break;
            }
            case PARTNER_RESPONSE: {
                this.executeContinueInstancePartnerRoleResponseReceived(mexDao);
                break;
            }
            case MATCHER: {
                this.executeContinueInstanceMatcherEvent(instanceDAO, we.getCorrelatorId(), we.getCorrelationKey());
            }
        }
    }

    MessageExchangeDAO loadMexDao(String mexId) {
        return this.isInMemory() ? this._inMemDao.getConnection().getMessageExchange(mexId) : this._contexts.dao.getConnection().getMessageExchange(mexId);
    }

    private void setRoles(ProcessModel oprocess) {
        PartnerLinkModel plink;
        this._partnerRoles = new HashMap<PartnerLinkModel, PartnerLinkPartnerRoleImpl>();
        this._myRoles = new HashMap<PartnerLinkModel, PartnerLinkMyRoleImpl>();
        this._endpointToMyRoleMap = new HashMap<Endpoint, PartnerLinkMyRoleImpl>();
        HashMap myRoleEndpoints = new HashMap();
        for (Map.Entry provide : this._pconf.getProvideEndpoints().entrySet()) {
            plink = oprocess.getPartnerLink((String)provide.getKey());
            if (plink == null) {
                String errmsg = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)provide.getKey();
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            myRoleEndpoints.put(plink, provide.getValue());
        }
        for (Map.Entry invoke : this._pconf.getInvokeEndpoints().entrySet()) {
            plink = oprocess.getPartnerLink((String)invoke.getKey());
            if (plink == null) {
                String errmsg = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)invoke.getKey();
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            __log.debug((Object)("Processing <invoke> element for process " + this._pid + ": partnerlink " + (String)invoke.getKey() + " --> " + invoke.getValue()));
        }
        for (PartnerLinkModel pl : oprocess.getAllPartnerLinks()) {
            Endpoint endpoint;
            if (pl.hasMyRole()) {
                endpoint = (Endpoint)myRoleEndpoints.get(pl);
                if (endpoint == null) {
                    throw new IllegalArgumentException("No service name for myRole plink " + pl.getName());
                }
                PartnerLinkMyRoleImpl myRole = new PartnerLinkMyRoleImpl(this, pl, endpoint);
                this._myRoles.put(pl, myRole);
                this._endpointToMyRoleMap.put(endpoint, myRole);
            }
            if (!pl.hasPartnerRole()) continue;
            endpoint = (Endpoint)this._pconf.getInvokeEndpoints().get(pl.getName());
            if (endpoint == null && pl.isInitializePartnerRoleSet()) {
                throw new IllegalArgumentException(pl.getName() + " must be bound to an endpoint in deloy.xml");
            }
            PartnerLinkPartnerRoleImpl partnerRole = new PartnerLinkPartnerRoleImpl(this, pl, endpoint);
            this._partnerRoles.put(pl, partnerRole);
        }
    }

    ProcessDAO getProcessDAO() {
        return this.isInMemory() ? this._inMemDao.getConnection().getProcess(this._pid) : this._contexts.dao.getConnection().getProcess(this._pid);
    }

    static String genCorrelatorId(PartnerLinkModel plink, String opName) {
        return plink.getId() + "." + opName;
    }

    public Set<Endpoint> getServiceNames() {
        HashSet<Endpoint> endpoints = new HashSet<Endpoint>();
        for (Endpoint provide : this._pconf.getProvideEndpoints().values()) {
            endpoints.add(provide);
        }
        return endpoints;
    }

    void activate(Contexts contexts) {
        this._contexts = contexts;
        this._debugger = new DebuggerSupport(this);
        __log.debug((Object)("Activating " + this._pid));
        for (Map.Entry entry : this._pconf.getProvideEndpoints().entrySet()) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            EndpointReference initialEPR = null;
            if (this.isShareable(endpoint)) {
                initialEPR = this._sharedEps.getEndpointReference(endpoint);
                if (initialEPR == null) {
                    initialEPR = this._contexts.bindingContext.activateMyRoleEndpoint(this._pid, (Endpoint)entry.getValue());
                    this._sharedEps.addEndpoint(endpoint, initialEPR);
                    __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + initialEPR));
                }
                this._sharedEps.incrementReferenceCount(endpoint);
            } else {
                initialEPR = this._contexts.bindingContext.activateMyRoleEndpoint(this._pid, (Endpoint)entry.getValue());
                __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + initialEPR));
            }
            this._myEprs.put(endpoint, initialEPR);
        }
        __log.debug((Object)("Activated " + this._pid));
        this.markused();
    }

    void deactivate() {
        for (Endpoint endpoint : this._myEprs.keySet()) {
            if (this.isShareable(endpoint)) {
                __log.debug((Object)("deactivating shared endpoint " + endpoint));
                if (this._sharedEps.decrementReferenceCount(endpoint)) continue;
                this._contexts.bindingContext.deactivateMyRoleEndpoint(endpoint);
                this._sharedEps.removeEndpoint(endpoint);
                continue;
            }
            __log.debug((Object)("deactivating non-shared endpoint " + endpoint));
            this._contexts.bindingContext.deactivateMyRoleEndpoint(endpoint);
        }
    }

    private boolean isShareable(Endpoint endpoint) {
        if (!this._pconf.isSharedService(endpoint.serviceName)) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReference getInitialPartnerRoleEPR(PartnerLinkModel link) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(link);
            if (prole == null) {
                throw new IllegalStateException("Unknown partner link " + link);
            }
            EndpointReference endpointReference = prole.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Endpoint getInitialPartnerRoleEndpoint(PartnerLinkModel link) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(link);
            if (prole == null) {
                throw new IllegalStateException("Unknown partner link " + link);
            }
            Endpoint endpoint = prole._initialPartner;
            return endpoint;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointReference getInitialMyRoleEPR(PartnerLinkModel link) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkMyRoleImpl myRole = this._myRoles.get(link);
            if (myRole == null) {
                throw new IllegalStateException("Unknown partner link " + link);
            }
            EndpointReference endpointReference = myRole.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    QName getPID() {
        return this._pid;
    }

    QName getProcessType() {
        return this._pconf.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartnerRoleChannel getPartnerRoleChannel(PartnerLinkModel partnerLink) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(partnerLink);
            if (prole == null) {
                throw new IllegalStateException("Unknown partner link " + partnerLink);
            }
            PartnerRoleChannel partnerRoleChannel = prole._channel;
            return partnerRoleChannel;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public void saveEvent(ProcessInstanceEvent event, ProcessInstanceDAO instanceDao) {
        this.saveEvent(event, instanceDao, null);
    }

    public void saveEvent(ProcessInstanceEvent event, ProcessInstanceDAO instanceDao, List<String> scopeNames) {
        this.markused();
        if (this._pconf.isEventEnabled(scopeNames, event.getType())) {
            this._server.fireEvent((BpelEvent)event);
            if (instanceDao != null) {
                instanceDao.insertBpelEvent(event);
            } else {
                __log.debug((Object)"Couldn't find instance to save event, no event generated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dehydrate() {
        this._hydrationLatch.latch(0);
        this._hydrationLatch.release(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hydrate() {
        this._hydrationLatch.latch(1);
        this._hydrationLatch.release(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessModel getProcessModel() {
        this._hydrationLatch.latch(1);
        try {
            ProcessModel processModel = this._processModel;
            return processModel;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private MyRoleMessageExchangeImpl newMyRoleMex(InvocationStyle istyle, String mexId, QName target, PartnerLinkModel mplink, Operation operation) {
        MyRoleMessageExchangeImpl mex;
        switch (istyle) {
            case RELIABLE: {
                mex = new ReliableMyRoleMessageExchangeImpl(this, mexId, mplink, operation, target);
                break;
            }
            case TRANSACTED: {
                mex = new TransactedMyRoleMessageExchangeImpl(this, mexId, mplink, operation, target);
                break;
            }
            case UNRELIABLE: {
                mex = new UnreliableMyRoleMessageExchangeImpl(this, mexId, mplink, operation, target);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected invocation style: " + istyle));
            }
        }
        this._myRoleMexCache.put(mex);
        return mex;
    }

    MyRoleMessageExchangeImpl lookupMyRoleMex(MessageExchangeDAO mexdao) {
        return this._myRoleMexCache.get(mexdao, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyRoleMessageExchangeImpl recreateMyRoleMex(MessageExchangeDAO mexdao) {
        InvocationStyle istyle = mexdao.getInvocationStyle();
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkModel plink = this._processModel.getPartnerLink(mexdao.getPartnerLinkModelId());
            if (plink == null) {
                String errmsg = __msgs.msgDbConsistencyError("MexDao #" + mexdao.getMessageExchangeId() + " referenced unknown pLinkModelId " + mexdao.getPartnerLinkModelId());
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            Operation op = plink.getMyRoleOperation(mexdao.getOperation());
            if (op == null) {
                String errmsg = __msgs.msgDbConsistencyError("MexDao #" + mexdao.getMessageExchangeId() + " referenced unknown operation " + mexdao.getOperation());
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            PartnerLinkMyRoleImpl myRole = this._myRoles.get(plink);
            if (myRole == null) {
                String errmsg = __msgs.msgDbConsistencyError("MexDao #" + mexdao.getMessageExchangeId() + " referenced non-existant myrole");
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            MyRoleMessageExchangeImpl mex = this.newMyRoleMex(istyle, mexdao.getMessageExchangeId(), myRole._endpoint.serviceName, plink, op);
            mex.load(mexdao);
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = mex;
            return myRoleMessageExchangeImpl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartnerRoleMessageExchangeImpl createPartnerRoleMex(MessageExchangeDAO mexdao) {
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkModel plink = this._processModel.getPartnerLink(mexdao.getPartnerLinkModelId());
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(plink);
            PartnerRoleMessageExchangeImpl partnerRoleMessageExchangeImpl = prole.createPartnerRoleMex(mexdao);
            return partnerRoleMessageExchangeImpl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    Set<InvocationStyle> getSupportedInvocationStyle(QName serviceId) {
        return this._invocationStyles;
    }

    private PartnerLinkMyRoleImpl getPartnerLinkForService(QName serviceName) {
        assert (this._hydrationLatch.isLatched(1));
        PartnerLinkMyRoleImpl target = null;
        for (Endpoint endpoint : this._endpointToMyRoleMap.keySet()) {
            if (!endpoint.serviceName.equals(serviceName)) continue;
            target = this._endpointToMyRoleMap.get(endpoint);
        }
        return target;
    }

    public boolean isInMemory() {
        return this._pconf.isTransient();
    }

    public long getLastUsed() {
        return this._lastUsed;
    }

    public boolean hintIsHydrated() {
        return this._processModel != null;
    }

    private final void markused() {
        this._lastUsed = System.currentTimeMillis();
    }

    private void bounceProcessDAO(BpelDAOConnection conn, QName pid, long version, ProcessModel mprocess) {
        this.deleteProcessDAO(conn, pid, version, mprocess);
        this.createProcessDAO(conn, pid, version, mprocess);
    }

    private void deleteProcessDAO(BpelDAOConnection conn, QName pid, long version, ProcessModel mprocess) {
        __log.debug((Object)("Creating process DAO for " + pid + " (guid=" + mprocess.getGuid() + ")"));
        try {
            ProcessDAO old = conn.getProcess(pid);
            if (old != null) {
                __log.debug((Object)("Found ProcessDAO for " + pid + " with GUID " + old.getGuid()));
                if (mprocess.getGuid() != null && !old.getGuid().equals(mprocess.getGuid())) {
                    String errmsg = "ProcessDAO GUID " + old.getGuid() + " does not match " + mprocess.getGuid() + "; replacing.";
                    __log.debug((Object)errmsg);
                    old.delete();
                }
            }
        }
        catch (BpelEngineException ex) {
            throw ex;
        }
        catch (Exception dce) {
            __log.error((Object)"DbError", (Throwable)dce);
            throw new BpelEngineException("DbError", (Throwable)dce);
        }
    }

    private void createProcessDAO(BpelDAOConnection conn, QName pid, long version, ProcessModel mprocess) {
        __log.debug((Object)("Creating process DAO for " + pid + " (guid=" + mprocess.getGuid() + ")"));
        try {
            boolean create = true;
            ProcessDAO old = conn.getProcess(pid);
            if (old != null) {
                __log.debug((Object)("Found ProcessDAO for " + pid + " with GUID " + old.getGuid()));
                if (mprocess.getGuid() == null) {
                    create = false;
                } else if (old.getGuid().equals(mprocess.getGuid())) {
                    create = false;
                } else {
                    String errmsg = "ProcessDAO GUID " + old.getGuid() + " does not match " + mprocess.getGuid() + "; replacing.";
                    __log.debug((Object)errmsg);
                }
            }
            if (create) {
                ProcessDAO newDao = conn.createProcess(pid, mprocess.getQName(), mprocess.getGuid(), (long)((int)version));
                for (String correlator : mprocess.getCorrelators()) {
                    newDao.addCorrelator(correlator);
                }
            }
        }
        catch (BpelEngineException ex) {
            throw ex;
        }
        catch (Exception dce) {
            __log.error((Object)"DbError", (Throwable)dce);
            throw new BpelEngineException("DbError", (Throwable)dce);
        }
    }

    MessageExchangeDAO createMessageExchange(String mexId, char dir) {
        if (this.isInMemory()) {
            return this._inMemDao.getConnection().createMessageExchange(mexId, dir);
        }
        return this._contexts.dao.getConnection().createMessageExchange(mexId, dir);
    }

    MessageExchangeDAO getInMemMexDAO(String mexId) {
        return this._inMemDao.getConnection().getMessageExchange(mexId);
    }

    public void releaseMessageExchange(final String mexId) {
        if (this.isInMemory()) {
            this._inMemDao.getConnection().releaseMessageExchange(mexId);
        } else if (this._contexts.isTransacted()) {
            this._contexts.dao.getConnection().releaseMessageExchange(mexId);
        } else {
            try {
                this._contexts.execTransaction(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ODEProcess.this._contexts.dao.getConnection().releaseMessageExchange(mexId);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void scheduleRunnable(Runnable runnable) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("schedulingRunnable for process " + this._pid + ": " + runnable));
        }
        this._server.scheduleRunnable(new ProcessRunnable(runnable));
    }

    void enqueueRunnable(BpelInstanceWorker worker) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("enqueuRunnable for process " + this._pid + ": " + worker));
        }
        this._server.enqueueRunnable(new ProcessRunnable(worker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyRoleMessageExchange createNewMyRoleMex(InvocationStyle istyle, QName targetService, String operation) {
        String mexId = new GUID().toString();
        this._hydrationLatch.latch(1);
        try {
            PartnerLinkMyRoleImpl target = this.getPartnerLinkForService(targetService);
            if (target == null) {
                throw new BpelEngineException("NoSuchService: " + targetService);
            }
            Operation op = target._plinkDef.getMyRoleOperation(operation);
            if (op == null) {
                throw new BpelEngineException("NoSuchOperation: " + operation);
            }
            MyRoleMessageExchangeImpl myRoleMessageExchangeImpl = this.newMyRoleMex(istyle, mexId, target._endpoint.serviceName, target._plinkDef, op);
            return myRoleMessageExchangeImpl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    void onMyRoleMexAck(MessageExchangeDAO mexdao, MessageExchange.Status old) {
        if (mexdao.getPipedMessageExchangeId() != null) {
            boolean compat;
            ODEProcess caller = this._server.getBpelProcess(mexdao.getPipedPID());
            if (caller == null) {
                return;
            }
            MessageExchangeDAO pmex = caller.loadMexDao(mexdao.getPipedMessageExchangeId());
            if (pmex == null) {
                return;
            }
            boolean bl = compat = !(caller.isInMemory() ^ this.isInMemory());
            if (compat) {
                pmex.setResponse(mexdao.getResponse());
            } else if (mexdao.getAckType() != MessageExchange.AckType.ONEWAY) {
                MessageDAO presponse = pmex.createMessage(mexdao.getResponse().getType());
                presponse.setData(mexdao.getResponse().getData());
                presponse.setHeader(mexdao.getResponse().getHeader());
                pmex.setResponse(presponse);
            } else {
                pmex.setResponse(null);
            }
            pmex.setFault(mexdao.getFault());
            pmex.setStatus(mexdao.getStatus());
            pmex.setAckType(mexdao.getAckType());
            pmex.setFailureType(mexdao.getFailureType());
            if (old == MessageExchange.Status.ASYNC) {
                caller.p2pWakeup(pmex);
            }
        } else if (old == MessageExchange.Status.ASYNC) {
            MyRoleMessageExchangeImpl mymex = this._myRoleMexCache.get(mexdao, this);
            mymex.onAsyncAck(mexdao);
            try {
                this._contexts.mexContext.onMyRoleMessageExchangeStateChanged((MyRoleMessageExchange)mymex);
            }
            catch (Throwable t) {
                __log.error((Object)"Integration layer threw an unexepcted exception.", t);
            }
        }
    }

    private ProcessModel deserializeCompiledProcess(InputStream is) throws IOException, ClassNotFoundException {
        Serializer ofh = new Serializer(is);
        ProcessModel compiledProcess = ofh.readPModel();
        return compiledProcess;
    }

    public String scheduleWorkEvent(WorkEvent we, Date timeToFire) {
        return this._contexts.scheduler.schedulePersistedJob(we.getDetail(), timeToFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokePartner(MessageExchangeDAO mexdao) {
        PartnerLinkModel oplink = this._processModel.getPartnerLink(mexdao.getPartnerLinkModelId());
        PartnerLinkPartnerRoleImpl partnerRole = this._partnerRoles.get(oplink);
        Endpoint partnerEndpoint = this.getInitialPartnerRoleEndpoint(oplink);
        List<ODEProcess> p2pProcesses = null;
        if (partnerEndpoint != null) {
            p2pProcesses = this._server.route(partnerEndpoint.serviceName, new DbBackedMessageImpl(mexdao.getRequest()));
        }
        Operation operation = oplink.getPartnerRoleOperation(mexdao.getOperation());
        if (!this.processInterceptors(mexdao, InterceptorInvoker.__onPartnerInvoked)) {
            __log.debug((Object)"Partner invocation intercepted.");
            return;
        }
        mexdao.setStatus(MessageExchange.Status.REQ);
        try {
            if (p2pProcesses != null && p2pProcesses.size() != 0) {
                MessageDAO request = mexdao.getRequest();
                for (ODEProcess p2pProcess : p2pProcesses) {
                    MessageDAO clone = mexdao.createMessage(request.getType());
                    clone.setData((Element)request.getData().cloneNode(true));
                    clone.setHeader((Element)request.getHeader().cloneNode(true));
                    mexdao.setRequest(clone);
                    this.invokeP2P(p2pProcess, partnerEndpoint.serviceName, operation, mexdao);
                }
            } else {
                partnerRole.invokeIL(mexdao);
                this.scheduleInvokeCheck(mexdao);
            }
        }
        finally {
            if (mexdao.getStatus() != MessageExchange.Status.ACK) {
                mexdao.setStatus(MessageExchange.Status.ASYNC);
            }
        }
        assert (mexdao.getStatus() == MessageExchange.Status.ACK || mexdao.getStatus() == MessageExchange.Status.ASYNC);
    }

    private void scheduleInvokeCheck(MessageExchangeDAO mex) {
        boolean isTwoWay;
        boolean bl = isTwoWay = mex.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (!this.isInMemory() && isTwoWay) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Creating invocation check event for mexid " + mex.getMessageExchangeId()));
            }
            WorkEvent event = new WorkEvent();
            event.setMexId(mex.getMessageExchangeId());
            event.setProcessId(this.getPID());
            event.setType(WorkEvent.Type.INVOKE_CHECK);
            PartnerLinkModel model = this._processModel.getPartnerLink(mex.getPartnerLinkModelId());
            long timeout = (long)((double)this.getTimeout(model) * 1.5);
            Date future = new Date(System.currentTimeMillis() + timeout);
            String jobId = this.scheduleWorkEvent(event, future);
            mex.setProperty("invokeCheckJobId", jobId);
        }
    }

    private void invokeP2P(ODEProcess target, QName serviceName, Operation operation, MessageExchangeDAO partnerRoleMex) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Invoking in a p2p interaction, partnerrole " + partnerRoleMex.getMessageExchangeId() + " target=" + target));
        }
        partnerRoleMex.setInvocationStyle(Boolean.parseBoolean(partnerRoleMex.getProperty("org.apache.ode.bpel.myRoleTransacted")) ? InvocationStyle.P2P_TRANSACTED : InvocationStyle.P2P);
        MessageExchangeDAO myRoleMex = target.createMessageExchange(new GUID().toString(), 'M');
        myRoleMex.setStatus(MessageExchange.Status.REQ);
        myRoleMex.setCallee(serviceName);
        myRoleMex.setOperation(partnerRoleMex.getOperation());
        myRoleMex.setPattern(partnerRoleMex.getPattern());
        myRoleMex.setTimeout(partnerRoleMex.getTimeout());
        myRoleMex.setRequest(partnerRoleMex.getRequest());
        myRoleMex.setInvocationStyle(partnerRoleMex.getInvocationStyle());
        myRoleMex.setPipedMessageExchangeId(partnerRoleMex.getMessageExchangeId());
        myRoleMex.setPipedPID(this.getPID());
        partnerRoleMex.setPipedPID(target.getPID());
        partnerRoleMex.setPipedMessageExchangeId(myRoleMex.getMessageExchangeId());
        this.setStatefulEPRs(partnerRoleMex, myRoleMex);
        target.invokeProcess(myRoleMex);
    }

    private OdeRuntime buildRuntime(int modelVersion) {
        String qualifiedName = "org.apache.ode.bpel.rtrep.v" + modelVersion + ".RuntimeImpl";
        try {
            OdeRuntime runtime = (OdeRuntime)Class.forName(qualifiedName).newInstance();
            runtime.setExtensionRegistry(this._contexts.extensionRegistry);
            return runtime;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate ODE runtime version " + modelVersion + ", either your process definition version is outdated or we have a bug.");
        }
    }

    void setStatefulEPRs(MessageExchangeDAO partnerRoleMex) {
        this.setStatefulEPRs(partnerRoleMex, null);
    }

    private void setStatefulEPRs(MessageExchangeDAO partnerRoleMex, MessageExchangeDAO myRoleMex) {
        String mySessionId = partnerRoleMex.getPartnerLink().getMySessionId();
        String partnerSessionId = partnerRoleMex.getPartnerLink().getPartnerSessionId();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Setting myRoleMex session ids for p2p interaction, mySession " + partnerSessionId + " - partnerSess " + mySessionId));
        }
        if (mySessionId != null) {
            partnerRoleMex.setProperty("org.apache.ode.bpel.myRoleSessionId", mySessionId);
            if (myRoleMex != null) {
                myRoleMex.setProperty("org.apache.ode.bpel.partnerRoleSessionId", mySessionId);
            }
        }
        if (partnerSessionId != null) {
            partnerRoleMex.setProperty("org.apache.ode.bpel.partnerRoleSessionId", partnerSessionId);
            if (myRoleMex != null) {
                myRoleMex.setProperty("org.apache.ode.bpel.myRoleSessionId", partnerSessionId);
            }
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INVOKE PARTNER (SEP): sessionId=" + mySessionId + " partnerSessionId=" + partnerSessionId));
        }
    }

    private void p2pWakeup(final MessageExchangeDAO prolemex) {
        try {
            this.doInstanceWork(prolemex.getInstance().getInstanceId(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ODEProcess.this.executeContinueInstancePartnerRoleResponseReceived(prolemex);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            throw new BpelEngineException((Throwable)ex);
        }
    }

    public boolean isCleanupCategoryEnabled(boolean instanceSucceeded, ProcessConf.CLEANUP_CATEGORY category) {
        return this._pconf.isCleanupCategoryEnabled(instanceSucceeded, category);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean instanceSucceeded) {
        return this._pconf.getCleanupCategories(instanceSucceeded);
    }

    public Node getProcessProperty(QName propertyName) {
        Map properties = this._pconf.getProcessProperties();
        if (properties != null) {
            return (Node)properties.get(propertyName);
        }
        return null;
    }

    public long getTimeout(PartnerLinkModel partnerLink) {
        long timeout;
        block3: {
            PartnerLinkPartnerRoleImpl linkPartnerRole = this._partnerRoles.get(partnerLink);
            timeout = 30000L;
            String timeout_property = (String)this._pconf.getEndpointProperties(linkPartnerRole._initialEPR).get("mex.timeout");
            if (timeout_property != null) {
                try {
                    timeout = Long.parseLong(timeout_property);
                }
                catch (NumberFormatException e) {
                    if (!__log.isWarnEnabled()) break block3;
                    __log.warn((Object)("Mal-formatted Property: [mex.timeout=" + timeout_property + "] Default value (" + timeout + ") will be used"));
                }
            }
        }
        return timeout;
    }

    class HydrationLatch
    extends NStateLatch {
        HydrationLatch() {
            super(new Runnable[2]);
            this._transitions[0] = new Runnable(){

                public void run() {
                    HydrationLatch.this.doDehydrate();
                }
            };
            this._transitions[1] = new Runnable(){

                public void run() {
                    HydrationLatch.this.doHydrate();
                }
            };
        }

        private void doDehydrate() {
            ODEProcess.this._processModel = null;
            ODEProcess.this._partnerRoles = null;
            ODEProcess.this._myRoles = null;
            ODEProcess.this._endpointToMyRoleMap = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHydrate() {
            ODEProcess.this.markused();
            try {
                InputStream inputStream = ODEProcess.this._pconf.getCBPInputStream();
                try {
                    ODEProcess.this._processModel = ODEProcess.this.deserializeCompiledProcess(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                String errmsg = "Error reloading compiled process " + ODEProcess.this._pconf.getProcessId() + "; the file appears to be corrupted.";
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg, (Throwable)e);
            }
            ODEProcess.this._runtime = ODEProcess.this.buildRuntime(ODEProcess.this._processModel.getModelVersion());
            ODEProcess.this._runtime.init(ODEProcess.this._pconf, ODEProcess.this._processModel);
            ODEProcess.this.setRoles(ODEProcess.this._processModel);
            ODEProcess.this.initExternalVariables();
            if (!ODEProcess.this._hydratedOnce) {
                for (PartnerLinkPartnerRoleImpl prole : ODEProcess.this._partnerRoles.values()) {
                    PartnerRoleChannel channel;
                    if (prole._initialPartner == null) continue;
                    prole._channel = channel = ODEProcess.this._contexts.bindingContext.createPartnerRoleChannel(ODEProcess.this._pid, prole._plinkDef.getPartnerRolePortType(), prole._initialPartner);
                    ODEProcess.this._partnerChannels.put(prole._initialPartner, prole._channel);
                    EndpointReference epr = channel.getInitialEndpointReference();
                    if (epr != null) {
                        prole._initialEPR = epr;
                        ODEProcess.this._partnerEprs.put(prole._initialPartner, epr);
                    }
                    __log.debug((Object)("Activated " + ODEProcess.this._pid + " partnerrole " + prole.getPartnerLinkName() + ": EPR is " + prole._initialEPR));
                }
                ODEProcess.this._hydratedOnce = true;
            }
            for (PartnerLinkMyRoleImpl myrole : ODEProcess.this._myRoles.values()) {
                myrole._initialEPR = (EndpointReference)ODEProcess.this._myEprs.get(myrole._endpoint);
            }
            for (PartnerLinkPartnerRoleImpl prole : ODEProcess.this._partnerRoles.values()) {
                prole._channel = (PartnerRoleChannel)ODEProcess.this._partnerChannels.get(prole._initialPartner);
                if (ODEProcess.this._partnerEprs.get(prole._initialPartner) == null) continue;
                prole._initialEPR = (EndpointReference)ODEProcess.this._partnerEprs.get(prole._initialPartner);
            }
            if (ODEProcess.this.isInMemory()) {
                ODEProcess.this.bounceProcessDAO(ODEProcess.this._inMemDao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
            } else if (ODEProcess.this._contexts.isTransacted()) {
                ODEProcess.this.bounceProcessDAO(ODEProcess.this._contexts.dao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
            } else {
                try {
                    ODEProcess.this._contexts.execTransaction(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ODEProcess.this.deleteProcessDAO(ODEProcess.this._contexts.dao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
                            return null;
                        }
                    });
                    ODEProcess.this._contexts.execTransaction(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ODEProcess.this.createProcessDAO(ODEProcess.this._contexts.dao.getConnection(), ODEProcess.this._pid, ODEProcess.this._pconf.getVersion(), ODEProcess.this._processModel);
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    String errmsg = "DbError";
                    __log.error((Object)errmsg, (Throwable)ex);
                    throw new BpelEngineException(errmsg, (Throwable)ex);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessCallable<T>
    implements Callable<T> {
        Callable<T> _work;

        ProcessCallable(Callable<T> work) {
            this._work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            ODEProcess.this._hydrationLatch.latch(1);
            try {
                T t = this._work.call();
                return t;
            }
            finally {
                ODEProcess.this._hydrationLatch.release(1);
            }
        }
    }

    class ProcessRunnable
    implements Runnable {
        Runnable _work;

        ProcessRunnable(Runnable work) {
            this._work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ODEProcess.this._hydrationLatch.latch(1);
            try {
                this._work.run();
            }
            finally {
                ODEProcess.this._hydrationLatch.release(1);
            }
        }
    }
}

