/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.InvalidMessageException;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationMatchEvent;
import org.apache.ode.bpel.evt.CorrelationNoMatchEvent;
import org.apache.ode.bpel.evt.NewProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.rapi.CorrelationSetModel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.PropertyExtractor;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

class PartnerLinkMyRoleImpl
extends PartnerLinkRoleImpl {
    private static final Log __log = LogFactory.getLog(ODEProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    public Endpoint _endpoint;

    PartnerLinkMyRoleImpl(ODEProcess process, PartnerLinkModel plink, Endpoint endpoint) {
        super(process, plink);
        this._endpoint = endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{PartnerLinkRole-");
        buf.append(this._plinkDef.getName());
        buf.append('.');
        buf.append(this._plinkDef.getMyRoleName());
        buf.append(" on ");
        buf.append(this._endpoint);
        buf.append('}');
        return buf.toString();
    }

    public MyRoleMessageExchange.CorrelationStatus invokeMyRole(MessageExchangeDAO mex) {
        CorrelationKey[] uniqueKeys;
        Object[] processKeys;
        Operation operation;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)(this + ":inputMsgRcvd"), (Object[])new Object[]{"messageExchange", mex}));
        }
        if ((operation = this.getMyRoleOperation(mex.getOperation())) == null) {
            __log.error((Object)__msgs.msgUnknownOperation(mex.getOperation(), this._plinkDef.getMyRolePortType().getQName()));
            MexDaoUtil.setFailed(mex, MessageExchange.FailureType.UNKNOWN_OPERATION, mex.getOperation());
            return null;
        }
        boolean isCreateInstance = this._plinkDef.isCreateInstanceOperation(operation);
        String correlatorId = ODEProcess.genCorrelatorId(this._plinkDef, operation.getName());
        CorrelatorDAO correlator = this._process.getProcessDAO().getCorrelator(correlatorId);
        MessageRouteDAO messageRoute = null;
        try {
            processKeys = this.computeCorrelationKeys(mex, operation);
            uniqueKeys = this.computeUniqueCorrelationKeys(mex, operation);
        }
        catch (InvalidMessageException ime) {
            __log.debug((Object)"Unable to evaluate correlation keys, invalid message format. ", (Throwable)ime);
            MexDaoUtil.setFailed(mex, MessageExchange.FailureType.FORMAT_ERROR, ime.getMessage());
            return null;
        }
        String mySessionId = mex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        String partnerSessionId = mex.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + correlatorId + ": MSG RCVD keys=" + CollectionUtils.makeCollection(HashSet.class, (Object[])processKeys) + " mySessionId=" + mySessionId + " partnerSessionId=" + partnerSessionId));
        }
        Object matchedKey = null;
        for (Object key : processKeys) {
            messageRoute = correlator.findRoute((CorrelationKey)key);
            if (messageRoute == null) continue;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("INPUTMSG: " + correlatorId + ": ckey " + key + " ROUTED TO (grp,index,iid) = (" + messageRoute.getGroupId() + "," + messageRoute.getIndex() + ", " + messageRoute.getTargetInstance().getInstanceId() + ")"));
            }
            matchedKey = key;
            break;
        }
        if (messageRoute == null && isCreateInstance) {
            this.invokeMyRoleCreateInstance(mex, operation, correlatorId, correlator, uniqueKeys);
        } else if (messageRoute != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("INPUTMSG: " + correlatorId + ": ROUTING to instance " + messageRoute.getTargetInstance().getInstanceId()));
            }
            ProcessInstanceDAO instanceDAO = messageRoute.getTargetInstance();
            ProcessDAO processDAO = instanceDAO.getProcess();
            this.enforceUniqueConstraint(processDAO, uniqueKeys);
            correlator.removeRoutes(messageRoute.getGroupId(), instanceDAO);
            CorrelationMatchEvent evt = new CorrelationMatchEvent(this._process.getProcessModel().getQName(), this._process.getProcessDAO().getProcessId(), instanceDAO.getInstanceId(), (CorrelationKey)matchedKey);
            evt.setPortType(mex.getPortType());
            evt.setOperation(operation.getName());
            evt.setMexId(mex.getMessageExchangeId());
            this._process._debugger.onEvent((BpelEvent)evt);
            this._process.saveEvent((ProcessInstanceEvent)evt, instanceDAO);
            mex.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.MATCHED.toString());
            mex.setInstance(messageRoute.getTargetInstance());
            mex.setChannel(messageRoute.getGroupId() + "&" + messageRoute.getIndex());
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("INPUTMSG: " + correlatorId + ": SAVING to DB (no match) "));
            }
            CorrelationNoMatchEvent evt = new CorrelationNoMatchEvent(mex.getPortType(), mex.getOperation(), mex.getMessageExchangeId(), (CorrelationKey[])processKeys);
            evt.setProcessId(this._process.getProcessDAO().getProcessId());
            evt.setProcessName(this._process.getProcessModel().getQName());
            this._process._debugger.onEvent((BpelEvent)evt);
            mex.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.QUEUED.toString());
            correlator.enqueueMessage(mex, (CorrelationKey[])processKeys);
        }
        return MyRoleMessageExchange.CorrelationStatus.valueOf((String)mex.getCorrelationStatus());
    }

    private void invokeMyRoleCreateInstance(MessageExchangeDAO mex, Operation operation, String correlatorId, CorrelatorDAO correlator, CorrelationKey[] uniqueKeys) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + correlatorId + ": routing failed, CREATING NEW INSTANCE"));
        }
        ProcessDAO processDAO = this._process.getProcessDAO();
        if (this._process._pconf.getState() == ProcessState.RETIRED) {
            throw new InvalidProcessException("Process is retired.", 1);
        }
        this.enforceUniqueConstraint(processDAO, uniqueKeys);
        ProcessInstanceDAO newInstance = processDAO.createInstance(correlator);
        NewProcessInstanceEvent evt = new NewProcessInstanceEvent(this._process.getProcessModel().getQName(), processDAO.getProcessId(), newInstance.getInstanceId());
        evt.setPortType(mex.getPortType());
        evt.setOperation(operation.getName());
        evt.setMexId(mex.getMessageExchangeId());
        this._process._debugger.onEvent((BpelEvent)evt);
        this._process.saveEvent((ProcessInstanceEvent)evt, newInstance);
        mex.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.CREATE_INSTANCE.toString());
        mex.setInstance(newInstance);
    }

    private void enforceUniqueConstraint(ProcessDAO processDAO, CorrelationKey[] uniqueKeys) {
        for (CorrelationKey uniqueKey : uniqueKeys) {
            Collection instances;
            if (!uniqueKey.isUnique() || (instances = processDAO.findInstance(uniqueKey, false)).size() == 0) continue;
            __log.debug((Object)("Not creating a new instance for process " + processDAO.getProcessId() + "; unique correlation constraint would be violated!"));
            throw new InvalidProcessException("Unique process constraint violated", 2);
        }
    }

    private Operation getMyRoleOperation(String operationName) {
        return this._plinkDef.getMyRoleOperation(operationName);
    }

    private CorrelationKey[] computeCorrelationKeys(MessageExchangeDAO mex, Operation operation) {
        Element msg = mex.getRequest().getData();
        Message msgDescription = operation.getInput().getMessage();
        ArrayList<CorrelationKey> keys = new ArrayList<CorrelationKey>();
        Set csets = this._plinkDef.getCorrelationSetsForOperation(operation);
        for (CorrelationSetModel cset : csets) {
            CorrelationKey key = this.computeCorrelationKey(cset, msgDescription.getQName(), msg);
            keys.add(key);
        }
        String mySessionId = mex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (mySessionId != null) {
            keys.add(new CorrelationKey(-1, new String[]{mySessionId}));
        }
        return keys.toArray(new CorrelationKey[keys.size()]);
    }

    private CorrelationKey[] computeUniqueCorrelationKeys(MessageExchangeDAO mex, Operation operation) {
        Element msg = mex.getRequest().getData();
        Message msgDescription = operation.getInput().getMessage();
        ArrayList<CorrelationKey> keys = new ArrayList<CorrelationKey>();
        Set csets = this._plinkDef.getUniqueCorrelationSetsForOperation(operation);
        for (CorrelationSetModel cset : csets) {
            CorrelationKey key = this.computeCorrelationKey(cset, msgDescription.getQName(), msg);
            keys.add(key);
        }
        String mySessionId = mex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (mySessionId != null) {
            keys.add(new CorrelationKey(-1, new String[]{mySessionId}));
        }
        return keys.toArray(new CorrelationKey[keys.size()]);
    }

    private CorrelationKey computeCorrelationKey(CorrelationSetModel cset, QName messageName, Element msg) {
        String[] values;
        if (cset.getExtractors().isEmpty()) {
            List aliases = cset.getAliases(messageName);
            values = new String[aliases.size()];
            int jIdx = 0;
            for (PropertyAliasModel alias : aliases) {
                String value;
                try {
                    value = this._process._runtime.extractProperty(msg, alias, msg.toString());
                }
                catch (FaultException fe) {
                    String emsg = __msgs.msgPropertyAliasDerefFailedOnMessage(alias.getDescription(), fe.getMessage());
                    __log.error((Object)emsg, (Throwable)fe);
                    throw new InvalidMessageException(emsg, (Throwable)fe);
                }
                values[jIdx++] = value;
            }
        } else {
            List extractors = cset.getExtractors();
            values = new String[extractors.size()];
            int jIdx = 0;
            for (PropertyExtractor extractor : extractors) {
                try {
                    values[jIdx++] = this._process._runtime.extractMatch(msg, extractor);
                }
                catch (FaultException e) {
                    String emsg = __msgs.msgPropertyAliasDerefFailedOnMessage(extractor.toString(), e.getMessage());
                    __log.error((Object)emsg, (Throwable)e);
                    throw new InvalidMessageException(emsg, (Throwable)e);
                }
            }
        }
        CorrelationKey key = new CorrelationKey(cset.getId(), values);
        key.setUnique(cset.isUnique());
        return key;
    }

    public boolean isOneWayOnly() {
        PortType portType = this._plinkDef.getMyRolePortType();
        if (portType == null) {
            return false;
        }
        for (Operation operation : portType.getOperations()) {
            if (operation.getOutput() == null) continue;
            return false;
        }
        return true;
    }
}

