/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Set;
import javax.transaction.Transaction;
import javax.wsdl.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ReliablePartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.TransactedPartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.UnreliablePartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartnerLinkPartnerRoleImpl
extends PartnerLinkRoleImpl {
    static final Log __log = LogFactory.getLog(PartnerLinkPartnerRoleImpl.class);
    Endpoint _initialPartner;
    public PartnerRoleChannel _channel;

    PartnerLinkPartnerRoleImpl(ODEProcess process, PartnerLinkModel plink, Endpoint initialPartner) {
        super(process, plink);
        this._initialPartner = initialPartner;
    }

    PartnerRoleMessageExchangeImpl createPartnerRoleMex(MessageExchangeDAO mexdao) {
        PartnerRoleMessageExchangeImpl mex;
        InvocationStyle istyle = mexdao.getInvocationStyle();
        Operation op = this._plinkDef.getPartnerRoleOperation(mexdao.getOperation());
        EndpointReference myroleEPR = this._plinkDef.hasMyRole() ? this._process.getInitialMyRoleEPR(this._plinkDef) : null;
        switch (istyle) {
            case UNRELIABLE: {
                mex = new UnreliablePartnerRoleMessageExchangeImpl(this._process, (long)mexdao.getInstance().getInstanceId(), mexdao.getMessageExchangeId(), this._plinkDef, op, null, myroleEPR, this._channel);
                break;
            }
            case TRANSACTED: {
                mex = new TransactedPartnerRoleMessageExchangeImpl(this._process, (long)mexdao.getInstance().getInstanceId(), mexdao.getMessageExchangeId(), this._plinkDef, op, null, myroleEPR, this._channel);
                break;
            }
            case RELIABLE: {
                mex = new ReliablePartnerRoleMessageExchangeImpl(this._process, (long)mexdao.getInstance().getInstanceId(), mexdao.getMessageExchangeId(), this._plinkDef, op, null, myroleEPR, this._channel);
                break;
            }
            default: {
                throw new BpelEngineException("Unexpected InvocationStyle: " + istyle);
            }
        }
        mex.load(mexdao);
        return mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeIL(MessageExchangeDAO mexDao) {
        Element partnerEprXml = mexDao.getEPR();
        EndpointReference partnerEpr = this._initialEPR;
        if (partnerEprXml != null) {
            if (this._contexts.eprContext != null) {
                partnerEpr = this._contexts.eprContext.resolveEndpointReference(partnerEprXml);
            } else {
                __log.debug((Object)"Partner EPR will not be resolved, no EPR context specified!");
            }
        }
        EndpointReference myRoleEpr = null;
        if (this._plinkDef.hasMyRole()) {
            myRoleEpr = this._process.getInitialMyRoleEPR(this._plinkDef);
        }
        this._process.setStatefulEPRs(mexDao);
        Operation operation = this._plinkDef.getPartnerRoleOperation(mexDao.getOperation());
        Set supportedStyles = this._contexts.mexContext.getSupportedInvocationStyle(this._channel, partnerEpr);
        boolean oneway = mexDao.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_ONLY;
        try {
            if (this._process.isInMemory()) {
                this.invokeInMem(mexDao, partnerEpr, myRoleEpr, operation, supportedStyles, oneway);
            } else {
                this.invokePersisted(mexDao, partnerEpr, myRoleEpr, operation, supportedStyles);
            }
        }
        finally {
            if (mexDao.getStatus() != MessageExchange.Status.ACK) {
                mexDao.setStatus(MessageExchange.Status.ASYNC);
            }
        }
    }

    private void invokePersisted(MessageExchangeDAO mexDao, EndpointReference partnerEpr, EndpointReference myRoleEpr, Operation operation, Set<InvocationStyle> supportedStyles) {
        boolean transactionalMex = Boolean.parseBoolean(mexDao.getProperty("org.apache.ode.bpel.myRoleTransacted"));
        if (supportedStyles.contains(InvocationStyle.TRANSACTED) && transactionalMex) {
            mexDao.setInvocationStyle(InvocationStyle.TRANSACTED);
            this.invokeTransacted(mexDao, partnerEpr, myRoleEpr, operation);
        } else if (supportedStyles.contains(InvocationStyle.RELIABLE)) {
            mexDao.setInvocationStyle(InvocationStyle.RELIABLE);
            this.invokeReliable(mexDao, partnerEpr, myRoleEpr, operation);
        } else if (supportedStyles.contains(InvocationStyle.UNRELIABLE)) {
            mexDao.setInvocationStyle(InvocationStyle.UNRELIABLE);
            this.invokeUnreliable(mexDao, partnerEpr, myRoleEpr, operation);
        } else {
            __log.error((Object)("Integration Layer did not agree to any known invocation style for EPR " + partnerEpr));
            mexDao.setFailureType(MessageExchange.FailureType.COMMUNICATION_ERROR);
            mexDao.setStatus(MessageExchange.Status.ACK);
            mexDao.setAckType(MessageExchange.AckType.FAILURE);
            mexDao.setFaultExplanation("NoMatchingStyle");
        }
    }

    private void invokeUnreliable(MessageExchangeDAO mexDao, EndpointReference partnerEpr, EndpointReference myRoleEpr, Operation operation) {
        UnreliablePartnerRoleMessageExchangeImpl blockingMex = new UnreliablePartnerRoleMessageExchangeImpl(this._process, (long)mexDao.getInstance().getInstanceId(), mexDao.getMessageExchangeId(), this._plinkDef, operation, partnerEpr, myRoleEpr, this._channel);
        blockingMex.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
        blockingMex.request();
        this._process.scheduleRunnable(new UnreliableInvoker(blockingMex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInMem(MessageExchangeDAO mexDao, EndpointReference partnerEpr, EndpointReference myRoleEpr, Operation operation, Set<InvocationStyle> supportedStyles, boolean oneway) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("invokeInMem: mexid=" + mexDao.getMessageExchangeId() + " operation=" + mexDao.getOperation() + " oneway=" + oneway));
        }
        if (supportedStyles.contains(InvocationStyle.TRANSACTED)) {
            this.invokeTransacted(mexDao, partnerEpr, myRoleEpr, operation);
        } else if (supportedStyles.contains(InvocationStyle.RELIABLE) && oneway) {
            this.invokeReliable(mexDao, partnerEpr, myRoleEpr, operation);
        } else if (supportedStyles.contains(InvocationStyle.UNRELIABLE)) {
            Transaction tx;
            UnreliablePartnerRoleMessageExchangeImpl unreliableMex = new UnreliablePartnerRoleMessageExchangeImpl(this._process, (long)mexDao.getInstance().getInstanceId(), mexDao.getMessageExchangeId(), this._plinkDef, operation, partnerEpr, myRoleEpr, this._channel);
            try {
                tx = this._contexts.txManager.suspend();
                __log.debug((Object)("TX " + tx + " suspended for in-memory invoke. "));
            }
            catch (Exception ex) {
                throw new BpelEngineException("TxManager Error: cannot suspend!", (Throwable)ex);
            }
            unreliableMex.request();
            unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
            try {
                try {
                    this._contexts.mexContext.invokePartnerUnreliable((PartnerRoleMessageExchange)unreliableMex);
                }
                catch (Throwable t) {
                    __log.error((Object)"Unexpected error invoking partner.", t);
                    MexDaoUtil.setFailed(mexDao, MessageExchange.FailureType.OTHER, t.toString());
                    unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    try {
                        this._contexts.txManager.resume(tx);
                        __log.debug((Object)("TX " + tx + " resumed for in-memory invoke. "));
                    }
                    catch (Exception e) {
                        throw new BpelEngineException("TxManager Error: cannot resume!", (Throwable)e);
                    }
                    return;
                }
                try {
                    unreliableMex.waitForAck(mexDao.getTimeout());
                }
                catch (InterruptedException ie) {
                    __log.warn((Object)"Interrupted waiting for MEX response.");
                }
            }
            finally {
                unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                try {
                    this._contexts.txManager.resume(tx);
                    __log.debug((Object)("TX " + tx + " resumed for in-memory invoke. "));
                }
                catch (Exception e) {
                    throw new BpelEngineException("TxManager Error: cannot resume!", (Throwable)e);
                }
            }
            if (unreliableMex.getStatus() != MessageExchange.Status.ACK) {
                MexDaoUtil.setFailed(mexDao, MessageExchange.FailureType.NO_RESPONSE, "No Response");
            } else {
                unreliableMex.save(mexDao);
            }
        } else {
            MexDaoUtil.setFailed(mexDao, MessageExchange.FailureType.OTHER, "Unsupported invocation style for in-mem process.");
        }
    }

    private void invokeReliable(MessageExchangeDAO mexDao, EndpointReference partnerEpr, EndpointReference myRoleEpr, Operation operation) {
        ReliablePartnerRoleMessageExchangeImpl reliableMex = new ReliablePartnerRoleMessageExchangeImpl(this._process, (long)mexDao.getInstance().getInstanceId(), mexDao.getMessageExchangeId(), this._plinkDef, operation, partnerEpr, myRoleEpr, this._channel);
        reliableMex.request();
        reliableMex.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
        Throwable err = null;
        try {
            this._contexts.mexContext.invokePartnerReliable((PartnerRoleMessageExchange)reliableMex);
        }
        catch (Throwable t) {
            err = t;
        }
        reliableMex.setState(PartnerRoleMessageExchangeImpl.State.HOLD);
        if (err != null) {
            MexDaoUtil.setFailed(mexDao, MessageExchange.FailureType.COMMUNICATION_ERROR, err.toString());
            reliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
        } else if (reliableMex.getStatus() == MessageExchange.Status.ACK) {
            reliableMex.save(mexDao);
            reliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
        } else {
            reliableMex.setState(PartnerRoleMessageExchangeImpl.State.ASYNC);
        }
    }

    private void invokeTransacted(MessageExchangeDAO mexDao, EndpointReference partnerEpr, EndpointReference myRoleEpr, Operation operation) {
        TransactedPartnerRoleMessageExchangeImpl transactedMex = new TransactedPartnerRoleMessageExchangeImpl(this._process, (long)mexDao.getInstance().getInstanceId(), mexDao.getMessageExchangeId(), this._plinkDef, operation, partnerEpr, myRoleEpr, this._channel);
        transactedMex.request();
        transactedMex.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
        try {
            this._contexts.mexContext.invokePartnerTransacted((PartnerRoleMessageExchange)transactedMex);
        }
        catch (Throwable t) {
            __log.error((Object)"Transacted partner invoke threw an exception; rolling back.");
            try {
                this._contexts.txManager.setRollbackOnly();
            }
            catch (Exception ex) {
                __log.fatal((Object)"TransactionManager error, could not setRollbackOnly()", (Throwable)ex);
            }
            throw new BpelEngineException("Rollback required.", t);
        }
        finally {
            transactedMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
        }
        if (transactedMex.getStatus() != MessageExchange.Status.ACK) {
            MexDaoUtil.setFailed(mexDao, MessageExchange.FailureType.NO_RESPONSE, "Integration Layer did not provide required ACK.");
        } else {
            transactedMex.save(mexDao);
        }
    }

    class UnreliableInvoker
    implements Runnable {
        UnreliablePartnerRoleMessageExchangeImpl _unreliableMex;
        BpelInstanceWorker _iworker;
        BpelRuntimeContextImpl _lastBRC;

        public UnreliableInvoker(UnreliablePartnerRoleMessageExchangeImpl blockingMex) {
            this._unreliableMex = blockingMex;
        }

        public void run() {
            assert (!PartnerLinkPartnerRoleImpl.this._contexts.isTransacted());
            Throwable err = null;
            this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
            try {
                PartnerLinkPartnerRoleImpl.this._contexts.mexContext.invokePartnerUnreliable((PartnerRoleMessageExchange)this._unreliableMex);
                this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.HOLD);
            }
            catch (Throwable t) {
                this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                err = t;
            }
            final Throwable ferr = err;
            if (this._unreliableMex._operation.getOutput() == null) {
                this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                return;
            }
            if (ferr != null) {
                PartnerLinkPartnerRoleImpl.this._process.enqueueInstanceTransaction(this._unreliableMex.getIID(), new Runnable(){

                    public void run() {
                        MessageExchangeDAO mexdao = PartnerLinkPartnerRoleImpl.this._process.loadMexDao(UnreliableInvoker.this._unreliableMex.getMessageExchangeId());
                        MexDaoUtil.setFailed(mexdao, MessageExchange.FailureType.OTHER, ferr.toString());
                        UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    }
                });
                return;
            }
            PartnerLinkPartnerRoleImpl.this._process.enqueueInstanceTransaction(this._unreliableMex.getIID(), new Runnable(){

                public void run() {
                    MessageExchangeDAO mexdao = PartnerLinkPartnerRoleImpl.this._process.loadMexDao(UnreliableInvoker.this._unreliableMex.getMessageExchangeId());
                    if (UnreliableInvoker.this._unreliableMex.getStatus() == MessageExchange.Status.ACK) {
                        UnreliableInvoker.this._unreliableMex.save(mexdao);
                        UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    } else if (UnreliableInvoker.this._unreliableMex.getStatus() == MessageExchange.Status.REQ && !UnreliableInvoker.this._unreliableMex._asyncReply) {
                        MexDaoUtil.setFailed(mexdao, MessageExchange.FailureType.NO_RESPONSE, "No Response");
                        UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    } else {
                        if (UnreliableInvoker.this._unreliableMex._asyncReply) {
                            UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.ASYNC);
                            return;
                        }
                        __log.fatal((Object)"InternalError: Unexpected message exchange state!");
                        MexDaoUtil.setFailed(mexdao, MessageExchange.FailureType.OTHER, "Unexpected message exchange state");
                    }
                    PartnerLinkPartnerRoleImpl.this._process.executeContinueInstancePartnerRoleResponseReceived(mexdao);
                }
            });
        }
    }
}

