/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;

abstract class PartnerRoleMessageExchangeImpl
extends MessageExchangeImpl
implements PartnerRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(PartnerRoleMessageExchangeImpl.class);
    protected final PartnerRoleChannel _partnerRoleChannel;
    protected EndpointReference _myRoleEPR;
    protected String _responseChannel;
    protected volatile String _foreignKey;
    protected Lock _accessLock = new ReentrantLock();
    protected Condition _stateChanged = this._accessLock.newCondition();
    protected Condition _acked = this._accessLock.newCondition();
    private QName _caller;
    protected State _state = State.INVOKE_XXX;

    PartnerRoleMessageExchangeImpl(ODEProcess process, Long iid, String mexId, PartnerLinkModel oplink, Operation operation, EndpointReference epr, EndpointReference myRoleEPR, PartnerRoleChannel channel) {
        super(process, iid, mexId, oplink, oplink.getPartnerRolePortType(), operation);
        this._myRoleEPR = myRoleEPR;
        this._partnerRoleChannel = channel;
    }

    void load(MessageExchangeDAO dao) {
        super.load(dao);
        this._caller = dao.getProcess().getProcessId();
    }

    void save(MessageExchangeDAO dao) {
        super.save(dao);
        dao.setPartnersKey(this._foreignKey);
        if (this._changes.contains((Object)MessageExchangeImpl.Change.ACK)) {
            this._changes.remove((Object)MessageExchangeImpl.Change.ACK);
            if (this._response != null) {
                MessageDAO responseDao = dao.createMessage(this._response.getType());
                responseDao.setData(this._response.getMessage());
                responseDao.setHeader(this._response.getHeader());
                dao.setResponse(responseDao);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ack(MessageExchange.AckType acktype) {
        this._accessLock.lock();
        try {
            super.ack(acktype);
            this._changes.add(MessageExchangeImpl.Change.ACK);
            this._acked.signalAll();
        }
        finally {
            this._accessLock.unlock();
        }
    }

    public void replyAsync(String foreignKey) {
        throw new IllegalStateException("replyAsync() is not supported for invocation style " + this.getInvocationStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyOneWayOk() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("replyOneWayOk mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this.ack(MessageExchange.AckType.ONEWAY);
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyWithFault(QName faultType, Message outputFaultMessage) throws BpelEngineException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("replyWithFault mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this._fault = faultType;
            this._failureType = null;
            this._response = (MessageImpl)outputFaultMessage;
            this.ack(MessageExchange.AckType.FAULT);
            if (this._state == State.ASYNC) {
                this.asyncACK();
            }
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(Message response) throws BpelEngineException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("reply mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this._response = (MessageImpl)response;
            this._fault = null;
            this._failureType = null;
            this.ack(MessageExchange.AckType.RESPONSE);
            if (this._state == State.ASYNC) {
                this.asyncACK();
            }
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyWithFailure(MessageExchange.FailureType type, String description, Element details) throws BpelEngineException {
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this._failureType = type;
            this._explanation = description;
            this._fault = null;
            this._response = null;
            this.ack(MessageExchange.AckType.FAILURE);
            if (this._state == State.ASYNC) {
                this.asyncACK();
            }
        }
        finally {
            this._accessLock.unlock();
        }
    }

    public QName getCaller() {
        return this._caller;
    }

    public PartnerRoleChannel getPartnerRoleChannel() {
        return this._partnerRoleChannel;
    }

    public EndpointReference getMyRoleEndpointReference() {
        return this._myRoleEPR;
    }

    public String toString() {
        try {
            return "{PartnerRoleMex#" + this._mexId + " [PID " + this.getCaller() + "] calling " + this._epr + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable t) {
            return "{PartnerRoleMex#????}";
        }
    }

    protected abstract void asyncACK();

    protected void checkReplyContextOk() {
        while (this._state == State.HOLD) {
            try {
                this._stateChanged.await();
            }
            catch (InterruptedException e) {
                throw new BpelEngineException("Thread Interrupted.", (Throwable)e);
            }
        }
        if (this._state == State.DEAD) {
            throw new IllegalStateException("Object used in inappropriate context. ");
        }
        if (this.getStatus() != MessageExchange.Status.REQ && this.getStatus() != MessageExchange.Status.ASYNC) {
            throw new IllegalStateException("Invalid message exchange state, expect REQ but got " + this.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State newstate) {
        this._accessLock.lock();
        try {
            this._state = newstate;
            this._stateChanged.signalAll();
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAck(long timeout) throws InterruptedException {
        this._accessLock.lock();
        try {
            if (this.getStatus() != MessageExchange.Status.ACK) {
                boolean bl = this._acked.await(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INVOKE_XXX,
        HOLD,
        ASYNC,
        DEAD;

    }
}

