/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;

class ReliableMyRoleMessageExchangeImpl
extends MyRoleMessageExchangeImpl
implements MyRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(ReliableMyRoleMessageExchangeImpl.class);

    public ReliableMyRoleMessageExchangeImpl(ODEProcess process, String mexId, PartnerLinkModel oplink, Operation operation, QName callee) {
        super(process, mexId, oplink, operation, callee);
    }

    public void invokeReliable() {
        this.assertTransaction();
        if (this.getStatus() == MessageExchange.Status.REQ) {
            return;
        }
        if (this.getStatus() != MessageExchange.Status.NEW) {
            throw new IllegalStateException("Invalid state: " + this.getStatus());
        }
        this.doInvoke();
    }

    public InvocationStyle getInvocationStyle() {
        return InvocationStyle.RELIABLE;
    }

    protected void onAsyncAck(MessageExchangeDAO mexdao) {
        switch (mexdao.getAckType()) {
            case RESPONSE: {
                break;
            }
            case FAULT: {
                break;
            }
        }
    }
}

