/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.wsdl.Operation;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;

public class ReliablePartnerRoleMessageExchangeImpl
extends PartnerRoleMessageExchangeImpl {
    public ReliablePartnerRoleMessageExchangeImpl(ODEProcess process, long iid, String mexId, PartnerLinkModel oplink, Operation op, EndpointReference epr, EndpointReference myRoleEPR, PartnerRoleChannel partnerRoleChannel) {
        super(process, iid, mexId, oplink, op, epr, myRoleEPR, partnerRoleChannel);
    }

    protected void checkReplyContextOk() {
        super.checkReplyContextOk();
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("Cannot replyXXX from non-transaction context!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyAsync(String foreignKey) {
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            if (this._state != PartnerRoleMessageExchangeImpl.State.INVOKE_XXX) {
                throw new IllegalStateException("Invalid context for replyAsync(); can only be called during MessageExchangeContext call. ");
            }
            this._foreignKey = foreignKey;
        }
        finally {
            this._accessLock.unlock();
        }
    }

    protected void asyncACK() {
        assert (this._contexts.isTransacted()) : "checkReplyContext() should have prevented us from getting here.";
        assert (!this._process.isInMemory()) : "resumeInstance() for reliable in-mem processes makes no sense.";
        MessageExchangeDAO mexdao = this.getDAO();
        WorkEvent we = this.generatePartnerResponseWorkEvent(mexdao);
        this.save(mexdao);
        this._contexts.scheduler.schedulePersistedJob(we.getDetail(), null);
    }

    public InvocationStyle getInvocationStyle() {
        return InvocationStyle.RELIABLE;
    }

    private WorkEvent generatePartnerResponseWorkEvent(MessageExchangeDAO mexdao) {
        WorkEvent we = new WorkEvent();
        we.setProcessId(this._process.getPID());
        we.setChannel(mexdao.getChannel());
        we.setIID(this._iid);
        we.setMexId(this._mexId);
        we.setType(WorkEvent.Type.PARTNER_RESPONSE);
        return we;
    }
}

