/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MemBackedMessageImpl;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.ReliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreliableMyRoleMessageExchangeImpl
extends MyRoleMessageExchangeImpl {
    private static final Log __log = LogFactory.getLog(ReliableMyRoleMessageExchangeImpl.class);
    boolean _done = false;
    ResponseFuture _future;

    public UnreliableMyRoleMessageExchangeImpl(ODEProcess process, String mexId, PartnerLinkModel oplink, Operation operation, QName callee) {
        super(process, mexId, oplink, operation, callee);
    }

    @Override
    public Future<MessageExchange.Status> invokeAsync() {
        if (this._future != null) {
            return this._future;
        }
        if (this._request == null) {
            throw new IllegalStateException("Must call setRequest(...)!");
        }
        this._future = new ResponseFuture();
        this._process.enqueueTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MessageExchangeDAO dao = UnreliableMyRoleMessageExchangeImpl.this.doInvoke();
                if (dao.getStatus() == MessageExchange.Status.ACK) {
                    UnreliableMyRoleMessageExchangeImpl.this.onAsyncAck(dao);
                }
                return null;
            }
        });
        return this._future;
    }

    @Override
    public InvocationStyle getInvocationStyle() {
        return InvocationStyle.UNRELIABLE;
    }

    @Override
    public MessageExchange.Status invokeBlocking() throws BpelEngineException, TimeoutException {
        if (this._done) {
            return this.getStatus();
        }
        Future<MessageExchange.Status> future = this._future != null ? this._future : this.invokeAsync();
        try {
            future.get(Math.max(this._timeout, 1L), TimeUnit.MILLISECONDS);
            this._done = true;
            return this.getStatus();
        }
        catch (InterruptedException e) {
            throw new BpelEngineException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new BpelEngineException(e.getCause());
        }
    }

    @Override
    protected void onAsyncAck(MessageExchangeDAO mexdao) {
        MemBackedMessageImpl response;
        final QName fault = mexdao.getFault();
        final MessageExchange.FailureType failureType = mexdao.getFailureType();
        final MessageExchange.AckType ackType = mexdao.getAckType();
        final String explanation = mexdao.getFaultExplanation();
        switch (mexdao.getAckType()) {
            case RESPONSE: 
            case FAULT: {
                response = new MemBackedMessageImpl(mexdao.getResponse().getHeader(), mexdao.getResponse().getData(), mexdao.getResponse().getType(), false);
                break;
            }
            default: {
                response = null;
            }
        }
        Element eprdao = mexdao.getEPR();
        this._epr = eprdao == null ? null : this._contexts.eprContext.resolveEndpointReference(mexdao.getEPR());
        this._process.scheduleRunnable(new Runnable(){

            public void run() {
                UnreliableMyRoleMessageExchangeImpl.this._response = response;
                UnreliableMyRoleMessageExchangeImpl.this._fault = fault;
                UnreliableMyRoleMessageExchangeImpl.this._failureType = failureType;
                UnreliableMyRoleMessageExchangeImpl.this._explanation = explanation;
                UnreliableMyRoleMessageExchangeImpl.this.ack(ackType);
                if (UnreliableMyRoleMessageExchangeImpl.this._future != null) {
                    UnreliableMyRoleMessageExchangeImpl.this._future.done(MessageExchange.Status.ACK);
                } else {
                    __log.warn((Object)"null future");
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResponseFuture
    implements Future<MessageExchange.Status> {
        private MessageExchange.Status _status;

        private ResponseFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public MessageExchange.Status get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MessageExchange.Status get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ResponseFuture responseFuture = this;
            synchronized (responseFuture) {
                if (this._status != null) {
                    return this._status;
                }
                this.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
                if (this._status == null) {
                    throw new TimeoutException();
                }
                return this._status;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this._status != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(MessageExchange.Status status) {
            ResponseFuture responseFuture = this;
            synchronized (responseFuture) {
                this._status = status;
                this.notifyAll();
            }
        }
    }
}

