/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.wsdl.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;

public class UnreliablePartnerRoleMessageExchangeImpl
extends PartnerRoleMessageExchangeImpl {
    private static final Log __log = LogFactory.getLog(UnreliablePartnerRoleMessageExchangeImpl.class);
    boolean _asyncReply;

    UnreliablePartnerRoleMessageExchangeImpl(ODEProcess process, long iid, String mexId, PartnerLinkModel oplink, Operation operation, EndpointReference epr, EndpointReference myRoleEPR, PartnerRoleChannel channel) {
        super(process, iid, mexId, oplink, operation, epr, myRoleEPR, channel);
    }

    public InvocationStyle getInvocationStyle() {
        return InvocationStyle.UNRELIABLE;
    }

    protected void asyncACK() {
        assert (!this._contexts.isTransacted()) : "checkReplyContext() should have prevented us from getting here.";
        assert (!this._process.isInMemory()) : "resumeInstance() for in-mem processes makes no sense.";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("asyncResponseReceived: for IID " + this.getIID()));
        }
        this._process.enqueueInstanceTransaction(this.getIID(), new Runnable(){

            public void run() {
                MessageExchangeDAO dao = UnreliablePartnerRoleMessageExchangeImpl.this.getDAO();
                UnreliablePartnerRoleMessageExchangeImpl.this.save(dao);
                UnreliablePartnerRoleMessageExchangeImpl.this._process.executeContinueInstancePartnerRoleResponseReceived(dao);
            }
        });
    }

    protected void checkReplyContextOk() {
        super.checkReplyContextOk();
        if (this._contexts.isTransacted()) {
            throw new BpelEngineException("Cannot reply to UNRELIABLE style invocation from a transactional context!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyAsync(String foreignKey) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("replyAsync mex=" + this._mexId));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            if (this._state != PartnerRoleMessageExchangeImpl.State.INVOKE_XXX) {
                throw new IllegalStateException("Invalid context for replyAsync(); can only be called during MessageExchangeContext call. ");
            }
            this._asyncReply = true;
            this._foreignKey = foreignKey;
        }
        finally {
            this._accessLock.unlock();
        }
    }
}

