/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.extvar;

import java.util.HashMap;
import java.util.Map;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalVariableKeyMapSerializer {
    public static Element toXML(Map<String, String> map) {
        Document doc = DOMUtils.newDocument();
        Element el = doc.createElementNS(null, "external-variable-ref");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element nvel = doc.createElementNS(null, "nvpair");
            nvel.setAttribute("key", entry.getKey());
            if (entry.getValue() != null) {
                nvel.setAttribute("value", entry.getValue());
            }
            el.appendChild(nvel);
        }
        return el;
    }

    public static Map<String, String> toMap(Element el) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (el == null) {
            return ret;
        }
        NodeList nvs = el.getChildNodes();
        for (int i = 0; i < nvs.getLength(); ++i) {
            Node n = nvs.item(i);
            if (n.getNodeType() != 1 || !n.getLocalName().equals("nvpair")) continue;
            String key = ((Element)n).getAttribute("key");
            String val = ((Element)n).getAttribute("value");
            ret.put(key, val);
        }
        return ret;
    }
}

