/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.extvar;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.rapi.Variable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalVariableManager {
    private static final Log __log = LogFactory.getLog(ExternalVariableManager.class);
    private Map<QName, ExternalVariableModule> _engines;
    private final Map<String, EVar> _externalVariables = new HashMap<String, EVar>();
    private final ExternalVariableConf _extVarConf;
    private QName _pid;

    public ExternalVariableManager(QName pid, ExternalVariableConf evconf, Map<QName, ExternalVariableModule> engines) throws BpelEngineException {
        this._pid = pid;
        this._extVarConf = evconf;
        this._engines = engines;
        boolean fatal = false;
        for (ExternalVariableConf.Variable var : this._extVarConf.getVariables()) {
            EVar evar = new EVar(var.extVariableId, this._engines.get(var.engineQName), var.configuration);
            if (evar._engine == null) {
                __log.error((Object)("External variable engine \"" + var.engineQName + "\" referenced by external variable \"" + var.extVariableId + "\" not registered."));
                fatal = true;
                continue;
            }
            try {
                evar._engine.configure(this._pid, evar._extVarId, evar._config);
            }
            catch (ExternalVariableModuleException eve) {
                __log.error((Object)"External variable subsystem configuration error.", (Throwable)eve);
                throw new BpelEngineException("External variable subsystem configuration error.", (Throwable)eve);
            }
            if (this._externalVariables.containsKey(var.extVariableId)) {
                __log.warn((Object)("Duplicate external variable configuration for \"" + var.extVariableId + "\" will be ignored!"));
            }
            this._externalVariables.put(var.extVariableId, evar);
        }
        if (fatal) {
            String errmsg = "Error initializing external variables. See log for details.";
            __log.error((Object)errmsg);
            throw new BpelEngineException(errmsg);
        }
    }

    public ExternalVariableModule.Value read(Variable variable, Node reference, Long iid) throws ExternalVariableModuleException {
        EVar evar = this._externalVariables.get(variable.getExternalId());
        if (evar == null) {
            throw new BpelEngineException("InternalError: reference to unknown external variable " + variable.getExternalId());
        }
        ExternalVariableModule.Locator locator = new ExternalVariableModule.Locator(variable.getExternalId(), this._pid, iid, reference);
        ExternalVariableModule.Value newval = evar._engine.readValue(variable.getElementType(), locator);
        if (newval == null) {
            return null;
        }
        return newval;
    }

    public ExternalVariableModule.Value write(Variable variable, Node reference, Node val, Long iid) throws ExternalVariableModuleException {
        EVar evar = this._externalVariables.get(variable.getExternalId());
        if (evar == null) {
            throw new BpelEngineException("InternalError: reference to unknown external variable " + variable.getExternalId());
        }
        ExternalVariableModule.Locator locator = new ExternalVariableModule.Locator(variable.getExternalId(), this._pid, iid, reference);
        ExternalVariableModule.Value newval = new ExternalVariableModule.Value(locator, val, null);
        newval = evar._engine.writeValue(variable.getElementType(), newval);
        return newval;
    }

    static final class EVar {
        final ExternalVariableModule _engine;
        final Element _config;
        final String _extVarId;

        EVar(String id, ExternalVariableModule engine, Element config) {
            this._extVarId = id;
            this._engine = engine;
            this._config = config;
        }
    }
}

