/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.intercept;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.intercept.FailMessageExchangeException;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.intercept.NoOpInterceptor;
import org.w3c.dom.Text;

public class ThrottlingInterceptor
extends NoOpInterceptor {
    private static final QName PROP_MAX_INSTANCES = new QName("urn:org.apache.ode.bpel.intercept", "maxInstances");

    public void onNewInstanceInvoked(MessageExchangeInterceptor.InterceptorEvent ic) throws FailMessageExchangeException {
        int maxInstances;
        try {
            maxInstances = Integer.valueOf(this.getSimpleProperty(PROP_MAX_INSTANCES, ic));
        }
        catch (Exception ex) {
            return;
        }
        if (ic.getProcessDAO().getNumInstances() >= maxInstances) {
            throw new FailMessageExchangeException("Too many instances.");
        }
    }

    private String getSimpleProperty(QName propertyName, MessageExchangeInterceptor.InterceptorEvent ic) {
        Map props = ic.getProcessConf().getProcessProperties();
        for (Map.Entry prop : props.entrySet()) {
            if (!((QName)prop.getKey()).equals(propertyName)) continue;
            return ((Text)prop.getValue()).getWholeText();
        }
        return null;
    }
}

