/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.memdao.BpelDAOConnectionImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.MessageRouteDaoImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.utils.CollectionUtils;

class CorrelatorDaoImpl
extends DaoBaseImpl
implements CorrelatorDAO {
    private static final Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private String _correlatorId;
    private List<MsgQueueEntry> _messages = new ArrayList<MsgQueueEntry>();
    private List<MessageRouteDaoImpl> _routes = new ArrayList<MessageRouteDaoImpl>();
    private BpelDAOConnectionImpl _conn;

    CorrelatorDaoImpl(String correlatorId, BpelDAOConnectionImpl conn) {
        this._correlatorId = correlatorId;
        this._conn = conn;
    }

    public MessageExchangeDAO dequeueMessage(CorrelationKey key) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("dequeueEarliest: MATCHING correlationKey=" + key));
        }
        Iterator<MsgQueueEntry> i = this._messages.iterator();
        while (i.hasNext()) {
            MsgQueueEntry mqe = i.next();
            Set keyset = (Set)CollectionUtils.makeCollection(HashSet.class, (Object[])mqe.keys);
            if (key != null && !keyset.contains(key)) continue;
            i.remove();
            return mqe.message;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"dequeueEarliest: MATCH NOT FOUND!");
        }
        return null;
    }

    public MessageRouteDAO findRoute(CorrelationKey key) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("findRoute: key=" + key));
        }
        for (MessageRouteDaoImpl we : this._routes) {
            if ((we._ckey != null || key != null) && (we._ckey == null || key == null || !we._ckey.equals((Object)key))) continue;
            return we;
        }
        return null;
    }

    public String getCorrelatorId() {
        return this._correlatorId;
    }

    public void removeRoutes(String routeGroupId, ProcessInstanceDAO target) {
        ((ProcessInstanceDaoImpl)target).removeRoutes(routeGroupId);
    }

    public void enqueueMessage(MessageExchangeDAO mex, CorrelationKey[] keys) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("enqueueProcessInvocation: data=" + mex + " keys=" + CollectionUtils.makeCollection(ArrayList.class, (Object[])keys)));
        }
        MsgQueueEntry mqe = new MsgQueueEntry(mex, keys);
        this._messages.add(mqe);
    }

    public void addRoute(String routeId, ProcessInstanceDAO target, int idx, CorrelationKey key) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addRoute: target=" + target + " correlationKey=" + key));
        }
        final MessageRouteDaoImpl mr = new MessageRouteDaoImpl((ProcessInstanceDaoImpl)target, routeId, key, idx);
        this._conn.defer(new Runnable(){

            public void run() {
                CorrelatorDaoImpl.this._routes.add(mr);
            }
        });
    }

    public boolean checkRoute(CorrelationKey ckey) {
        return true;
    }

    void _removeRoutes(String routeGroupId, ProcessInstanceDaoImpl target) {
        Iterator<MessageRouteDaoImpl> i = this._routes.iterator();
        while (i.hasNext()) {
            MessageRouteDaoImpl we = i.next();
            if (!we._groupId.equals(routeGroupId) && routeGroupId != null || we._instance != target) continue;
            i.remove();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{CorrelatorDaoImpl corrId=");
        buf.append(this._correlatorId);
        buf.append(" waiters=");
        buf.append(this._routes);
        buf.append(" messages=");
        buf.append(this._messages);
        buf.append('}');
        return buf.toString();
    }

    private class MsgQueueEntry {
        public final MessageExchangeDAO message;
        public final CorrelationKey[] keys;

        private MsgQueueEntry(MessageExchangeDAO mex, CorrelationKey[] keys) {
            this.message = mex;
            this.keys = keys;
        }
    }
}

