/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.memdao.CorrelatorDaoImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.FaultDaoImpl;
import org.apache.ode.bpel.memdao.IdGen;
import org.apache.ode.bpel.memdao.ProcessDaoImpl;
import org.apache.ode.bpel.memdao.ScopeDaoImpl;
import org.apache.ode.utils.QNameUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceDaoImpl
extends DaoBaseImpl
implements ProcessInstanceDAO {
    private static final Collection<ScopeDAO> EMPTY_SCOPE_DAOS = Collections.emptyList();
    private short _previousState;
    private short _state = 0;
    private Long _instanceId;
    private ProcessDaoImpl _processDao;
    private Object _soup;
    private Map<Long, ScopeDAO> _scopes = new HashMap<Long, ScopeDAO>();
    private Map<String, List<ScopeDAO>> _scopesByName = new HashMap<String, List<ScopeDAO>>();
    private Map<String, byte[]> _messageExchanges = new HashMap<String, byte[]>();
    private ScopeDAO _rootScope;
    private FaultDAO _fault;
    private CorrelatorDAO _instantiatingCorrelator;
    private BpelDAOConnection _conn;
    private int _failureCount;
    private Date _failureDateTime;
    private Map<String, ActivityRecoveryDAO> _activityRecoveries = new HashMap<String, ActivityRecoveryDAO>();
    private List<ProcessInstanceEvent> _events = new ArrayList<ProcessInstanceEvent>();
    private Date _lastActive;
    private int _seq;
    private byte[] _execState;
    private int _execStateCount;

    ProcessInstanceDaoImpl(BpelDAOConnection conn, ProcessDaoImpl processDao, CorrelatorDAO correlator) {
        this._processDao = processDao;
        this._instantiatingCorrelator = correlator;
        this._soup = null;
        this._instanceId = IdGen.newProcessId();
        this._conn = conn;
    }

    public XmlDataDAO[] getVariables(String variableName, int scopeModelId) {
        ArrayList<XmlDataDAO> res = new ArrayList<XmlDataDAO>();
        for (ScopeDAO scope : this._scopes.values()) {
            XmlDataDAO xmld;
            if (scope.getModelId() != scopeModelId || (xmld = scope.getVariable(variableName)) == null) continue;
            res.add(xmld);
        }
        return res.toArray(new XmlDataDAO[res.size()]);
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        HashSet<CorrelationSetDAO> res = new HashSet<CorrelationSetDAO>();
        for (ScopeDAO scopeDAO : this._scopes.values()) {
            res.addAll(scopeDAO.getCorrelationSets());
        }
        return res;
    }

    public CorrelationSetDAO getCorrelationSet(String name) {
        for (ScopeDAO scopeDAO : this._scopes.values()) {
            if (scopeDAO.getCorrelationSet(name) == null) continue;
            return scopeDAO.getCorrelationSet(name);
        }
        return null;
    }

    public void setFault(QName name, String explanation, int lineNo, int activityId, Element faultData) {
        this._fault = new FaultDaoImpl(QNameUtils.fromQName((QName)name), explanation, faultData, lineNo, activityId);
    }

    public void setFault(FaultDAO fault) {
        this._fault = fault;
    }

    public FaultDAO getFault() {
        return this._fault;
    }

    public byte[] getExecutionState() {
        return this._execState;
    }

    public void setExecutionState(byte[] bytes) {
        this._execState = bytes;
    }

    public Object getSoup() {
        return this._soup;
    }

    public void setSoup(Object soup) {
        this._soup = soup;
    }

    public byte[] getMessageExchange(String identifier) {
        byte[] mex = this._messageExchanges.get(identifier);
        assert (mex != null);
        return mex;
    }

    public ProcessDAO getProcess() {
        return this._processDao;
    }

    public ScopeDAO getRootScope() {
        return this._rootScope;
    }

    public void setState(short state) {
        this._previousState = this._state;
        this._state = state;
        if (state == 60) {
            for (CorrelatorDAO correlatorDAO : this._processDao.getCorrelators()) {
                correlatorDAO.removeRoutes(null, (ProcessInstanceDAO)this);
            }
        }
    }

    public short getState() {
        return this._state;
    }

    public void addMessageExchange(String identifier, byte[] data) {
        assert (!this._messageExchanges.containsKey(identifier));
        this._messageExchanges.put(identifier, data);
    }

    public ScopeDAO createScope(ScopeDAO parentScope, String scopeType, int scopeModelId) {
        ScopeDaoImpl newScope = new ScopeDaoImpl(this, parentScope, scopeType, scopeModelId);
        this._scopes.put(newScope.getScopeInstanceId(), newScope);
        List<ScopeDAO> namedScopes = this._scopesByName.get(scopeType);
        if (namedScopes == null) {
            namedScopes = new LinkedList<ScopeDAO>();
            this._scopesByName.put(scopeType, namedScopes);
        }
        namedScopes.add(newScope);
        if (parentScope == null) {
            assert (this._rootScope == null);
            this._rootScope = newScope;
        }
        return newScope;
    }

    public Long getInstanceId() {
        return this._instanceId;
    }

    public ScopeDAO getScope(Long scopeInstanceId) {
        return this._scopes.get(scopeInstanceId);
    }

    public List<ProcessInstanceEvent> getEvents(int idx, int count) {
        int sidx = Math.max(idx, 0);
        sidx = Math.min(sidx, this._events.size() - 1);
        int eidx = Math.min(sidx + count, this._events.size());
        return this._events.subList(sidx, eidx);
    }

    public void insertBpelEvent(ProcessInstanceEvent event) {
        this._events.add(event);
    }

    public int getEventCount() {
        return this._events.size();
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        return this._instantiatingCorrelator;
    }

    public Collection<ScopeDAO> getScopes(String scopeName) {
        List<ScopeDAO> scopes = this._scopesByName.get(scopeName);
        return scopes == null ? EMPTY_SCOPE_DAOS : scopes;
    }

    public short getPreviousState() {
        return this._previousState;
    }

    public Date getLastActiveTime() {
        return this._lastActive;
    }

    public void setLastActiveTime(Date dt) {
        this._lastActive = dt;
    }

    public void finishCompletion() {
        assert (ProcessState.isFinished((short)this.getState()));
        this.getProcess().instanceCompleted((ProcessInstanceDAO)this);
    }

    public boolean delete(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories) {
        this._processDao._instances.remove(this._instanceId);
        return true;
    }

    public Collection<ScopeDAO> getScopes() {
        return this._scopes.values();
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        ProcessInstanceDAO.EventsFirstLastCountTuple ret = new ProcessInstanceDAO.EventsFirstLastCountTuple();
        ret.count = this._events.size();
        Date first = new Date();
        Date last = new Date(0L);
        for (ProcessInstanceEvent event : this._events) {
            if (event.getTimestamp().before(first)) {
                first = event.getTimestamp();
            }
            if (!event.getTimestamp().after(last)) continue;
            last = event.getTimestamp();
        }
        ret.first = first;
        ret.last = last;
        return ret;
    }

    public int getActivityFailureCount() {
        return this._failureCount;
    }

    public Date getActivityFailureDateTime() {
        return this._failureDateTime;
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        return this._activityRecoveries.values();
    }

    public void createActivityRecovery(String channel, long activityId, String reason, Date dateTime, Element data, String[] actions, int retries) {
        this._activityRecoveries.put(channel, new ActivityRecoveryDAOImpl(channel, activityId, reason, dateTime, data, actions, retries));
        this._failureCount = this._activityRecoveries.size();
        this._failureDateTime = dateTime;
    }

    public void deleteActivityRecovery(String channel) {
        this._activityRecoveries.remove(channel);
        this._failureCount = this._activityRecoveries.size();
    }

    public synchronized long genMonotonic() {
        return ++this._seq;
    }

    void removeRoutes(String routeGroupId) {
        for (CorrelatorDaoImpl correlator : this._processDao._correlators.values()) {
            correlator._removeRoutes(routeGroupId, this);
        }
    }

    public BpelDAOConnection getConnection() {
        return this._conn;
    }

    public String toString() {
        return "mem.instance(type=" + this._processDao.getType() + " iid=" + this._instanceId + ")";
    }

    public int getExecutionStateCounter() {
        return this._execStateCount;
    }

    public void setExecutionStateCounter(int stateCounter) {
        this._execStateCount = stateCounter;
    }

    static class ActivityRecoveryDAOImpl
    implements ActivityRecoveryDAO {
        private long _activityId;
        private String _channel;
        private String _reason;
        private Element _details;
        private Date _dateTime;
        private String _actions;
        private int _retries;

        ActivityRecoveryDAOImpl(String channel, long activityId, String reason, Date dateTime, Element details, String[] actions, int retries) {
            this._activityId = activityId;
            this._channel = channel;
            this._reason = reason;
            this._details = details;
            this._dateTime = dateTime;
            this._actions = actions[0];
            for (int i = 1; i < actions.length; ++i) {
                this._actions = this._actions + " " + actions[i];
            }
            this._retries = retries;
        }

        public long getActivityId() {
            return this._activityId;
        }

        public String getChannel() {
            return this._channel;
        }

        public String getReason() {
            return this._reason;
        }

        public Element getDetails() {
            return this._details;
        }

        public Date getDateTime() {
            return this._dateTime;
        }

        public String getActions() {
            return this._actions;
        }

        public String[] getActionsList() {
            return this._actions.split(" ");
        }

        public int getRetries() {
            return this._retries;
        }
    }
}

