/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.ra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;

class ConnectionEventListenerSupport
implements ConnectionEventListener {
    private final List<ConnectionEventListener> _eventListeners = new ArrayList<ConnectionEventListener>();

    ConnectionEventListenerSupport() {
    }

    public void connectionClosed(ConnectionEvent event) {
        Iterator<ConnectionEventListener> i = this._eventListeners.iterator();
        while (i.hasNext()) {
            i.next().connectionClosed(event);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        Iterator<ConnectionEventListener> i = this._eventListeners.iterator();
        while (i.hasNext()) {
            i.next().connectionErrorOccurred(event);
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        Iterator<ConnectionEventListener> i = this._eventListeners.iterator();
        while (i.hasNext()) {
            i.next().localTransactionCommitted(event);
        }
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        Iterator<ConnectionEventListener> i = this._eventListeners.iterator();
        while (i.hasNext()) {
            i.next().localTransactionRolledback(event);
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
        Iterator<ConnectionEventListener> i = this._eventListeners.iterator();
        while (i.hasNext()) {
            i.next().localTransactionStarted(event);
        }
    }

    void addListener(ConnectionEventListener el) {
        this._eventListeners.add(el);
    }

    void removeListener(ConnectionEventListener el) {
        this._eventListeners.remove(el);
    }
}

