/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jca.server.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.ode.jca.server.Interaction;
import org.apache.ode.jca.server.rmi.RmiTransportServerImpl;
import org.apache.ode.ra.transports.rmi.OdeTransportPipeRemote;
import org.apache.ode.utils.Reflect;

class RmiPipeServerImpl
implements OdeTransportPipeRemote {
    private RmiTransportServerImpl _server;
    private String[] _connectionClass;
    private HashMap<String, Method> _methodMap = new HashMap();
    final long createTime;
    long lastActivityTime = this.createTime = System.currentTimeMillis();
    OdeTransportPipeRemote remote;
    Object target;
    private WeakHashMap<Object, RmiPipeServerImpl> _interactions = new WeakHashMap();

    public RmiPipeServerImpl(RmiTransportServerImpl rmiTransportServerImpl, Object object, String[] stringArray) {
        this._server = rmiTransportServerImpl;
        this._connectionClass = stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : stringArray) {
            arrayList.add(object2);
        }
        for (Class<?> clazz : object.getClass().getInterfaces()) {
            for (Method method : clazz.getMethods()) {
                this._methodMap.put(Reflect.generateMethodSignature((Method)method), method);
            }
        }
        this.target = object;
    }

    public void close() {
        this._server.pipeClosed(this);
        this.remote = null;
    }

    public String[] getConnectionClassNames() {
        return this._connectionClass;
    }

    public Object invokeConnectionMethod(String string, Object[] objectArray) throws RemoteException, InvocationTargetException {
        this.lastActivityTime = System.currentTimeMillis();
        Method method = this._methodMap.get(string);
        if (method == null) {
            throw new RemoteException("Unknown method: " + string);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Object object = method.invoke(this.target, objectArray);
            if (object != null && object instanceof Interaction) {
                RmiPipeServerImpl rmiPipeServerImpl = this._interactions.get(object);
                if (rmiPipeServerImpl != null) {
                    RmiPipeServerImpl rmiPipeServerImpl2 = rmiPipeServerImpl;
                    return rmiPipeServerImpl2;
                }
                Class<?>[] classArray = object.getClass().getInterfaces();
                String[] stringArray = new String[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    stringArray[i] = classArray[i].getName();
                }
                rmiPipeServerImpl = new RmiPipeServerImpl(this._server, object, stringArray);
                this._interactions.put(object, rmiPipeServerImpl);
                RmiPipeServerImpl rmiPipeServerImpl3 = rmiPipeServerImpl;
                return rmiPipeServerImpl3;
            }
            Object object2 = object;
            return object2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RemoteException("Illegal Argument", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RemoteException("Illegal Access", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

