/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityFailureEvent;
import org.apache.ode.bpel.evt.ActivityRecoveryEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OFailureHandling;
import org.apache.ode.bpel.rtrep.v1.OInvoke;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ActivityRecoveryChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.InvokeResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.InvokeResponseChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INVOKE
extends ACTIVITY {
    private static final long serialVersionUID = 992248281026821783L;
    private static final Log __log = LogFactory.getLog(INVOKE.class);
    private OInvoke _oinvoke;
    private int _invoked;
    private Date _lastFailure;
    private String _failureReason;
    private Element _failureData;

    public INVOKE(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
        this._oinvoke = (OInvoke)this._self.o;
        this._invoked = 0;
    }

    public final void run() {
        Element outboundMsg;
        try {
            outboundMsg = this.setupOutbound(this._oinvoke, this._oinvoke.initCorrelationsInput);
        }
        catch (FaultException e) {
            __log.error((Object)e);
            FaultData fault = this.createFault(e.getQName(), this._oinvoke);
            this._self.parent.completed(fault, CompensationHandler.emptySet());
            return;
        }
        catch (ExternalVariableModuleException e) {
            __log.error((Object)e);
            this._self.parent.failure(e.toString(), null);
            return;
        }
        ++this._invoked;
        boolean isTwoWay = this._oinvoke.outputVar != null;
        try {
            if (!isTwoWay) {
                FaultData faultData = null;
                this.getBpelRuntime().invoke(null, this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, outboundMsg, null);
                this._self.parent.completed(faultData, CompensationHandler.emptySet());
            } else {
                final VariableInstance outputVar = this._scopeFrame.resolve(this._oinvoke.outputVar);
                final InvokeResponseChannel invokeResponseChannel = (InvokeResponseChannel)this.newChannel(InvokeResponseChannel.class);
                final String mexId = this.getBpelRuntime().invoke(invokeResponseChannel.export(), this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, outboundMsg, invokeResponseChannel);
                INVOKE.object((boolean)false, (Set)new InvokeResponseChannelListener(invokeResponseChannel){
                    private static final long serialVerstmptmpionUID = 4496880438819196765L;

                    public void onResponse() {
                        Element response;
                        FaultData fault = null;
                        try {
                            response = INVOKE.this.getBpelRuntime().getPartnerResponse(mexId);
                        }
                        catch (Exception e) {
                            __log.error((Object)"Exception while processing invoke response", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        try {
                            INVOKE.this.initializeVariable(outputVar, response);
                        }
                        catch (ExternalVariableModuleException e) {
                            __log.error((Object)"Exception while initializing external variable", (Throwable)e);
                            INVOKE.this._self.parent.failure(e.toString(), null);
                            return;
                        }
                        VariableModificationEvent se = new VariableModificationEvent(outputVar.declaration.name);
                        se.setNewValue((Node)response);
                        if (((INVOKE)INVOKE.this)._oinvoke.debugInfo != null) {
                            se.setLineNo(((INVOKE)INVOKE.this)._oinvoke.debugInfo.startLine);
                        }
                        INVOKE.this.sendEvent((ScopeEvent)se);
                        try {
                            for (OScope.CorrelationSet anInitCorrelationsOutput : ((INVOKE)INVOKE.this)._oinvoke.initCorrelationsOutput) {
                                INVOKE.this.initializeCorrelation(INVOKE.this._scopeFrame.resolve(anInitCorrelationsOutput), outputVar);
                            }
                            if (((INVOKE)INVOKE.this)._oinvoke.partnerLink.hasPartnerRole()) {
                                String partnersSessionId;
                                Node fromEpr;
                                if (!(INVOKE.this.getBpelRuntime().isPartnerRoleEndpointInitialized(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink)) && ((INVOKE)INVOKE.this)._oinvoke.partnerLink.initializePartnerRole || (fromEpr = INVOKE.this.getBpelRuntime().getSourceEPR(mexId)) == null)) {
                                    INVOKE.this.getBpelRuntime().writeEndpointReference(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), (Element)fromEpr);
                                }
                                if ((partnersSessionId = INVOKE.this.getBpelRuntime().getSourceSessionId(mexId)) != null) {
                                    INVOKE.this.getBpelRuntime().initializePartnersSessionId(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), partnersSessionId);
                                }
                            }
                        }
                        catch (FaultException e) {
                            fault = INVOKE.this.createFault(e.getQName(), INVOKE.this._oinvoke);
                        }
                        INVOKE.this._self.parent.completed(fault, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntime().releasePartnerMex(mexId, fault == null);
                    }

                    public void onFault() {
                        QName faultName = INVOKE.this.getBpelRuntime().getPartnerFault(mexId);
                        Element msg = INVOKE.this.getBpelRuntime().getPartnerResponse(mexId);
                        QName msgType = INVOKE.this.getBpelRuntime().getPartnerResponseType(mexId);
                        FaultData fault = INVOKE.this.createFault(faultName, msg, ((INVOKE)INVOKE.this)._oinvoke.getOwner().messageTypes.get(msgType), INVOKE.this._self.o);
                        INVOKE.this._self.parent.completed(fault, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntime().releasePartnerMex(mexId, false);
                    }

                    public void onFailure() {
                        String reason = INVOKE.this.getBpelRuntime().getPartnerFaultExplanation(mexId);
                        __log.error((Object)("Failure during invoke: " + reason));
                        try {
                            Element el = DOMUtils.stringToDOM((String)("<invokeFailure><![CDATA[" + reason + "]]></invokeFailure>"));
                            INVOKE.this._self.parent.failure(reason, el);
                        }
                        catch (Exception e) {
                            INVOKE.this._self.parent.failure(reason, null);
                        }
                        INVOKE.this.getBpelRuntime().releasePartnerMex(mexId, false);
                    }
                }.or(new TerminationChannelListener(this._self.self){
                    private static final long serialVersionUID = 4219496341785922396L;

                    public void terminate() {
                        INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
                        1.object((ChannelListener)new InvokeResponseChannelListener(invokeResponseChannel){
                            private static final long serialVersionUID = 688746737897792929L;

                            public void onFailure() {
                                __log.debug((Object)("Failure on invoke ignored, the invoke has already been terminated: " + INVOKE.this._oinvoke.toString()));
                            }

                            public void onFault() {
                                __log.debug((Object)("Fault on invoke ignored, the invoke has already been terminated: " + INVOKE.this._oinvoke.toString()));
                            }

                            public void onResponse() {
                                __log.debug((Object)("Response on invoke ignored, the invoke has already been terminated: " + INVOKE.this._oinvoke.toString()));
                            }
                        });
                    }
                }));
            }
        }
        catch (FaultException fault) {
            __log.error((Object)fault);
            FaultData faultData = this.createFault(fault.getQName(), this._oinvoke, fault.getMessage());
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
        }
    }

    private Element setupOutbound(OInvoke oinvoke, Collection<OScope.CorrelationSet> outboundInitiations) throws FaultException, ExternalVariableModuleException {
        if (outboundInitiations.size() > 0) {
            for (OScope.CorrelationSet c : outboundInitiations) {
                this.initializeCorrelation(this._scopeFrame.resolve(c), this._scopeFrame.resolve(oinvoke.inputVar));
            }
        }
        if (oinvoke.operation.getInput().getMessage().getParts().size() > 0) {
            this.sendVariableReadEvent(this._scopeFrame.resolve(oinvoke.inputVar));
            Node outboundMsg = this.fetchVariableData(this._scopeFrame.resolve(oinvoke.inputVar), false);
            assert (outboundMsg instanceof Element);
            return (Element)outboundMsg;
        }
        return null;
    }

    private void requireRecovery() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("ActivityRecovery: Invoke activity " + this._self.aId + " requires recovery"));
        }
        this.sendEvent((ActivityEvent)new ActivityFailureEvent(this._failureReason));
        final ActivityRecoveryChannel recoveryChannel = (ActivityRecoveryChannel)this.newChannel(ActivityRecoveryChannel.class);
        this.getBpelRuntime().registerActivityForRecovery(recoveryChannel, this._self.aId, this._failureReason, this._lastFailure, this._failureData, new String[]{"retry", "cancel", "fault"}, this._invoked - 1);
        INVOKE.object((boolean)false, (Set)new ActivityRecoveryChannelListener(recoveryChannel){
            private static final long serialVersionUID = 8397883882810521685L;

            public void retry() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Retrying invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("retry"));
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                4.instance((JacobRunnable)INVOKE.this);
            }

            public void cancel() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Cancelling invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("cancel"));
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                INVOKE.this._self.parent.cancelled();
            }

            public void fault(FaultData faultData) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Faulting invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("fault"));
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                if (faultData == null) {
                    faultData = INVOKE.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, INVOKE.this._self.o, INVOKE.this._failureReason);
                }
                INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
            }
        }.or(new TerminationChannelListener(this._self.self){
            private static final long serialVersionUID = 2148587381204858397L;

            public void terminate() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Cancelling invoke activity " + INVOKE.this._self.aId + " (terminated by scope)"));
                }
                INVOKE.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
            }
        }));
    }
}

