/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.CorrelationSetModel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPartnerLink
extends OBase
implements PartnerLinkModel {
    static final long serialVersionUID = -1L;
    public String name;
    public OScope declaringScope;
    public QName partnerLinkType;
    public String partnerRoleName;
    public String myRoleName;
    public PortType myRolePortType;
    public PortType partnerRolePortType;
    public boolean initializePartnerRole;
    private final HashMap<String, Set<OScope.CorrelationSet>> _nonIntitiatingCorrelationSets = new HashMap();
    private final HashSet<String> _createInstanceOperations = new HashSet();

    public OPartnerLink(OProcess owner) {
        super(owner);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasMyRole() {
        return this.myRolePortType != null;
    }

    public boolean hasPartnerRole() {
        return this.partnerRolePortType != null;
    }

    public boolean isCreateInstanceOperation(Operation op) {
        return this._createInstanceOperations.contains(op.getName());
    }

    public void addCreateInstanceOperation(Operation operation) {
        this._createInstanceOperations.add(operation.getName());
    }

    public void addCorrelationSetForOperation(Operation operation, OScope.CorrelationSet cset) {
        Set<OScope.CorrelationSet> ret = this._nonIntitiatingCorrelationSets.get(operation.getName());
        if (ret == null) {
            ret = new HashSet<OScope.CorrelationSet>();
            this._nonIntitiatingCorrelationSets.put(operation.getName(), ret);
        }
        ret.add(cset);
    }

    public Set<CorrelationSetModel> getCorrelationSetsForOperation(Operation operation) {
        Set<OScope.CorrelationSet> ret = this._nonIntitiatingCorrelationSets.get(operation.getName());
        if (ret == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<OScope.CorrelationSet>(ret));
    }

    public void addUniqueCorrelationSetForOperation(Operation operation, OScope.CorrelationSet cset) {
    }

    public Set<CorrelationSetModel> getUniqueCorrelationSetsForOperation(Operation operation) {
        return Collections.EMPTY_SET;
    }

    public Operation getMyRoleOperation(String name) {
        for (Operation op : this.myRolePortType.getOperations()) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    public Operation getPartnerRoleOperation(String name) {
        for (Operation op : this.partnerRolePortType.getOperations()) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    public String getMyRoleName() {
        return this.myRoleName;
    }

    public String getPartnerRoleName() {
        return this.partnerRoleName;
    }

    public boolean isInitializePartnerRoleSet() {
        return this.initializePartnerRole;
    }

    public PortType getMyRolePortType() {
        return this.myRolePortType;
    }

    public PortType getPartnerRolePortType() {
        return this.partnerRolePortType;
    }
}

