/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.InvalidContextException;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OPickReceive;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.Selector;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.PickResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.PickResponseChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PICK
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(PICK.class);
    private OPickReceive _opick;
    private OPickReceive.OnAlarm _alarm = null;

    public PICK(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
        this._opick = (OPickReceive)self.o;
    }

    public void run() {
        PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
        try {
            Selector[] selectors = new Selector[this._opick.onMessages.size()];
            int idx = 0;
            for (OPickReceive.OnMessage onMessage : this._opick.onMessages) {
                CorrelationKey key = null;
                PartnerLinkInstance pLinkInstance = this._scopeFrame.resolve(onMessage.partnerLink);
                if (onMessage.matchCorrelation == null && !this._opick.createInstanceFlag) {
                    String sessionId = this.getBpelRuntime().fetchMySessionId(pLinkInstance);
                    key = new CorrelationKey(-1, new String[]{sessionId});
                } else if (onMessage.matchCorrelation != null) {
                    if (!this.getBpelRuntime().isCorrelationInitialized(this._scopeFrame.resolve(onMessage.matchCorrelation))) {
                        if (!this._opick.createInstanceFlag) {
                            throw new FaultException(this._opick.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                        }
                    } else {
                        key = this.getBpelRuntime().readCorrelation(this._scopeFrame.resolve(onMessage.matchCorrelation));
                        assert (key != null);
                    }
                }
                selectors[idx] = new Selector(idx, pLinkInstance, onMessage.operation.getName(), onMessage.operation.getOutput() == null, onMessage.messageExchangeId, key);
                ++idx;
            }
            Date timeout = null;
            for (OPickReceive.OnAlarm onAlarm : this._opick.onAlarms) {
                Date dt;
                Date date = dt = onAlarm.forExpr != null ? PICK.offsetFromNow(this.getBpelRuntime().getExpLangRuntime().evaluateAsDuration(onAlarm.forExpr, this.getEvaluationContext())) : this.getBpelRuntime().getExpLangRuntime().evaluateAsDate(onAlarm.untilExpr, this.getEvaluationContext()).getTime();
                if (timeout != null && timeout.compareTo(dt) <= 0) continue;
                timeout = dt;
                this._alarm = onAlarm;
            }
            this.getBpelRuntime().select(pickResponseChannel, timeout, this._opick.createInstanceFlag, selectors);
        }
        catch (FaultException e) {
            __log.error((Object)e);
            FaultData fault = this.createFault(e.getQName(), this._opick, e.getMessage());
            this.dpe(this._opick.outgoingLinks);
            this._self.parent.completed(fault, CompensationHandler.emptySet());
            return;
        }
        for (OPickReceive.OnAlarm oa : this._opick.onAlarms) {
            if (oa.equals(this._alarm)) continue;
            this.dpe(oa.activity);
        }
        PICK.instance((JacobRunnable)new WAITING(pickResponseChannel));
    }

    private static Date offsetFromNow(Duration duration) {
        Calendar cal = Calendar.getInstance();
        duration.addTo(cal);
        return cal.getTime();
    }

    private void initVariable(String mexId, OPickReceive.OnMessage onMessage) {
        Element msgEl;
        if (onMessage.variable == null) {
            return;
        }
        try {
            msgEl = this.getBpelRuntime().getMyRequest(mexId);
        }
        catch (BpelEngineException e) {
            __log.error((Object)"The message exchange seems to be in an unconsistent state, you're probably missing a reply on a request/response interaction.");
            this._self.parent.failure(e.toString(), null);
            return;
        }
        Set partNames = onMessage.operation.getInput().getMessage().getParts().keySet();
        if (!(onMessage.variable.type instanceof OMessageVarType)) {
            String errmsg = "Non-message variable for receive: should have been picked up by static analysis.";
            __log.fatal((Object)errmsg);
            throw new InvalidProcessException(errmsg);
        }
        OMessageVarType vartype = (OMessageVarType)onMessage.variable.type;
        for (String pName : partNames) {
            String errmsg;
            QName partName = new QName(null, pName);
            Element msgPart = DOMUtils.findChildByName((Element)msgEl, (QName)partName);
            OMessageVarType.Part part = vartype.parts.get(pName);
            if (part == null) {
                errmsg = "Inconsistent WSDL, part " + pName + " not found in message type " + vartype.messageType;
                __log.fatal((Object)errmsg);
                throw new InvalidProcessException(errmsg);
            }
            if (msgPart == null) {
                errmsg = "Message missing part: " + pName;
                __log.fatal((Object)errmsg);
                throw new InvalidContextException(errmsg);
            }
            if (!(part.type instanceof OElementVarType)) continue;
            OElementVarType ptype = (OElementVarType)part.type;
            Element e = DOMUtils.getFirstChildElement((Element)msgPart);
            if (e == null) {
                String errmsg2 = "Message (element) part " + pName + " did not contain child element.";
                __log.fatal((Object)errmsg2);
                throw new InvalidContextException(errmsg2);
            }
            QName qn = new QName(e.getNamespaceURI(), e.getLocalName());
            if (qn.equals(ptype.elementType)) continue;
            String errmsg3 = "Message (element) part " + pName + " did not contain correct child element: expected " + ptype.elementType + " but got " + qn;
            __log.fatal((Object)errmsg3);
            throw new InvalidContextException(errmsg3);
        }
        VariableInstance vinst = this._scopeFrame.resolve(onMessage.variable);
        try {
            this.initializeVariable(vinst, msgEl);
        }
        catch (ExternalVariableModuleException e) {
            __log.error((Object)"Exception while initializing external variable", (Throwable)e);
            this._self.parent.failure(e.toString(), null);
            return;
        }
        VariableModificationEvent se = new VariableModificationEvent(vinst.declaration.name);
        se.setNewValue((Node)msgEl);
        if (this._opick.debugInfo != null) {
            se.setLineNo(this._opick.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)se);
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
        }

        public void run() {
            WAITING.object((boolean)false, (Set)new PickResponseChannelListener(this._pickResponseChannel){
                private static final long serialVersionUID = -8237296827418738011L;

                public void onRequestRcvd(int selectorIdx, String mexId) {
                    OPickReceive.OnMessage onMessage = ((PICK)PICK.this)._opick.onMessages.get(selectorIdx);
                    for (OPickReceive.OnMessage onmsg : ((PICK)PICK.this)._opick.onMessages) {
                        if (onmsg.equals(onMessage)) continue;
                        PICK.this.dpe(onmsg.activity);
                    }
                    if (PICK.this._alarm != null) {
                        PICK.this.dpe(((PICK)PICK.this)._alarm.activity);
                    }
                    if (((PICK)PICK.this)._opick.onMessages.size() > 1 && onMessage.operation.getOutput() == null) {
                        WAITING.this.getBpelRuntime().cancelOutstandingRequests(WAITING.this._pickResponseChannel.export());
                    }
                    PICK.this.initVariable(mexId, onMessage);
                    try {
                        for (OScope.CorrelationSet cset : onMessage.initCorrelations) {
                            WAITING.this.initializeCorrelation(PICK.this._scopeFrame.resolve(cset), PICK.this._scopeFrame.resolve(onMessage.variable));
                        }
                        if (onMessage.partnerLink.hasPartnerRole()) {
                            String partnersSessionId;
                            Node fromEpr;
                            if (!(WAITING.this.getBpelRuntime().isPartnerRoleEndpointInitialized(PICK.this._scopeFrame.resolve(onMessage.partnerLink)) && onMessage.partnerLink.initializePartnerRole || (fromEpr = WAITING.this.getBpelRuntime().getSourceEPR(mexId)) == null)) {
                                if (__log.isDebugEnabled()) {
                                    __log.debug((Object)("Received callback EPR " + DOMUtils.domToString((Node)fromEpr) + " saving it on partner link " + onMessage.partnerLink.getName()));
                                }
                                WAITING.this.getBpelRuntime().writeEndpointReference(PICK.this._scopeFrame.resolve(onMessage.partnerLink), (Element)fromEpr);
                            }
                            if ((partnersSessionId = WAITING.this.getBpelRuntime().getSourceSessionId(mexId)) != null) {
                                WAITING.this.getBpelRuntime().initializePartnersSessionId(PICK.this._scopeFrame.resolve(onMessage.partnerLink), partnersSessionId);
                            }
                        }
                    }
                    catch (FaultException e) {
                        __log.error((Object)e);
                        FaultData fault = WAITING.this.createFault(e.getQName(), onMessage);
                        PICK.this._self.parent.completed(fault, CompensationHandler.emptySet());
                        PICK.this.dpe(onMessage.activity);
                        return;
                    }
                    ActivityInfo child = new ActivityInfo(WAITING.this.genMonotonic(), onMessage.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(child, PICK.this._scopeFrame, PICK.this._linkFrame));
                }

                public void onTimeout() {
                    for (OPickReceive.OnMessage onMessage : ((PICK)PICK.this)._opick.onMessages) {
                        PICK.this.dpe(onMessage.activity);
                    }
                    ActivityInfo child = new ActivityInfo(WAITING.this.genMonotonic(), ((PICK)PICK.this)._alarm.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(child, PICK.this._scopeFrame, PICK.this._linkFrame));
                }

                public void onCancel() {
                    PICK.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(PICK.this._self.self){
                private static final long serialVersionUID = 4399496341785922396L;

                public void terminate() {
                    WAITING.this.getBpelRuntime().cancel(WAITING.this._pickResponseChannel);
                    1.instance((JacobRunnable)WAITING.this);
                }
            }));
        }
    }
}

