/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRuntime;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.PropertyExtractor;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v1.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.rtrep.v1.Messages;
import org.apache.ode.bpel.rtrep.v1.OExpressionLanguage;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.PropertyAliasEvaluationContext;
import org.apache.ode.bpel.rtrep.v1.ReplacementMapImpl;
import org.apache.ode.bpel.rtrep.v1.RuntimeInstanceImpl;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeImpl
implements OdeRuntime {
    private static final Log __log = LogFactory.getLog(RuntimeImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    ProcessConf _pconf;
    OProcess _oprocess;
    Set<String> _mustUnderstandExtensions;
    ReplacementMap _replacementMap;
    ExpressionLanguageRuntimeRegistry _expLangRuntimeRegistry;
    Map<String, ExtensionBundleRuntime> _extensionRegistry;

    public void init(ProcessConf pconf, ProcessModel pmodel) {
        this._pconf = pconf;
        this._oprocess = (OProcess)pmodel;
        this._replacementMap = new ReplacementMapImpl(this._oprocess);
        ExpressionLanguageRuntimeRegistry elangRegistry = new ExpressionLanguageRuntimeRegistry();
        for (OExpressionLanguage elang : this._oprocess.expressionLanguages) {
            try {
                elangRegistry.registerRuntime(elang);
            }
            catch (ConfigurationException e) {
                String msg = __msgs.msgExpLangRegistrationError(elang.expressionLanguageUri, elang.properties);
                __log.error((Object)msg, (Throwable)e);
                throw new BpelEngineException(msg, (Throwable)e);
            }
        }
        this._expLangRuntimeRegistry = elangRegistry;
        this._mustUnderstandExtensions = new HashSet<String>();
    }

    public OdeRTInstance newInstance(Object state) {
        return new RuntimeInstanceImpl(this, (ExecutionQueueImpl)state);
    }

    public ReplacementMap getReplacementMap(QName processName) {
        if (this._pconf.getProcessId().equals(processName)) {
            return new ReplacementMapImpl(this._oprocess);
        }
        throw new UnsupportedOperationException("Implement the creation of replacement map for other version.");
    }

    public ProcessModel getModel() {
        return this._oprocess;
    }

    public String extractProperty(Element msgData, PropertyAliasModel aliasModel, String target) throws FaultException {
        OProcess.OPropertyAlias alias = (OProcess.OPropertyAlias)aliasModel;
        PropertyAliasEvaluationContext ectx = new PropertyAliasEvaluationContext(msgData, alias);
        Node lValue = ectx.getRootNode();
        if (alias.location != null) {
            lValue = this._expLangRuntimeRegistry.evaluateNode(alias.location, ectx);
        }
        if (lValue == null) {
            String errmsg = __msgs.msgPropertyAliasReturnedNullSet(alias.getDescription(), target);
            if (__log.isErrorEnabled()) {
                __log.error((Object)errmsg);
            }
            throw new FaultException(this._oprocess.constants.qnSelectionFailure, errmsg);
        }
        if (lValue.getNodeType() == 1) {
            StringBuffer val = new StringBuffer();
            NodeList nl = lValue.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                val.append(n.getNodeValue());
            }
            return val.toString();
        }
        if (lValue.getNodeType() == 3) {
            return ((Text)lValue).getWholeText();
        }
        return null;
    }

    public String extractMatch(Element msgData, PropertyExtractor extractor) throws FaultException {
        return null;
    }

    public void clear() {
        this._pconf = null;
        this._oprocess = null;
        this._mustUnderstandExtensions = null;
        this._replacementMap = null;
        this._expLangRuntimeRegistry = null;
        this._extensionRegistry = null;
    }

    public void setExtensionRegistry(Map<String, ExtensionBundleRuntime> extensionRegistry) {
        this._extensionRegistry = extensionRegistry;
    }
}

