/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evar.IncompleteKeyException;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.rapi.CorrelationSet;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rapi.NoSuchOperationException;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRTInstanceContext;
import org.apache.ode.bpel.rapi.PartnerLink;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.UninitializedPartnerEPR;
import org.apache.ode.bpel.rapi.UninitializedVariableException;
import org.apache.ode.bpel.rapi.Variable;
import org.apache.ode.bpel.rapi.VariableContext;
import org.apache.ode.bpel.rtrep.v1.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v1.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v1.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.rtrep.v1.Messages;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OPartnerLink;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v1.OutstandingRequestManager;
import org.apache.ode.bpel.rtrep.v1.PROCESS;
import org.apache.ode.bpel.rtrep.v1.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v1.PropertyAliasEvaluationContext;
import org.apache.ode.bpel.rtrep.v1.RuntimeImpl;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.Selector;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.InvokeResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.PickResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TimerResponseChannel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeInstanceImpl
implements OdeInternalInstance,
OdeRTInstance {
    private static final Log __log = LogFactory.getLog(RuntimeInstanceImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private OdeRTInstanceContext _brc;
    protected JacobVPU _vpu;
    protected ExecutionQueueImpl _soup;
    private RuntimeImpl _runtime;

    public RuntimeInstanceImpl(RuntimeImpl runtime, ExecutionQueueImpl soup) {
        this._runtime = runtime;
        this._vpu = new JacobVPU();
        this._vpu.registerExtension(OdeRTInstanceContext.class, (Object)this);
        if (soup == null) {
            this._soup = new ExecutionQueueImpl(this.getClass().getClassLoader());
            this._soup.setGlobalData((Serializable)new OutstandingRequestManager());
        } else {
            this._soup = soup;
        }
        this._soup.setReplacementMap(this._runtime._replacementMap);
        this._vpu.setContext((ExecutionQueue)this._soup);
    }

    public ProcessModel getProcessModel() {
        return this._runtime._oprocess;
    }

    @Override
    public boolean isCorrelationInitialized(CorrelationSetInstance correlationSet) {
        return this._brc.isCorrelationInitialized((CorrelationSet)correlationSet);
    }

    @Override
    public boolean isVariableInitialized(VariableInstance var) {
        return this._brc.isVariableInitialized((Variable)var);
    }

    @Override
    public boolean isPartnerRoleEndpointInitialized(PartnerLinkInstance pLink) {
        return this._brc.isPartnerRoleEndpointInitialized((PartnerLink)pLink);
    }

    @Override
    public void completedFault(FaultData faultData) {
        this.cleanupOutstandingMyRoleExchanges(faultData);
        this._brc.completedFault((FaultInfo)faultData);
    }

    @Override
    public void completedOk() {
        this.cleanupOutstandingMyRoleExchanges(null);
        this._brc.completedOk();
    }

    public Long createScopeInstance(Long parentScopeId, String name, int modelId) {
        return this._brc.createScopeInstance(parentScopeId, name, modelId);
    }

    @Override
    public void initializePartnerLinks(Long parentScopeId, Collection<OPartnerLink> partnerLinks) {
        this._brc.initializePartnerLinks(parentScopeId, partnerLinks);
    }

    @Override
    public void cancelOutstandingRequests(String channelId) {
        this.getORM().cancel(channelId);
    }

    @Override
    public void select(PickResponseChannel pickResponseChannel, Date timeout, boolean createInstance, Selector[] selectors) throws FaultException {
        String pickResponseChannelStr = pickResponseChannel.export();
        int conflict = this.getORM().findConflict(selectors);
        if (conflict != -1) {
            throw new FaultException(this._runtime._oprocess.constants.qnConflictingReceive, selectors[conflict].toString());
        }
        this.getORM().register(pickResponseChannelStr, selectors);
        this._brc.select(pickResponseChannelStr, timeout, (org.apache.ode.bpel.rapi.Selector[])selectors);
    }

    @Override
    public CorrelationKey readCorrelation(CorrelationSetInstance cset) {
        return this._brc.readCorrelation((CorrelationSet)cset);
    }

    @Override
    public Node fetchVariableData(VariableInstance variable, ScopeFrame scopeFrame, boolean forWriting) throws FaultException {
        if (variable.declaration.extVar != null) {
            Element reference = (Element)this._brc.fetchVariableData((Variable)scopeFrame.resolve(variable.declaration.extVar.related), false);
            try {
                Node ret = this._brc.readExtVar((Variable)variable, (Node)reference);
                if (ret == null) {
                    throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable, "The external variable \"" + variable.declaration.name + "\" has not been initialized.");
                }
                return ret;
            }
            catch (IncompleteKeyException ike) {
                __log.error((Object)("External variable could not be read due to incomplete key; the following key components were missing: " + ike.getMissing()));
                throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable, "The extenral variable \"" + variable.declaration.name + "\" has not been properly initialized;" + "the following key compoenents were missing:" + ike.getMissing());
            }
            catch (ExternalVariableModuleException e) {
                throw new BpelEngineException((Throwable)e);
            }
        }
        Node data = this._brc.fetchVariableData((Variable)variable, forWriting);
        if (data == null) {
            if (variable.declaration.type instanceof OMessageVarType) {
                OMessageVarType msgType = (OMessageVarType)variable.declaration.type;
                if (msgType.parts.size() == 0) {
                    Document doc = DOMUtils.newDocument();
                    Element root = doc.createElement("message");
                    doc.appendChild(root);
                    return root;
                }
            }
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable, "The variable " + variable.declaration.name + " isn't properly initialized.");
        }
        return data;
    }

    @Override
    public Node fetchVariableData(VariableInstance var, ScopeFrame scopeFrame, OMessageVarType.Part part, boolean forWriting) throws FaultException {
        Node val = this.fetchVariableData(var, scopeFrame, forWriting);
        if (part != null) {
            return this.getPartData((Element)val, part);
        }
        return val;
    }

    @Override
    public void writeCorrelation(CorrelationSetInstance cset, CorrelationKey ckeyVal) throws FaultException {
        OScope.CorrelationSet csetdef = cset.declaration;
        QName[] propNames = new QName[csetdef.properties.size()];
        for (int m = 0; m < csetdef.properties.size(); ++m) {
            OProcess.OProperty oProperty = csetdef.properties.get(m);
            propNames[m] = oProperty.name;
        }
        ckeyVal.setUnique(cset.declaration.isUnique());
        this._brc.writeCorrelation((CorrelationSet)cset, propNames, ckeyVal);
    }

    @Override
    public void sendEvent(ScopeEvent event) {
        this._brc.sendEvent((ProcessInstanceEvent)event);
    }

    @Override
    public void unregisterActivityForRecovery(ActivityRecoveryChannel recoveryChannel) {
        this._brc.unregisterActivityForRecovery(recoveryChannel.export());
    }

    @Override
    public void registerActivityForRecovery(ActivityRecoveryChannel recoveryChannel, long id, String reason, Date dateTime, Element details, String[] actions, int retryCount) {
        this._brc.registerActivityForRecovery(recoveryChannel.export(), id, reason, dateTime, details, actions, retryCount);
    }

    @Override
    public void registerTimer(TimerResponseChannel timerChannel, Date future) {
        this._brc.registerTimer(timerChannel.export(), future);
    }

    @Override
    public String readProperty(VariableInstance variable, OProcess.OProperty property) throws FaultException {
        try {
            return this._brc.readVariableProperty((Variable)variable, property.name);
        }
        catch (UninitializedVariableException e) {
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedVariable);
        }
    }

    @Override
    public long genId() {
        return this._brc.genId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node initializeVariable(VariableInstance var, ScopeFrame scopeFrame, Node val) throws ExternalVariableModuleException {
        try {
            if (var.declaration.extVar != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Initialize external variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)val)));
                }
                Node reference = null;
                try {
                    reference = this.fetchVariableData(var, scopeFrame, true);
                }
                catch (FaultException fe) {
                    // empty catch block
                }
                if (reference != null) {
                    val = this._brc.readExtVar((Variable)var, reference);
                }
                Node node = val;
                return node;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Initialize variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)val)));
            }
            Node node = this._brc.initializeVariable((Variable)var, val);
            return node;
        }
        finally {
            this.writeProperties(var, val);
        }
    }

    @Override
    public Node fetchMyRoleEndpointReferenceData(PartnerLinkInstance link) {
        return this._brc.fetchMyRoleEndpointReferenceData((PartnerLink)link);
    }

    @Override
    public Node fetchPartnerRoleEndpointReferenceData(PartnerLinkInstance link) throws FaultException {
        Element epr = this._brc.fetchPartnerRoleEndpointReferenceData((PartnerLink)link);
        if (epr == null) {
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedPartnerRole);
        }
        return epr;
    }

    @Override
    public Node convertEndpointReference(Element epr, Node lvaluePtr) {
        return this._brc.convertEndpointReference(epr, lvaluePtr);
    }

    @Override
    public void commitChanges(VariableInstance var, ScopeFrame scopeFrame, Node value) throws ExternalVariableModuleException {
        if (var.declaration.extVar != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Write external variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)value)));
            }
            VariableInstance related = scopeFrame.resolve(var.declaration.extVar.related);
            Node reference = null;
            try {
                reference = this.fetchVariableData(var, scopeFrame, true);
            }
            catch (FaultException fe) {
                // empty catch block
            }
            VariableContext.ValueReferencePair vrp = this._brc.writeExtVar((Variable)var, reference, value);
            this.commitChanges(related, scopeFrame, vrp.reference);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Write variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)value)));
            }
            this._brc.commitChanges((Variable)var, value);
        }
        this.writeProperties(var, value);
    }

    @Override
    public void writeEndpointReference(PartnerLinkInstance plval, Element element) {
        this._brc.writeEndpointReference((PartnerLink)plval, element);
    }

    @Override
    public Long createScopeInstance(Long scopeInstanceId, OScope scopedef) {
        return this._brc.createScopeInstance(scopeInstanceId, scopedef.name, scopedef.getId());
    }

    @Override
    public String fetchMySessionId(PartnerLinkInstance linkInstance) {
        return this._brc.fetchMySessionId((PartnerLink)linkInstance);
    }

    @Override
    public void cancel(PickResponseChannel responseChannel) {
        final String id = responseChannel.export();
        this._brc.cancelSelect(id);
        this.getORM().cancel(id);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 6157913683737696396L;

            public void run() {
                TimerResponseChannel responseChannel = (TimerResponseChannel)1.importChannel((String)id, TimerResponseChannel.class);
                responseChannel.onCancel();
            }
        });
    }

    @Override
    public Element getMyRequest(String mexId) {
        return this._brc.getMyRequest(mexId);
    }

    @Override
    public void initializePartnersSessionId(PartnerLinkInstance instance, String partnersSessionId) {
        this._brc.initializePartnersSessionId((PartnerLink)instance, partnersSessionId);
    }

    @Override
    public String getSourceSessionId(String mexId) {
        return this._brc.getSourceSessionId(mexId);
    }

    @Override
    public Node getSourceEPR(String mexId) {
        return this._brc.getSourceEPR(mexId);
    }

    @Override
    public ExtensionOperation createExtensionActivityImplementation(QName name) {
        if (name == null) {
            return null;
        }
        ExtensionBundleRuntime bundle = this._runtime._extensionRegistry.get(name.getNamespaceURI());
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.getExtensionOperationInstance(name.getLocalPart());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Long getPid() {
        return this._brc.getPid();
    }

    @Override
    public Element getPartnerResponse(String mexId) {
        return this._brc.getPartnerResponse(mexId);
    }

    @Override
    public void releasePartnerMex(String mexId, boolean instanceSucceeded) {
        this._brc.releasePartnerMex(mexId, instanceSucceeded);
    }

    @Override
    public QName getPartnerFault(String mexId) {
        return this._brc.getPartnerFault(mexId);
    }

    @Override
    public QName getPartnerResponseType(String mexId) {
        return this._brc.getPartnerResponseType(mexId);
    }

    @Override
    public String getPartnerFaultExplanation(String mexId) {
        return this._brc.getPartnerFaultExplanation(mexId);
    }

    @Override
    public void sendEvent(ProcessInstanceStartedEvent evt) {
        this._brc.sendEvent((ProcessInstanceEvent)evt);
    }

    @Override
    public void reply(PartnerLinkInstance plink, String opName, String bpelmex, Element element, QName fault) throws FaultException {
        String mexid = this.getORM().release(plink, opName, bpelmex);
        if (mexid == null) {
            throw new FaultException(this._runtime._oprocess.constants.qnMissingRequest);
        }
        try {
            this._brc.reply(mexid, (PartnerLink)plink, opName, element, fault);
        }
        catch (NoSuchOperationException e) {
            throw new FaultException(this._runtime._oprocess.constants.qnMissingRequest, "Undefined two-way operation \"" + opName + "\".");
        }
    }

    @Override
    public void forceFlush() {
        this._brc.forceFlush();
    }

    @Override
    public void terminate() {
        this.cleanupOutstandingMyRoleExchanges(null);
        this._brc.terminate();
    }

    private void writeProperties(VariableInstance variable, Node value) {
        if (variable.declaration.type instanceof OMessageVarType) {
            for (OProcess.OProperty property : variable.declaration.getOwner().properties) {
                OProcess.OPropertyAlias alias = property.getAlias(variable.declaration.type);
                if (alias == null) continue;
                try {
                    String val = this.extractProperty((Element)value, alias, variable.declaration.getDescription());
                    if (val == null) continue;
                    this._brc.writeVariableProperty((Variable)variable, property.name, val);
                }
                catch (UninitializedVariableException uve) {
                    __log.fatal((Object)("Couldn't extract property '" + property.toString() + "' in property pre-extraction: " + (Object)((Object)uve)));
                    throw new RuntimeException(uve);
                }
                catch (FaultException e) {
                    if (!__log.isDebugEnabled()) continue;
                    __log.debug((Object)("Couldn't extract property '" + property.toString() + "' in property pre-extraction: " + e.toString()));
                }
            }
        }
    }

    String extractProperty(Element msgData, OProcess.OPropertyAlias alias, String target) throws FaultException {
        PropertyAliasEvaluationContext ectx = new PropertyAliasEvaluationContext(msgData, alias);
        Node lValue = ectx.getRootNode();
        if (alias.location != null) {
            lValue = this._runtime._expLangRuntimeRegistry.evaluateNode(alias.location, ectx);
        }
        if (lValue == null) {
            String errmsg = __msgs.msgPropertyAliasReturnedNullSet(alias.getDescription(), target);
            if (__log.isErrorEnabled()) {
                __log.error((Object)errmsg);
            }
            throw new FaultException(this._runtime._oprocess.constants.qnSelectionFailure, errmsg);
        }
        if (lValue.getNodeType() == 1) {
            StringBuffer val = new StringBuffer();
            NodeList nl = lValue.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                val.append(n.getNodeValue());
            }
            return val.toString();
        }
        if (lValue.getNodeType() == 3) {
            return ((Text)lValue).getWholeText();
        }
        return null;
    }

    @Override
    public Node getPartData(Element message, OMessageVarType.Part part) {
        Element ret = DOMUtils.findChildByName((Element)message, (QName)new QName(null, part.name));
        if (part.type instanceof OElementVarType) {
            QName elName = ((OElementVarType)part.type).elementType;
            ret = DOMUtils.findChildByName((Element)ret, (QName)elName);
        } else if (part.type == null) {
            if (ret != null && ret.getNodeType() == 1 && ret.getAttribute("headerPart") != null && DOMUtils.getTextContent((Node)ret) == null) {
                ret = DOMUtils.getFirstChildElement((Element)ret);
            }
            if (ret == null) {
                ret = message.getOwnerDocument().createElementNS(null, part.name);
                ret.setAttribute("headerPart", "true");
                message.appendChild(ret);
            }
        }
        return ret;
    }

    @Override
    public String invoke(String invokeId, PartnerLinkInstance instance, Operation operation, Element outboundMsg, Object object) throws FaultException {
        try {
            return this._brc.invoke(invokeId, (PartnerLink)instance, operation, outboundMsg);
        }
        catch (UninitializedPartnerEPR e) {
            throw new FaultException(this._runtime._oprocess.constants.qnUninitializedPartnerRole);
        }
    }

    @Override
    public ExpressionLanguageRuntimeRegistry getExpLangRuntime() {
        return this._runtime._expLangRuntimeRegistry;
    }

    public void onSelectEvent(final String selectId, final String messageExchangeId, final int selectorIdx) {
        this.getORM().associate(selectId, messageExchangeId);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            public void run() {
                PickResponseChannel responseChannel = (PickResponseChannel)2.importChannel((String)selectId, PickResponseChannel.class);
                responseChannel.onRequestRcvd(selectorIdx, messageExchangeId);
            }
        });
    }

    public void onTimerEvent(final String timerId) {
        this.getORM().cancel(timerId);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = -7767141033611036745L;

            public void run() {
                TimerResponseChannel responseChannel = (TimerResponseChannel)3.importChannel((String)timerId, TimerResponseChannel.class);
                responseChannel.onTimeout();
            }
        });
    }

    public boolean execute() {
        return this._vpu.execute();
    }

    public void onInvokeResponse(final String invokeId, OdeRTInstance.InvokeResponseType irt, String mexid) {
        switch (irt) {
            case REPLY: {
                this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
                    private static final long serialVersionUID = -1095444335740879981L;

                    public void run() {
                        ((InvokeResponseChannel)4.importChannel((String)invokeId, InvokeResponseChannel.class)).onResponse();
                    }
                });
                break;
            }
            case FAULT: {
                this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
                    private static final long serialVersionUID = -1095444335740879981L;

                    public void run() {
                        ((InvokeResponseChannel)5.importChannel((String)invokeId, InvokeResponseChannel.class)).onFault();
                    }
                });
                break;
            }
            case FAILURE: {
                this._vpu.inject((JacobRunnable)new BpelJacobRunnable(){
                    private static final long serialVersionUID = -1095444335740879981L;

                    public void run() {
                        ((InvokeResponseChannel)6.importChannel((String)invokeId, InvokeResponseChannel.class)).onFailure();
                    }
                });
            }
        }
    }

    public void recoverActivity(final String channel, final long activityId, final String action, FaultInfo fault) {
        final FaultData fdata = fault != null ? new FaultData(fault.getFaultName(), null, fault.getExplanation()) : null;
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            public void run() {
                ActivityRecoveryChannel recovery = (ActivityRecoveryChannel)7.importChannel((String)channel, ActivityRecoveryChannel.class);
                __log.info((Object)("ActivityRecovery: Recovering activity " + activityId + " with action " + action + " on channel " + recovery));
                if (recovery != null) {
                    if ("cancel".equals(action)) {
                        recovery.cancel();
                    } else if ("retry".equals(action)) {
                        recovery.retry();
                    } else if ("fault".equals(action)) {
                        recovery.fault(fdata);
                    }
                }
            }
        });
    }

    private OutstandingRequestManager getORM() {
        return (OutstandingRequestManager)this._soup.getGlobalData();
    }

    private void cleanupOutstandingMyRoleExchanges(FaultInfo optionalFaultData) {
        String[] mexRefs;
        for (String mexId : mexRefs = this.getORM().releaseAll()) {
            this._brc.noreply(mexId, optionalFaultData);
        }
    }

    public Object saveState(OutputStream bos) throws IOException {
        this._soup.write(bos);
        return this._soup;
    }

    public void onCreateInstance(String messageExchangeId) {
        this._vpu.inject((JacobRunnable)new PROCESS(this._runtime._oprocess));
    }

    public void setContext(OdeRTInstanceContext ctx) {
        this._brc = ctx;
    }

    @Override
    public URI getBaseResourceURI() {
        return this._runtime._pconf.getBaseURI();
    }

    @Override
    public Node getProcessProperty(QName propertyName) {
        return this._brc.getProcessProperty(propertyName);
    }
}

