/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.ScopeFaultEvent;
import org.apache.ode.bpel.evt.ScopeStartEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.COMPENSATIONHANDLER_;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.EH_ALARM;
import org.apache.ode.bpel.rtrep.v1.EH_EVENT;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OCatch;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OEventHandler;
import org.apache.ode.bpel.rtrep.v1.OFailureHandling;
import org.apache.ode.bpel.rtrep.v1.OFaultHandler;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.ORDEREDCOMPENSATOR;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.CompensationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SCOPE
extends ACTIVITY {
    private static final long serialVersionUID = 6111903798996023525L;
    private static final Log __log = LogFactory.getLog(SCOPE.class);
    private OScope _oscope;
    private ActivityInfo _child;
    private Set<EventHandlerInfo> _eventHandlers = new HashSet<EventHandlerInfo>();

    public SCOPE(ActivityInfo self, ScopeFrame frame, LinkFrame linkFrame) {
        super(self, frame, linkFrame);
        this._oscope = (OScope)self.o;
        assert (this._oscope.activity != null);
    }

    public void run() {
        this._child = new ActivityInfo(this.genMonotonic(), this._oscope.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        SCOPE.instance((JacobRunnable)this.createChild(this._child, this._scopeFrame, this._linkFrame));
        if (this._oscope.eventHandler != null) {
            EventHandlerInfo ehi;
            for (OEventHandler.OAlarm alarm : this._oscope.eventHandler.onAlarms) {
                ehi = new EventHandlerInfo(alarm, (EventHandlerControlChannel)this.newChannel(EventHandlerControlChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class), (TerminationChannel)this.newChannel(TerminationChannel.class));
                this._eventHandlers.add(ehi);
                SCOPE.instance((JacobRunnable)new EH_ALARM(ehi.psc, ehi.tc, ehi.cc, alarm, this._scopeFrame));
            }
            for (OEventHandler.OEvent event : this._oscope.eventHandler.onMessages) {
                ehi = new EventHandlerInfo(event, (EventHandlerControlChannel)this.newChannel(EventHandlerControlChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class), (TerminationChannel)this.newChannel(TerminationChannel.class));
                this._eventHandlers.add(ehi);
                SCOPE.instance((JacobRunnable)new EH_EVENT(ehi.psc, ehi.tc, ehi.cc, event, this._scopeFrame));
            }
        }
        this.getBpelRuntime().initializePartnerLinks(this._scopeFrame.scopeInstanceId, this._oscope.partnerLinks.values());
        this.sendEvent((ScopeEvent)new ScopeStartEvent());
        SCOPE.instance((JacobRunnable)new ACTIVE());
    }

    private List<CompensationHandler> findCompensationData(OScope scope) {
        ArrayList<CompensationHandler> out = new ArrayList<CompensationHandler>();
        for (CompensationHandler ch : this._scopeFrame.availableCompensations) {
            if (null != scope && !ch.compensated.oscope.equals(scope)) continue;
            out.add(ch);
        }
        Collections.sort(out);
        return out;
    }

    private static OCatch findCatch(OFaultHandler fh, QName faultName, OVarType faultType) {
        OCatch bestMatch = null;
        for (OCatch c : fh.catchBlocks) {
            int existingScore;
            if (c.faultName != null && (faultName == null || !faultName.equals(c.faultName)) || c.faultVariable != null && (faultType == null || !(c.faultVariable.type instanceof OMessageVarType ? faultType instanceof OMessageVarType && ((OMessageVarType)faultType).equals(c.faultVariable.type) || faultType instanceof OElementVarType && ((OMessageVarType)c.faultVariable.type).docLitType != null && !((OMessageVarType)c.faultVariable.type).docLitType.equals(faultType) : c.faultVariable.type instanceof OElementVarType && (faultType instanceof OElementVarType && faultType.equals(c.faultVariable.type) || faultType instanceof OMessageVarType && ((OMessageVarType)faultType).docLitType != null && ((OMessageVarType)faultType).docLitType.equals(c.faultVariable.type))))) continue;
            if (bestMatch == null) {
                bestMatch = c;
                continue;
            }
            int currentScore = (c.faultName == null ? 0 : 2) + (c.faultVariable == null ? 0 : 1);
            if (currentScore <= (existingScore = (bestMatch.faultName == null ? 0 : 2) + (bestMatch.faultVariable == null ? 0 : 1))) continue;
            bestMatch = c;
        }
        return bestMatch;
    }

    static final class EventHandlerInfo
    implements Serializable {
        private static final long serialVersionUID = -9046603073542446478L;
        final OBase o;
        final EventHandlerControlChannel cc;
        final ParentScopeChannel psc;
        final TerminationChannel tc;
        boolean terminateRequested;
        boolean stopRequested;

        EventHandlerInfo(OBase o, EventHandlerControlChannel cc, ParentScopeChannel psc, TerminationChannel tc) {
            this.o = o;
            this.cc = cc;
            this.psc = psc;
            this.tc = tc;
        }
    }

    class ACTIVE
    extends ACTIVITY {
        private static final long serialVersionUID = -5876892592071965346L;
        private boolean _terminated;
        private FaultData _fault;
        private long _startTime;
        private final HashSet<CompensationHandler> _compensations;
        private boolean _childTermRequested;

        ACTIVE() {
            super(SCOPE.this._self, SCOPE.this._scopeFrame, SCOPE.this._linkFrame);
            this._compensations = new HashSet();
            this._startTime = System.currentTimeMillis();
        }

        public void run() {
            if (SCOPE.this._child != null || !SCOPE.this._eventHandlers.isEmpty()) {
                HashSet<ChannelListener> mlSet = new HashSet<ChannelListener>();
                mlSet.add(new TerminationChannelListener(this._self.self){
                    private static final long serialVersionUID = 1913414844895865116L;

                    public void terminate() {
                        ACTIVE.this._terminated = true;
                        if (SCOPE.this._child != null && !ACTIVE.this._childTermRequested) {
                            ((TerminationChannel)1.replication((Channel)((SCOPE)SCOPE.this)._child.self)).terminate();
                            ACTIVE.this._childTermRequested = true;
                        }
                        ACTIVE.this.terminateEventHandlers();
                        1.instance((JacobRunnable)ACTIVE.this);
                    }
                });
                if (SCOPE.this._child != null) {
                    mlSet.add(new ParentScopeChannelListener(((SCOPE)SCOPE.this)._child.parent){
                        private static final long serialVersionUID = -6934246487304813033L;

                        @Override
                        public void compensate(OScope scope, SynchChannel ret) {
                            if (ACTIVE.this._scopeFrame.availableCompensations == null) {
                                ACTIVE.this._self.parent.compensate(scope, ret);
                            } else {
                                List compensations = SCOPE.this.findCompensationData(scope);
                                ACTIVE.this._scopeFrame.availableCompensations.removeAll(compensations);
                                2.instance((JacobRunnable)new ORDEREDCOMPENSATOR(compensations, ret));
                            }
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void completed(FaultData flt, Set<CompensationHandler> compensations) {
                            if (flt != null && ACTIVE.this._fault == null) {
                                ACTIVE.this._fault = flt;
                            }
                            SCOPE.this._child = null;
                            ACTIVE.this._compensations.addAll(compensations);
                            if (flt == null) {
                                ACTIVE.this.stopEventHandlers();
                            } else {
                                ACTIVE.this.terminateEventHandlers();
                            }
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            if (((SCOPE)SCOPE.this)._oscope.implicitScope) {
                                ACTIVE.this._self.parent.cancelled();
                            } else {
                                this.completed(null, CompensationHandler.emptySet());
                            }
                        }

                        @Override
                        public void failure(String reason, Element data) {
                            this.completed(ACTIVE.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, ACTIVE.this._self.o, null), CompensationHandler.emptySet());
                        }
                    });
                }
                for (final EventHandlerInfo ehi : SCOPE.this._eventHandlers) {
                    mlSet.add(new ParentScopeChannelListener(ehi.psc){
                        private static final long serialVersionUID = -4694721357537858221L;

                        @Override
                        public void compensate(OScope scope, SynchChannel ret) {
                            ACTIVE.this._self.parent.compensate(scope, ret);
                            3.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void completed(FaultData flt, Set<CompensationHandler> compenstations) {
                            if (flt != null && ACTIVE.this._fault == null) {
                                ACTIVE.this._fault = flt;
                            }
                            SCOPE.this._eventHandlers.remove(ehi);
                            ACTIVE.this._compensations.addAll(compenstations);
                            if (flt != null) {
                                if (SCOPE.this._child != null && !ACTIVE.this._childTermRequested) {
                                    ((TerminationChannel)3.replication((Channel)((SCOPE)SCOPE.this)._child.self)).terminate();
                                    ACTIVE.this._childTermRequested = true;
                                }
                                ACTIVE.this.terminateEventHandlers();
                            } else {
                                ACTIVE.this.stopEventHandlers();
                            }
                            3.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String reason, Element data) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                ACTIVE.object((boolean)false, mlSet);
            } else {
                Set<CompensationHandler> unreachableCompensationHandlers = this._scopeFrame.availableCompensations;
                if (unreachableCompensationHandlers != null) {
                    for (CompensationHandler ch : unreachableCompensationHandlers) {
                        ch.compChannel.forget();
                    }
                }
                this._scopeFrame.availableCompensations = null;
                HashSet<OLink> linksNeedingDPE = new HashSet<OLink>();
                if (((SCOPE)SCOPE.this)._oscope.faultHandler != null) {
                    Iterator<OCatch> i = ((SCOPE)SCOPE.this)._oscope.faultHandler.catchBlocks.iterator();
                    while (i.hasNext()) {
                        linksNeedingDPE.addAll(i.next().outgoingLinks);
                    }
                }
                if (this._terminated) {
                    __log.debug((Object)("Scope: " + SCOPE.this._oscope + " was terminated."));
                    this._self.parent.completed(null, this._compensations);
                } else if (this._fault != null) {
                    OCatch catchBlock;
                    this.sendEvent((ScopeEvent)new ScopeFaultEvent(this._fault.getFaultName(), this._fault.getFaultLineNo(), this._fault.getExplanation()));
                    OCatch oCatch = catchBlock = ((SCOPE)SCOPE.this)._oscope.faultHandler == null ? null : SCOPE.findCatch(((SCOPE)SCOPE.this)._oscope.faultHandler, this._fault.getFaultName(), this._fault.getFaultType());
                    assert (SCOPE.this._eventHandlers.isEmpty());
                    assert (SCOPE.this._child == null);
                    if (catchBlock == null) {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)(this._self + ": has no fault handler for " + this._fault.getFaultName() + "; scope will propagate FAULT!"));
                        }
                        this._self.parent.completed(this._fault, this._compensations);
                    } else {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)(this._self + ": has a fault handler for " + this._fault.getFaultName() + ": " + catchBlock));
                        }
                        linksNeedingDPE.removeAll(catchBlock.outgoingLinks);
                        OdeInternalInstance ntive = this.getBpelRuntime();
                        ActivityInfo faultHandlerActivity = new ActivityInfo(this.genMonotonic(), catchBlock, (TerminationChannel)this.newChannel(TerminationChannel.class, "FH"), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class, "FH"));
                        ScopeFrame faultHandlerScopeFrame = new ScopeFrame(catchBlock, ntive.createScopeInstance(this._scopeFrame.scopeInstanceId, catchBlock), this._scopeFrame, this._compensations, this._fault);
                        if (catchBlock.faultVariable != null) {
                            try {
                                VariableInstance vinst = faultHandlerScopeFrame.resolve(catchBlock.faultVariable);
                                this.initializeVariable(vinst, this._fault.getFaultMessage());
                                VariableModificationEvent se = new VariableModificationEvent(vinst.declaration.name);
                                se.setNewValue((Node)this._fault.getFaultMessage());
                                if (((SCOPE)SCOPE.this)._oscope.debugInfo != null) {
                                    se.setLineNo(((SCOPE)SCOPE.this)._oscope.debugInfo.startLine);
                                }
                                this.sendEvent((ScopeEvent)se);
                            }
                            catch (Exception ex) {
                                __log.fatal((Object)ex);
                                throw new InvalidProcessException(ex);
                            }
                        }
                        ACTIVE.instance((JacobRunnable)new SCOPE(faultHandlerActivity, faultHandlerScopeFrame, SCOPE.this._linkFrame));
                        ACTIVE.object((ChannelListener)new ParentScopeChannelListener(faultHandlerActivity.parent){
                            private static final long serialVersionUID = -6009078124717125270L;

                            @Override
                            public void compensate(OScope scope, SynchChannel ret) {
                                throw new AssertionError((Object)"received compensate request!");
                            }

                            @Override
                            public void completed(FaultData fault, Set<CompensationHandler> compensations) {
                                for (CompensationHandler compensation : compensations) {
                                    compensation.compChannel.forget();
                                }
                                ACTIVE.this._self.parent.completed(fault, CompensationHandler.emptySet());
                            }

                            @Override
                            public void cancelled() {
                                this.completed(null, CompensationHandler.emptySet());
                            }

                            @Override
                            public void failure(String reason, Element data) {
                                this.completed(null, CompensationHandler.emptySet());
                            }
                        });
                    }
                } else if (((SCOPE)SCOPE.this)._oscope.compensationHandler != null) {
                    CompensationHandler compensationHandler = new CompensationHandler(this._scopeFrame, (CompensationChannel)this.newChannel(CompensationChannel.class), this._startTime, System.currentTimeMillis());
                    this._self.parent.completed(null, Collections.singleton(compensationHandler));
                    ACTIVE.instance((JacobRunnable)new COMPENSATIONHANDLER_(compensationHandler, this._compensations));
                } else {
                    this._self.parent.completed(null, this._compensations);
                }
                this.dpe(linksNeedingDPE);
            }
        }

        private void terminateEventHandlers() {
            for (EventHandlerInfo ehi : SCOPE.this._eventHandlers) {
                if (ehi.terminateRequested || ehi.stopRequested) continue;
                ((TerminationChannel)ACTIVE.replication((Channel)ehi.tc)).terminate();
                ehi.terminateRequested = true;
            }
        }

        private void stopEventHandlers() {
            for (EventHandlerInfo ehi : SCOPE.this._eventHandlers) {
                if (ehi.stopRequested || ehi.terminateRequested) continue;
                ehi.cc.stop();
                ehi.stopRequested = true;
            }
        }
    }
}

