/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v1.OPartnerLink;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopeFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ScopeFrame.class);
    final OScope oscope;
    final ScopeFrame parent;
    final Long scopeInstanceId;
    Set<CompensationHandler> availableCompensations;
    private FaultData _faultData;

    ScopeFrame(OScope scopeDef, Long scopeInstanceId, ScopeFrame parent, Set<CompensationHandler> visibleCompensationHandlers, FaultData fault) {
        this(scopeDef, scopeInstanceId, parent, visibleCompensationHandlers);
        this._faultData = fault;
    }

    public ScopeFrame(OScope scopeDef, Long scopeInstanceId, ScopeFrame parent, Set<CompensationHandler> visibleCompensationHandlers) {
        this.oscope = scopeDef;
        this.scopeInstanceId = scopeInstanceId;
        this.parent = parent;
        this.availableCompensations = visibleCompensationHandlers;
    }

    public ScopeFrame find(OScope scope) {
        if (this.oscope.name.equals(scope.name)) {
            return this;
        }
        return this.parent != null ? this.parent.find(scope) : null;
    }

    public VariableInstance resolve(OScope.Variable variable) {
        ScopeFrame scopeFrame = this.find(variable.declaringScope);
        if (scopeFrame == null) {
            return null;
        }
        return new VariableInstance(scopeFrame.scopeInstanceId, variable);
    }

    public CorrelationSetInstance resolve(OScope.CorrelationSet cset) {
        return new CorrelationSetInstance(this.find((OScope)cset.declaringScope).scopeInstanceId, cset);
    }

    public PartnerLinkInstance resolve(OPartnerLink partnerLink) {
        return new PartnerLinkInstance(this.find((OScope)partnerLink.declaringScope).scopeInstanceId, partnerLink);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{ScopeFrame: o=");
        buf.append(this.oscope);
        buf.append(", id=");
        buf.append(this.scopeInstanceId);
        if (this.availableCompensations != null) {
            buf.append(", avComps=");
            buf.append(this.availableCompensations);
        }
        if (this._faultData != null) {
            buf.append(", fault=");
            buf.append(this._faultData);
        }
        buf.append('}');
        return buf.toString();
    }

    public FaultData getFault() {
        if (this._faultData != null) {
            return this._faultData;
        }
        if (this.parent != null) {
            return this.parent.getFault();
        }
        return null;
    }

    public void fillEventInfo(ScopeEvent event) {
        ScopeFrame currentScope = this;
        ArrayList<String> parentNames = new ArrayList<String>();
        while (currentScope != null) {
            parentNames.add(currentScope.oscope.name);
            currentScope = currentScope.parent;
        }
        event.setParentScopesNames(parentNames);
        if (this.parent != null) {
            event.setParentScopeId(this.parent.scopeInstanceId);
        }
        event.setScopeId(this.scopeInstanceId);
        event.setScopeName(this.oscope.name);
        event.setScopeDeclerationId(this.oscope.getId());
        if (event.getLineNo() == -1 && this.oscope.debugInfo != null) {
            event.setLineNo(this.oscope.debugInfo.startLine);
        }
    }
}

