/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OWait;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TimerResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.utils.xsd.Duration;

class WAIT
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(WAIT.class);

    WAIT(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
    }

    public final void run() {
        Date dueDate = null;
        try {
            dueDate = this.getDueDate();
        }
        catch (FaultException e) {
            __log.error((Object)("Fault while calculating due date: " + e.getQName() + "; Reason: " + e.getMessage()));
            this._self.parent.completed(this.createFault(e.getQName(), this._self.o), CompensationHandler.emptySet());
            return;
        }
        if (dueDate.getTime() > System.currentTimeMillis()) {
            final TimerResponseChannel timerChannel = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
            this.getBpelRuntime().registerTimer(timerChannel, dueDate);
            WAIT.object((boolean)false, (Set)new TimerResponseChannelListener(timerChannel){
                private static final long serialVersionUID = 3120518305645437327L;

                public void onTimeout() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                }

                public void onCancel() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(this._self.self){
                private static final long serialVersionUID = -2791243270691333946L;

                public void terminate() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                    1.object((ChannelListener)new TimerResponseChannelListener(timerChannel){
                        private static final long serialVersionUID = 677746737897792929L;

                        public void onTimeout() {
                        }

                        public void onCancel() {
                        }
                    });
                }
            }));
        } else {
            this._self.parent.completed(null, CompensationHandler.emptySet());
        }
    }

    protected Date getDueDate() throws FaultException {
        OWait wait = (OWait)this._self.o;
        assert (wait.hasFor() || wait.hasUntil());
        EvaluationContext evalCtx = this.getEvaluationContext();
        Date dueDate = null;
        if (wait.hasFor()) {
            Calendar cal = Calendar.getInstance();
            Duration duration = this.getBpelRuntime().getExpLangRuntime().evaluateAsDuration(wait.forExpression, evalCtx);
            duration.addTo(cal);
            dueDate = cal.getTime();
        } else if (wait.hasUntil()) {
            Calendar cal = this.getBpelRuntime().getExpLangRuntime().evaluateAsDate(wait.untilExpression, evalCtx);
            dueDate = cal.getTime();
        } else {
            throw new AssertionError((Object)"Static checks failed to find bad WaitActivity!");
        }
        if (dueDate == null) {
            dueDate = new Date();
        }
        return dueDate;
    }
}

