/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.dom.NodeWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v1.xpath10.WrappedFaultException;
import org.apache.ode.bpel.rtrep.v1.xpath10.XslRuntimeUriResolver;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class JaxenContexts
implements FunctionContext,
VariableContext {
    private static final Log __log = LogFactory.getLog(JaxenContexts.class);
    private static final FunctionContext __defaultXPathFunctions = XPathFunctionContext.getInstance();
    private OXPath10Expression _oxpath;
    private EvaluationContext _xpathEvalCtx;
    private Function _getVariableProperty;
    private Function _getVariableData;
    private Function _getLinkStatus;
    private Function _doXslTransform;
    private Map _extensionFunctions;

    public JaxenContexts(OXPath10Expression oxpath, Map extensionFunctions, EvaluationContext xpathEvalCtx) {
        this._oxpath = oxpath;
        this._xpathEvalCtx = xpathEvalCtx;
        this._extensionFunctions = extensionFunctions;
        this._getVariableProperty = new BpelVariablePropertyFunction();
        this._getVariableData = new BpelVariableDataFunction();
        this._getLinkStatus = new GetLinkStatusFunction();
        this._doXslTransform = new DoXslTransformFunction();
    }

    public Function getFunction(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("getFunction(" + namespaceURI + "," + prefix + "," + localName));
        }
        if (namespaceURI != null) {
            Function f;
            QName fnQName = new QName(namespaceURI, localName);
            if (fnQName.equals(this._oxpath.qname_getVariableProperty)) {
                return this._getVariableProperty;
            }
            if (fnQName.equals(this._oxpath.qname_getVariableData)) {
                return this._getVariableData;
            }
            if (fnQName.equals(this._oxpath.qname_getLinkStatus)) {
                return this._getLinkStatus;
            }
            if (this._oxpath instanceof OXPath10ExpressionBPEL20) {
                OXPath10ExpressionBPEL20 oxpath20 = (OXPath10ExpressionBPEL20)this._oxpath;
                if (fnQName.equals(oxpath20.qname_doXslTransform)) {
                    return this._doXslTransform;
                }
            }
            if ((f = (Function)this._extensionFunctions.get(localName)) != null) {
                return f;
            }
        }
        return __defaultXPathFunctions.getFunction(null, prefix, localName);
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        String partName;
        String varName;
        if (!(this._oxpath instanceof OXPath10ExpressionBPEL20)) {
            throw new IllegalStateException("XPath variables not supported for bpel 1.1");
        }
        if ("ode".equals(prefix) && "pid".equals(localName)) {
            return this._xpathEvalCtx.getProcessId();
        }
        OXPath10ExpressionBPEL20 expr = (OXPath10ExpressionBPEL20)this._oxpath;
        if (expr.isJoinExpression) {
            OLink olink = this._oxpath.links.get(localName);
            try {
                return this._xpathEvalCtx.isLinkActive(olink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException e) {
                throw new WrappedFaultException.JaxenUnresolvableException(e);
            }
        }
        int dotloc = localName.indexOf(46);
        if (dotloc == -1) {
            varName = localName;
            partName = null;
        } else {
            varName = localName.substring(0, dotloc);
            partName = localName.substring(dotloc + 1);
        }
        OScope.Variable variable = this._oxpath.vars.get(varName);
        OMessageVarType.Part part = partName == null ? null : ((OMessageVarType)variable.type).parts.get(partName);
        try {
            Node variableNode = this._xpathEvalCtx.readVariable(variable, part);
            if (variableNode == null) {
                throw new WrappedFaultException.JaxenUnresolvableException(new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown variable " + localName));
            }
            OVarType type = variable.type;
            if (type instanceof OMessageVarType) {
                OMessageVarType.Part typePart = ((OMessageVarType)type).parts.get(partName);
                if (typePart == null) {
                    throw new WrappedFaultException.JaxenUnresolvableException(new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown part " + partName + " for variable " + localName));
                }
                type = typePart.type;
            }
            if (this._xpathEvalCtx.narrowTypes() && type instanceof OXsdTypeVarType && ((OXsdTypeVarType)type).simple) {
                return variableNode.getTextContent();
            }
            return variableNode;
        }
        catch (FaultException e) {
            __log.error((Object)"bpws:getVariableValue threw FaultException", (Throwable)e);
            throw new WrappedFaultException.JaxenUnresolvableException(e);
        }
    }

    class DoXslTransformFunction
    implements Function {
        DoXslTransformFunction() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            Object result;
            URI xslUri;
            Element varElmt;
            assert (args.size() >= 2);
            assert (args.size() % 2 == 0);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + context + " args=" + args + ")"));
            }
            if (!(JaxenContexts.this._oxpath instanceof OXPath10ExpressionBPEL20)) {
                throw new IllegalStateException("XPath function bpws:doXslTransform not supported in BPEL 1.1!");
            }
            try {
                if (args.get(1) instanceof List) {
                    List elmts = (List)args.get(1);
                    if (elmts.size() != 1) {
                        throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
                    }
                    varElmt = (Element)elmts.get(0);
                } else {
                    varElmt = args.get(1) instanceof NodeWrapper ? (Element)((NodeWrapper)args.get(1)).getUnderlyingNode() : (Element)args.get(1);
                }
            }
            catch (ClassCastException e) {
                throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            try {
                xslUri = new URI((String)args.get(0));
            }
            catch (URISyntaxException use) {
                throw new FunctionCallException("First parameter of the bpws:doXslTransform isn't a valid URI!", (Exception)use);
            }
            OXslSheet xslSheet = ((JaxenContexts)JaxenContexts.this)._oxpath.xslSheets.get(xslUri);
            if (xslSheet == null) {
                throw new FunctionCallException("Couldn't find the XSL sheet " + args.get(0) + ", process compilation or deployment was probably incomplete!");
            }
            if (!(varElmt instanceof Element)) {
                throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            HashMap parametersMap = null;
            if (args.size() > 2) {
                parametersMap = new HashMap();
                for (int idx = 2; idx < args.size(); idx += 2) {
                    QName keyQName = ((JaxenContexts)JaxenContexts.this)._oxpath.namespaceCtx.derefQName((String)args.get(idx));
                    parametersMap.put(keyQName, args.get(idx + 1));
                }
            }
            Document varDoc = DOMUtils.newDocument();
            varDoc.appendChild(varDoc.importNode(varElmt, true));
            DOMSource source = new DOMSource(varDoc);
            XslRuntimeUriResolver resolver = new XslRuntimeUriResolver(JaxenContexts.this._oxpath, JaxenContexts.this._xpathEvalCtx.getBaseResourceURI());
            XslTransformHandler.getInstance().cacheXSLSheet(JaxenContexts.this._xpathEvalCtx.getBaseResourceURI(), xslUri, xslSheet.sheetBody, (URIResolver)resolver);
            try {
                result = XslTransformHandler.getInstance().transform(JaxenContexts.this._xpathEvalCtx.getBaseResourceURI(), xslUri, (Source)source, parametersMap, (URIResolver)resolver);
            }
            catch (Exception e) {
                throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnSubLanguageExecutionFault, e.toString()));
            }
            return result;
        }
    }

    class GetLinkStatusFunction
    implements Function {
        GetLinkStatusFunction() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            assert (args.size() == 1);
            OLink olink = ((JaxenContexts)JaxenContexts.this)._oxpath.links.get(args.get(0));
            try {
                return JaxenContexts.this._xpathEvalCtx.isLinkActive(olink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException e) {
                __log.error((Object)("bpws:getLinkStatus(" + args + ") threw FaultException"), (Throwable)e);
                throw new WrappedFaultException.JaxenFunctionException(e);
            }
        }
    }

    class BpelVariablePropertyFunction
    implements Function {
        BpelVariablePropertyFunction() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() != 2) {
                throw new FunctionCallException("missing required arguments");
            }
            OScope.Variable var = ((JaxenContexts)JaxenContexts.this)._oxpath.vars.get(args.get(0));
            OProcess.OProperty property = ((JaxenContexts)JaxenContexts.this)._oxpath.properties.get(args.get(1));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("function call:'bpws:getVariableProperty(" + var + "," + property + ")'"));
            }
            try {
                return JaxenContexts.this._xpathEvalCtx.readMessageProperty(var, property);
            }
            catch (FaultException e) {
                __log.error((Object)("bpws:getVariableProperty(" + args + ") threw FaultException"), (Throwable)e);
                throw new WrappedFaultException.JaxenFunctionException(e);
            }
        }
    }

    class BpelVariableDataFunction
    implements Function {
        BpelVariableDataFunction() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + context + " args=" + args + ")"));
            }
            String varname = (String)args.get(0);
            String partname = args.size() > 1 ? (String)args.get(1) : null;
            String xpathStr = args.size() > 2 ? (String)args.get(2) : null;
            OXPath10Expression.OSigGetVariableData sig = JaxenContexts.this._oxpath.resolveGetVariableDataSig(varname, partname, xpathStr);
            if (sig == null) {
                String msg = "InternalError: Attempt to use an unknown getVariableData signature: " + args;
                if (__log.isFatalEnabled()) {
                    __log.fatal((Object)msg);
                }
                throw new FunctionCallException(msg);
            }
            try {
                Node ret = JaxenContexts.this._xpathEvalCtx.readVariable(sig.variable, sig.part);
                if (sig.location != null) {
                    ret = JaxenContexts.this._xpathEvalCtx.evaluateQuery(ret, sig.location);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("bpws:getVariableData(" + args + ")' = " + ret));
                }
                return ret;
            }
            catch (FaultException e) {
                __log.error((Object)("bpws:getVariableData(" + args + ") threw FaultException"), (Throwable)e);
                throw new WrappedFaultException.JaxenFunctionException(e);
            }
        }
    }
}

