/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.OLValueExpression;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.utils.NSContext;

public class OXPath10Expression
extends OLValueExpression
implements Serializable {
    private static final long serialVersionUID = -1L;
    public HashMap<String, OScope.Variable> vars = new HashMap();
    public final HashMap<String, OProcess.OProperty> properties = new HashMap();
    public final HashMap<String, OLink> links = new HashMap();
    public final HashMap<URI, OXslSheet> xslSheets = new HashMap();
    private final HashMap<SigGetVariableData, OSigGetVariableData> _getVariableDataSigs = new HashMap();
    public String xpath;
    public NSContext namespaceCtx;
    public final QName qname_getVariableData;
    public final QName qname_getVariableProperty;
    public final QName qname_getLinkStatus;

    public OXPath10Expression(OProcess owner, QName qname_getVariableData, QName qname_getVariableProperty, QName qname_getLinkStatus) {
        super(owner);
        this.qname_getLinkStatus = qname_getLinkStatus;
        this.qname_getVariableData = qname_getVariableData;
        this.qname_getVariableProperty = qname_getVariableProperty;
    }

    public OSigGetVariableData resolveGetVariableDataSig(String varname, String partname, String location) {
        SigGetVariableData key = new SigGetVariableData(varname, partname, location);
        return this._getVariableDataSigs.get(key);
    }

    public void addGetVariableDataSig(String varname, String partname, String location, OSigGetVariableData compiled) {
        this._getVariableDataSigs.put(new SigGetVariableData(varname, partname, location), compiled);
    }

    public String toString() {
        return "{OXPath10Expression " + this.xpath + "}";
    }

    public OScope.Variable getVariable() {
        if (this.vars.size() == 0) {
            throw new IllegalStateException("LValue must have one variable reference.");
        }
        for (String varName : this.vars.keySet()) {
            if (!this.xpath.substring(1, this.xpath.length()).startsWith(varName)) continue;
            return this.vars.get(varName);
        }
        throw new IllegalStateException("Either the expression doesn't start with a variable reference or the reference is unknow.");
    }

    public static final class OSigGetVariableData
    extends OBase {
        private static final long serialVersionUID = -1L;
        public final OScope.Variable variable;
        public final OMessageVarType.Part part;
        public final OExpression location;

        public OSigGetVariableData(OProcess owner, OScope.Variable variable, OMessageVarType.Part part, OExpression location) {
            super(owner);
            this.variable = variable;
            this.part = part;
            this.location = location;
        }
    }

    private static final class SigGetVariableData
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private final String varname;
        private final String partname;
        private final String location;

        private SigGetVariableData(String varname, String partname, String location) {
            this.varname = varname;
            this.partname = partname;
            this.location = location;
        }

        public boolean equals(Object obj) {
            SigGetVariableData other = (SigGetVariableData)obj;
            if (!(this.varname == null || other.varname != null && this.varname.equals(other.varname))) {
                return false;
            }
            if (!(this.partname == null || other.partname != null && this.partname.equals(other.partname))) {
                return false;
            }
            return this.location == null || other.location != null && this.location.equals(other.location);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.varname != null) {
                hashCode ^= this.varname.hashCode();
            }
            if (this.partname != null) {
                hashCode ^= this.partname.hashCode();
            }
            if (this.location != null) {
                hashCode ^= this.location.hashCode();
            }
            return hashCode;
        }
    }
}

