/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10.jaxp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v1.xpath10.XslRuntimeUriResolver;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);
    private EvaluationContext _ectx;
    private OXPath10Expression _oxpath;

    public JaxpFunctionResolver(EvaluationContext ectx, OXPath10Expression oxpath) {
        this._ectx = ectx;
        this._oxpath = oxpath;
    }

    public XPathFunction resolveFunction(QName functionName, int arity) {
        __log.debug((Object)("JAXP runtime: Resolving function " + functionName));
        String namespaceURI = functionName.getNamespaceURI();
        if (namespaceURI == null) {
            throw new NullPointerException("Undeclared namespace for " + functionName);
        }
        if (namespaceURI.equals("http://schemas.xmlsoap.org/ws/2003/03/business-process/") || namespaceURI.equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || namespaceURI.equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable")) {
            String localName = functionName.getLocalPart();
            if ("getVariableData".equals(localName)) {
                return new GetVariableData();
            }
            if ("getVariableProperty".equals(localName)) {
                return new GetVariableProperty();
            }
            if ("getLinkStatus".equals(localName)) {
                return new GetLinkStatus();
            }
            if ("doXslTransform".equals(localName)) {
                return new DoXslTransform();
            }
            throw new NullPointerException("Unknown BPEL function: " + functionName);
        }
        return null;
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            Object result;
            URI xslUri;
            Element varElmt;
            if (args.size() < 2 || args.size() % 2 != 0) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "doXslTransformInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            if (!(JaxpFunctionResolver.this._oxpath instanceof OXPath10ExpressionBPEL20)) {
                throw new IllegalStateException("XPath function bpws:doXslTransform not supported in BPEL 1.1!");
            }
            try {
                if (args.get(1) instanceof List) {
                    List elmts = (List)args.get(1);
                    if (elmts.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
                    }
                    varElmt = (Element)elmts.get(0);
                } else {
                    varElmt = (Element)args.get(1);
                }
            }
            catch (ClassCastException e) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            try {
                xslUri = new URI((String)args.get(0));
            }
            catch (URISyntaxException use) {
                throw new XPathFunctionException("First parameter of the bpws:doXslTransform isn't a valid URI!");
            }
            OXslSheet xslSheet = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.xslSheets.get(xslUri);
            if (xslSheet == null) {
                throw new XPathFunctionException("Couldn't find the XSL sheet " + args.get(0) + ", process compilation or deployment was probably incomplete!");
            }
            if (!(varElmt instanceof Element)) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            HashMap parametersMap = null;
            if (args.size() > 2) {
                parametersMap = new HashMap();
                for (int idx = 2; idx < args.size(); idx += 2) {
                    QName keyQName = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.namespaceCtx.derefQName((String)args.get(idx));
                    Object paramElmt = args.get(idx + 1) instanceof List ? ((List)args.get(idx + 1)).get(0) : args.get(idx + 1);
                    parametersMap.put(keyQName, paramElmt);
                }
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Executing XSL sheet " + args.get(0) + " on element " + DOMUtils.domToString((Node)varElmt)));
            }
            Document varDoc = DOMUtils.newDocument();
            varDoc.appendChild(varDoc.importNode(varElmt, true));
            DOMSource source = new DOMSource(varDoc);
            XslRuntimeUriResolver resolver = new XslRuntimeUriResolver(JaxpFunctionResolver.this._oxpath, JaxpFunctionResolver.this._ectx.getBaseResourceURI());
            XslTransformHandler.getInstance().cacheXSLSheet(JaxpFunctionResolver.this._ectx.getBaseResourceURI(), xslUri, xslSheet.sheetBody, (URIResolver)resolver);
            try {
                result = XslTransformHandler.getInstance().transform(JaxpFunctionResolver.this._ectx.getBaseResourceURI(), xslUri, (Source)source, parametersMap, (URIResolver)resolver);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSubLanguageExecutionFault, e.toString()));
            }
            if (result instanceof Node) {
                return ((Node)result).getChildNodes();
            }
            return result;
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getVariablePropertyInvalidSource"), "Missing required arguments"));
            }
            OScope.Variable var = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.vars.get(args.get(0));
            OProcess.OProperty property = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.properties.get(args.get(1));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("function call:'bpws:getVariableProperty(" + var + "," + property + ")'"));
            }
            try {
                return JaxpFunctionResolver.this._ectx.readMessageProperty(var, property);
            }
            catch (FaultException e) {
                throw new XPathFunctionException(e);
            }
        }
    }

    public class GetVariableData
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            String varname = (String)args.get(0);
            String partname = args.size() > 1 ? (String)args.get(1) : null;
            String xpathStr = args.size() > 2 ? (String)args.get(2) : null;
            OXPath10Expression.OSigGetVariableData sig = JaxpFunctionResolver.this._oxpath.resolveGetVariableDataSig(varname, partname, xpathStr);
            if (sig == null) {
                String msg = "InternalError: Attempt to use an unknown getVariableData signature: " + args;
                if (__log.isFatalEnabled()) {
                    __log.fatal((Object)msg);
                }
                throw new XPathFunctionException(msg);
            }
            try {
                Node ret = JaxpFunctionResolver.this._ectx.readVariable(sig.variable, sig.part);
                if (sig.location != null) {
                    ret = JaxpFunctionResolver.this._ectx.evaluateQuery(ret, sig.location);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("bpws:getVariableData(" + args + ")' = " + ret));
                }
                return ret;
            }
            catch (FaultException e) {
                __log.error((Object)("bpws:getVariableData(" + args + ") threw FaultException"));
                throw new XPathFunctionException(e);
            }
        }
    }

    public class GetLinkStatus
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getLinkStatusInvalidSource"), "Illegal Arguments"));
            }
            OLink olink = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.links.get(args.get(0));
            try {
                return JaxpFunctionResolver.this._ectx.isLinkActive(olink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException e) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getLinkStatusInvalidSource"), (Throwable)e));
            }
        }
    }
}

