/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10.jaxp;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.JaxpFunctionResolver;
import org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v1.xpath10.jaxp.WrappedFaultException;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JaxpXPath10ExpressionRuntime
implements ExpressionLanguageRuntime {
    private static final Log __log = LogFactory.getLog(JaxpXPath10ExpressionRuntime.class);

    public void initialize(Map properties) throws ConfigurationException {
        TransformerFactory trsf = TransformerFactory.newInstance();
        __log.debug((Object)("JAXP runtime: TransformerFactory impl = " + trsf.getClass()));
        XslTransformHandler.getInstance().setTransformerFactory(trsf);
    }

    public String evaluateAsString(OExpression cexp, EvaluationContext ctx) throws FaultException {
        return (String)this.evaluate(cexp, ctx, XPathConstants.STRING);
    }

    public boolean evaluateAsBoolean(OExpression cexp, EvaluationContext ctx) throws FaultException {
        return (Boolean)this.evaluate(cexp, ctx, XPathConstants.BOOLEAN);
    }

    public Number evaluateAsNumber(OExpression cexp, EvaluationContext ctx) throws FaultException {
        return (Number)this.evaluate(cexp, ctx, XPathConstants.NUMBER);
    }

    public List evaluate(OExpression cexp, EvaluationContext ctx) throws FaultException {
        List<Node> result;
        ArrayList<String> someRes = null;
        try {
            someRes = this.evaluate(cexp, ctx, XPathConstants.NODESET);
        }
        catch (FaultException ex) {
            try {
                ArrayList<String> resultList = new ArrayList<String>(1);
                resultList.add(this.evaluateAsString(cexp, ctx));
                someRes = resultList;
            }
            catch (Exception ex2) {
                throw ex;
            }
        }
        if (someRes instanceof List) {
            result = (ArrayList<Node>)someRes;
            __log.debug((Object)("Returned list of size " + result.size()));
            if (result.size() == 1 && !(result.get(0) instanceof Node)) {
                Object simpleType = result.get(0);
                String textVal = simpleType instanceof Date ? ISO8601DateParser.format((Date)((Date)simpleType)) : simpleType.toString();
                Document d = DOMUtils.newDocument();
                Element wrapper = d.createElement("wrapper");
                Text text = d.createTextNode(textVal);
                wrapper.appendChild(text);
                d.appendChild(wrapper);
                result = Collections.singletonList(text);
            }
        } else if (someRes instanceof NodeList) {
            NodeList retVal = (NodeList)((Object)someRes);
            __log.debug((Object)("Returned node list of size " + retVal.getLength()));
            result = new ArrayList<Node>(retVal.getLength());
            for (int m = 0; m < retVal.getLength(); ++m) {
                Node val = retVal.item(m);
                if (val.getNodeType() == 9) {
                    val = ((Document)val).getDocumentElement();
                }
                result.add(val);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Node evaluateNode(OExpression cexp, EvaluationContext ctx) throws FaultException {
        List retVal = this.evaluate(cexp, ctx);
        if (retVal.size() == 0) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "No results for expression: " + cexp);
        }
        if (retVal.size() > 1) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + cexp);
        }
        return (Node)retVal.get(0);
    }

    public Calendar evaluateAsDate(OExpression cexp, EvaluationContext context) throws FaultException {
        List literal = DOMUtils.toList((Object)this.evaluate(cexp, context, XPathConstants.NODESET));
        if (literal.size() == 0) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "No results for expression: " + cexp);
        }
        if (literal.size() > 1) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + cexp);
        }
        Object date = literal.get(0);
        if (date instanceof Calendar) {
            return (Calendar)date;
        }
        if (date instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)date);
            return cal;
        }
        if (date instanceof Element) {
            date = ((Element)date).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal((String)date.toString());
        }
        catch (Exception ex) {
            String errmsg = "Invalid date format: " + literal;
            __log.error((Object)errmsg);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    public Duration evaluateAsDuration(OExpression cexp, EvaluationContext context) throws FaultException {
        String literal = this.evaluateAsString(cexp, context);
        try {
            return new Duration(literal);
        }
        catch (Exception ex) {
            String errmsg = "Invalid duration: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    private Object evaluate(OExpression cexp, EvaluationContext ctx, QName type) throws FaultException {
        try {
            OXPath10Expression oxpath = (OXPath10Expression)cexp;
            __log.debug((Object)("JAXP runtime: evaluating " + oxpath.xpath));
            XPathFactory xpf = XPathFactory.newInstance();
            __log.debug((Object)("JAXP runtime: XPathFactory impl = " + xpf.getClass()));
            XPath xpe = xpf.newXPath();
            xpe.setXPathFunctionResolver(new JaxpFunctionResolver(ctx, oxpath));
            xpe.setXPathVariableResolver(new JaxpVariableResolver(ctx, oxpath));
            xpe.setNamespaceContext((NamespaceContext)oxpath.namespaceCtx);
            XPathExpression expr = xpe.compile(((OXPath10Expression)cexp).xpath);
            Object evalResult = expr.evaluate(ctx.getRootNode() == null ? DOMUtils.newDocument() : ctx.getRootNode(), type);
            if (evalResult != null && __log.isDebugEnabled()) {
                __log.debug((Object)("Expression " + cexp.toString() + " generated result " + evalResult + " - type=" + evalResult.getClass().getName()));
                if (ctx.getRootNode() != null) {
                    __log.debug((Object)("Was using context node " + DOMUtils.domToString((Node)ctx.getRootNode())));
                }
            }
            return evalResult;
        }
        catch (XPathExpressionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, cause.getMessage(), cause);
        }
        catch (WrappedFaultException wre) {
            __log.debug((Object)"Could not evaluate expression because of ", (Throwable)wre);
            throw (FaultException)wre.getCause();
        }
        catch (Throwable t) {
            __log.debug((Object)"Could not evaluate expression because of ", t);
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.getMessage(), t);
        }
    }
}

