/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath20;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v1.xpath20.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v1.xpath20.XslRuntimeUriResolver;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.URITemplate;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);
    private EvaluationContext _ectx;
    private OXPath20ExpressionBPEL20 _oxpath;

    public JaxpFunctionResolver(EvaluationContext ectx, OXPath20ExpressionBPEL20 oxpath) {
        this._ectx = ectx;
        this._oxpath = oxpath;
    }

    public XPathFunction resolveFunction(QName functionName, int arity) {
        __log.debug((Object)("Resolving function " + functionName));
        if (functionName.getNamespaceURI() == null) {
            throw new NullPointerException("Undeclared namespace for " + functionName);
        }
        if (functionName.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || functionName.getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable")) {
            String localName = functionName.getLocalPart();
            if ("getVariableData".equals(localName)) {
                return new GetVariableData();
            }
            if ("getVariableProperty".equals(localName)) {
                return new GetVariableProperty();
            }
            if ("getLinkStatus".equals(localName)) {
                return new GetLinkStatus();
            }
            if ("doXslTransform".equals(localName)) {
                return new DoXslTransform();
            }
            throw new NullPointerException("Unknown BPEL function: " + functionName);
        }
        if (functionName.getNamespaceURI().equals("http://www.apache.org/ode/type/extension")) {
            String localName = functionName.getLocalPart();
            if ("split-to-elements".equals(localName) || "splitToElements".equals(localName)) {
                return new SplitToElements();
            }
            if ("combine-url".equals(localName) || "combineUrl".equals(localName)) {
                return new CombineUrl();
            }
            if ("compose-url".equals(localName) || "composeUrl".equals(localName)) {
                return new ComposeUrl();
            }
            if ("expand-template".equals(localName) || "expandTemplate".equals(localName)) {
                return new ComposeUrl(true, "expandTemplateInvalidSource");
            }
            if ("dom-to-string".equals(localName) || "domToString".equals(localName)) {
                return new DomToString();
            }
            if ("insert-after".equals(localName)) {
                return new InsertAfter();
            }
            if ("insert-as-first-into".equals(localName)) {
                return new InsertAsFirstInto();
            }
            if ("insert-as-last-into".equals(localName)) {
                return new InsertAsLastInto();
            }
            if ("insert-before".equals(localName)) {
                return new InsertBefore();
            }
            if ("delete".equals(localName)) {
                return new Delete();
            }
            if ("rename".equals(localName)) {
                return new Rename();
            }
            if ("process-property".equals(localName)) {
                return new ProcessProperty();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        public static String extractString(Object arg) throws IllegalArgumentException {
            String res = null;
            try {
                Node node = null;
                if (arg instanceof List) {
                    List elmts = (List)arg;
                    if (elmts.size() != 1) {
                        throw new IllegalArgumentException("Parameter MUST point to a string, single element or text node.");
                    }
                    node = (Node)elmts.get(0);
                } else if (arg instanceof NodeWrapper) {
                    node = (Node)((NodeWrapper)arg).getUnderlyingNode();
                } else if (arg instanceof Node) {
                    node = (Node)arg;
                } else {
                    res = (String)arg;
                }
                if (res == null) {
                    if (1 == node.getNodeType()) {
                        res = node.getTextContent().trim();
                    } else if (3 == node.getNodeType()) {
                        res = ((Text)node).getWholeText().trim();
                    }
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Parameter MUST point to a string, single element or text node.", e);
            }
            return res;
        }

        public static int extractInteger(Object arg) throws IllegalArgumentException {
            try {
                return Integer.parseInt(Helper.extractString(arg));
            }
            catch (ClassCastException cce) {
                try {
                    return (int)((IntegerValue)arg).longValue();
                }
                catch (XPathException xpe) {
                    throw new IllegalArgumentException("Parameter MUST point to an integer, single element or text node.", xpe);
                }
                catch (ClassCastException ccce) {
                    throw new IllegalArgumentException("Parameter MUST point to an integer, single element or text node.", ccce);
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Parameter MUST point to an integer, single element or text node.", nfe);
            }
        }

        public static Map<String, String> extractNameValueMap(Element elt) {
            HashMap<String, String> pairs = new HashMap<String, String>();
            for (int i = 0; i < elt.getChildNodes().getLength(); ++i) {
                Node n = elt.getChildNodes().item(i);
                if (n.getNodeType() != 1) continue;
                pairs.put(n.getLocalName(), DOMUtils.getTextContent((Node)n));
            }
            return pairs;
        }

        public static Map<String, String> buildNameValueMap(List args) {
            return Helper.buildNameValueMap(args, 0);
        }

        public static Map<String, String> buildNameValueMap(List args, int begin) {
            HashMap<String, String> pairs = new HashMap<String, String>();
            for (int i = begin; i < args.size(); i += 2) {
                pairs.put(Helper.extractString(args.get(i)), Helper.extractString(args.get(i + 1)));
            }
            return pairs;
        }
    }

    public class ProcessProperty
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "processPropertyInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("process-property call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            QName propertyName = null;
            Element targetElmt = null;
            try {
                if (args.get(0) instanceof List) {
                    List elmts = (List)args.get(0);
                    if (elmts.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:process-property function MUST be passed a single element node."));
                    }
                    if (elmts.get(0) instanceof Element) {
                        targetElmt = (Element)elmts.get(0);
                    } else if (elmts.get(0) instanceof String) {
                        propertyName = new QName((String)elmts.get(0));
                    }
                } else if (args.get(0) instanceof NodeWrapper) {
                    targetElmt = (Element)((NodeWrapper)args.get(0)).getUnderlyingNode();
                } else if (args.get(0) instanceof Element) {
                    targetElmt = (Element)args.get(0);
                } else if (args.get(0) instanceof QNameValue) {
                    QNameValue qNameValue = (QNameValue)args.get(0);
                    propertyName = new QName(qNameValue.getNamespaceURI(), qNameValue.getLocalName(), qNameValue.getPrefix());
                } else if (args.get(0) instanceof String) {
                    String stringValue = (String)args.get(0);
                    if (stringValue.indexOf(":") > 0) {
                        String prefix = stringValue.substring(0, stringValue.indexOf(":"));
                        String localPart = stringValue.substring(stringValue.indexOf(":") + 1);
                        String namespaceUri = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.namespaceCtx.getNamespaceURI(prefix);
                        propertyName = new QName(namespaceUri, localPart, prefix);
                    } else {
                        propertyName = new QName(stringValue);
                    }
                } else if (args.get(0) instanceof QName) {
                    propertyName = (QName)args.get(0);
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                }
                if (propertyName == null && targetElmt != null) {
                    propertyName = new QName(targetElmt.getTextContent());
                }
            }
            catch (IllegalArgumentException e) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + args.get(0), (Throwable)e));
            }
            catch (ClassCastException e) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:process-property function MUST be passed a single element node."));
            }
            return JaxpFunctionResolver.this._ectx.getPropertyValue(propertyName);
        }
    }

    public class Rename
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            Element targetElmt;
            if (args.size() < 2) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "renameInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("rename call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            QName elementQName = null;
            QName elementTypeQName = null;
            try {
                Object qName;
                Element nameElmt;
                QNameValue qNameValue;
                if (args.get(0) instanceof List) {
                    List elmts = (List)args.get(0);
                    if (elmts.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:rename function MUST be passed a single element node."));
                    }
                    targetElmt = (Element)elmts.get(0);
                } else if (args.get(0) instanceof NodeWrapper) {
                    targetElmt = (Element)((NodeWrapper)args.get(0)).getUnderlyingNode();
                } else if (args.get(0) instanceof Element) {
                    targetElmt = (Element)args.get(0);
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                }
                String localName = null;
                String namespaceUri = null;
                String prefix = null;
                if (args.get(1) instanceof QNameValue) {
                    qNameValue = (QNameValue)args.get(1);
                    namespaceUri = qNameValue.getNamespaceURI();
                    localName = qNameValue.getLocalName();
                    prefix = qNameValue.getPrefix();
                } else if (args.get(1) instanceof List) {
                    List elmts = (List)args.get(1);
                    if (elmts.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:rename function MUST be passed a single element node."));
                    }
                    Element nameElmt2 = (Element)elmts.get(0);
                    namespaceUri = nameElmt2.getNamespaceURI();
                    localName = nameElmt2.getLocalName();
                    prefix = nameElmt2.getPrefix();
                } else if (args.get(1) instanceof NodeWrapper) {
                    nameElmt = (Element)((NodeWrapper)args.get(1)).getUnderlyingNode();
                    namespaceUri = nameElmt.getNamespaceURI();
                    localName = nameElmt.getLocalName();
                    prefix = nameElmt.getPrefix();
                } else if (args.get(1) instanceof Element) {
                    nameElmt = (Element)args.get(1);
                    namespaceUri = nameElmt.getNamespaceURI();
                    localName = nameElmt.getLocalName();
                    prefix = nameElmt.getPrefix();
                } else if (args.get(1) instanceof String) {
                    qName = (String)args.get(1);
                    if (((String)qName).contains(":")) {
                        int index = ((String)qName).indexOf(":");
                        prefix = ((String)qName).substring(0, index);
                        localName = ((String)qName).substring(index + 1);
                    } else {
                        localName = qName;
                    }
                } else {
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(1).getClass());
                }
                if (namespaceUri == null) {
                    namespaceUri = targetElmt.lookupNamespaceURI(prefix);
                }
                elementQName = new QName(namespaceUri, localName, prefix);
                if (args.size() > 2) {
                    if (args.get(2) instanceof QNameValue) {
                        qNameValue = (QNameValue)args.get(2);
                        namespaceUri = qNameValue.getNamespaceURI();
                        localName = qNameValue.getLocalName();
                        prefix = qNameValue.getPrefix();
                    } else if (args.get(2) instanceof NodeWrapper) {
                        nameElmt = (Element)((NodeWrapper)args.get(2)).getUnderlyingNode();
                        namespaceUri = nameElmt.getNamespaceURI();
                        localName = nameElmt.getLocalName();
                        prefix = nameElmt.getPrefix();
                    } else if (args.get(2) instanceof Element) {
                        nameElmt = (Element)args.get(2);
                        namespaceUri = nameElmt.getNamespaceURI();
                        localName = nameElmt.getLocalName();
                        prefix = nameElmt.getPrefix();
                    } else if (args.get(2) instanceof String) {
                        qName = (String)args.get(2);
                        if (((String)qName).contains(":")) {
                            int index = ((String)qName).indexOf(":");
                            prefix = ((String)qName).substring(0, index);
                            localName = ((String)qName).substring(index + 1);
                        } else {
                            localName = qName;
                        }
                    } else if (args.get(1) instanceof QName) {
                        qName = (QName)args.get(1);
                        namespaceUri = ((QName)qName).getNamespaceURI();
                        localName = ((QName)qName).getLocalPart();
                        prefix = ((QName)qName).getPrefix();
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + args.get(2).getClass());
                    }
                    if (namespaceUri == null) {
                        namespaceUri = targetElmt.lookupNamespaceURI(prefix);
                    }
                    elementTypeQName = new QName(namespaceUri, localName, prefix);
                }
            }
            catch (IllegalArgumentException e) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + args.get(0), (Throwable)e));
            }
            catch (ClassCastException e) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:rename function MUST be passed a single element node."));
            }
            Element parentElmt = (Element)targetElmt.getParentNode();
            NodeList children = parentElmt.getChildNodes();
            int position = 0;
            while (position < children.getLength() && !children.item(position++).isSameNode(targetElmt)) {
            }
            Element clonedElmt = (Element)parentElmt.cloneNode(true);
            children = clonedElmt.getChildNodes();
            Element renamedElmt = targetElmt.getOwnerDocument().createElementNS(elementQName.getNamespaceURI(), elementQName.getPrefix() + ":" + elementQName.getLocalPart());
            Element originalElmt = (Element)children.item(position - 1);
            children = originalElmt.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                renamedElmt.appendChild(children.item(i));
            }
            clonedElmt.replaceChild(renamedElmt, originalElmt);
            if (elementTypeQName != null) {
                renamedElmt.setAttributeNS("http://www.w3. org/2001/XMLSchema-instance", "xsi:type", elementTypeQName.getPrefix() + ":" + elementTypeQName.getLocalPart());
            }
            return clonedElmt;
        }
    }

    public class Delete
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            ArrayList<Element> targetNodes;
            block13: {
                Object delete;
                if (args.size() < 1 || args.size() > 2) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "deleteInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("delete call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                targetNodes = new ArrayList<Element>();
                delete = args.size() == 2 ? (delete = args.get(1)) : args.get(0);
                try {
                    if (delete instanceof List) {
                        List elmts = (List)delete;
                        targetNodes.addAll(elmts);
                        break block13;
                    }
                    if (delete instanceof NodeWrapper) {
                        targetNodes.add((Element)((NodeWrapper)delete).getUnderlyingNode());
                        break block13;
                    }
                    if (delete instanceof Element) {
                        targetNodes.add((Element)delete);
                        break block13;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + delete.getClass());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + delete, (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:delete function MUST be passed a valid element node."));
                }
            }
            Node parentElmt = null;
            for (Node node : targetNodes) {
                if (parentElmt == null) {
                    parentElmt = (Element)node.getParentNode();
                    continue;
                }
                if (parentElmt.isSameNode((Element)node.getParentNode())) continue;
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:delete function MUST be passed nodes that have the same parent."));
            }
            NodeList children = parentElmt.getChildNodes();
            int[] nArray = new int[targetNodes.size()];
            for (int target = 0; target < nArray.length; ++target) {
                for (int position = 0; position < children.getLength(); ++position) {
                    if (!children.item(position).isSameNode((Node)targetNodes.get(target))) continue;
                    nArray[target] = position;
                }
            }
            Element clonedElmt = (Element)parentElmt.cloneNode(true);
            children = clonedElmt.getChildNodes();
            for (int target = 0; target < nArray.length; ++target) {
                Element deleteElmt = (Element)children.item(nArray[target]);
                clonedElmt.removeChild(deleteElmt);
            }
            return clonedElmt;
        }
    }

    public class InsertAsLastInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            ArrayList<Node> siblingNodes;
            Element targetElmt;
            block16: {
                if (args.size() != 2) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "insertAsLastIntoInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertAsLastInto call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                try {
                    Node childElmt;
                    if (args.get(0) instanceof List) {
                        List elmts = (List)args.get(0);
                        if (elmts.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsLastInto function MUST be passed a single element node."));
                        }
                        targetElmt = (Element)elmts.get(0);
                    } else if (args.get(0) instanceof NodeWrapper) {
                        targetElmt = (Element)((NodeWrapper)args.get(0)).getUnderlyingNode();
                    } else if (args.get(0) instanceof Element) {
                        targetElmt = (Element)args.get(0);
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                    }
                    if (args.get(1) instanceof List) {
                        siblingNodes = (ArrayList<Node>)args.get(1);
                        break block16;
                    }
                    if (args.get(1) instanceof NodeWrapper) {
                        childElmt = (Node)((NodeWrapper)args.get(1)).getUnderlyingNode();
                        siblingNodes = new ArrayList<Node>();
                        siblingNodes.add(childElmt);
                        break block16;
                    }
                    if (args.get(1) instanceof Element) {
                        childElmt = (Node)args.get(1);
                        siblingNodes = new ArrayList();
                        siblingNodes.add(childElmt);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + args.get(0), (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsLastInto function MUST be passed a single element node."));
                }
            }
            Element clonedElmt = (Element)targetElmt.cloneNode(true);
            Document clonedDocument = clonedElmt.getOwnerDocument();
            for (int i = 0; i < siblingNodes.size(); ++i) {
                clonedElmt.appendChild(clonedDocument.importNode((Node)siblingNodes.get(i), true));
            }
            return clonedElmt;
        }
    }

    public class InsertAsFirstInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            ArrayList<Node> siblingNodes;
            Element targetElmt;
            block16: {
                if (args.size() != 2) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "insertAsFirstIntoInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertAsFirstInto call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                try {
                    Node childElmt;
                    if (args.get(0) instanceof List) {
                        List elmts = (List)args.get(0);
                        if (elmts.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsFirstInto function MUST be passed a single element node."));
                        }
                        targetElmt = (Element)elmts.get(0);
                    } else if (args.get(0) instanceof NodeWrapper) {
                        targetElmt = (Element)((NodeWrapper)args.get(0)).getUnderlyingNode();
                    } else if (args.get(0) instanceof Element) {
                        targetElmt = (Element)args.get(0);
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                    }
                    if (args.get(1) instanceof List) {
                        siblingNodes = (ArrayList<Node>)args.get(1);
                        break block16;
                    }
                    if (args.get(1) instanceof NodeWrapper) {
                        childElmt = (Node)((NodeWrapper)args.get(1)).getUnderlyingNode();
                        siblingNodes = new ArrayList<Node>();
                        siblingNodes.add(childElmt);
                        break block16;
                    }
                    if (args.get(1) instanceof Element) {
                        childElmt = (Node)args.get(1);
                        siblingNodes = new ArrayList();
                        siblingNodes.add(childElmt);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + args.get(0), (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAsFirstInto function MUST be passed a single element node."));
                }
            }
            Element clonedElmt = (Element)targetElmt.cloneNode(true);
            Node refChild = clonedElmt.getFirstChild();
            Document clonedDocument = clonedElmt.getOwnerDocument();
            for (int i = 0; i < siblingNodes.size(); ++i) {
                clonedElmt.insertBefore(clonedDocument.importNode((Node)siblingNodes.get(i), true), refChild);
            }
            return clonedElmt;
        }
    }

    public class InsertBefore
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            ArrayList<Node> siblingNodes;
            Element targetElmt;
            block18: {
                if (args.size() < 2 || args.size() > 3) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "insertBeforeInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertBefore call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                Object childArg = null;
                Object siblingsArg = null;
                try {
                    Node childElmt;
                    if (args.size() == 2) {
                        childArg = args.get(0);
                        siblingsArg = args.get(1);
                    } else {
                        childArg = args.get(1);
                        siblingsArg = args.get(2);
                    }
                    if (childArg instanceof List) {
                        List elmts = (List)childArg;
                        targetElmt = (Element)elmts.get(0);
                    } else if (childArg instanceof NodeWrapper) {
                        targetElmt = (Element)((NodeWrapper)childArg).getUnderlyingNode();
                    } else if (childArg instanceof Element) {
                        targetElmt = (Element)childArg;
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + childArg.getClass());
                    }
                    if (siblingsArg instanceof List) {
                        siblingNodes = (ArrayList<Node>)siblingsArg;
                        break block18;
                    }
                    if (siblingsArg instanceof NodeWrapper) {
                        childElmt = (Node)((NodeWrapper)siblingsArg).getUnderlyingNode();
                        siblingNodes = new ArrayList<Node>();
                        siblingNodes.add(childElmt);
                        break block18;
                    }
                    if (siblingsArg instanceof Element) {
                        childElmt = (Node)siblingsArg;
                        siblingNodes = new ArrayList();
                        siblingNodes.add(childElmt);
                        break block18;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + siblingsArg.getClass());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + childArg, (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertBefore function MUST be passed a single element node."));
                }
            }
            Element parentElmt = (Element)targetElmt.getParentNode();
            NodeList children = parentElmt.getChildNodes();
            int position = 0;
            while (position < children.getLength() && !children.item(position++).isSameNode(targetElmt)) {
            }
            Element clonedElmt = (Element)parentElmt.cloneNode(true);
            children = clonedElmt.getChildNodes();
            Node refChild = position <= children.getLength() ? children.item(position - 1) : null;
            Document clonedDocument = clonedElmt.getOwnerDocument();
            for (int i = 0; i < siblingNodes.size(); ++i) {
                clonedElmt.insertBefore(clonedDocument.importNode((Node)siblingNodes.get(i), true), refChild);
            }
            return clonedElmt;
        }
    }

    public class InsertAfter
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            ArrayList<Node> siblingNodes;
            Element targetElmt;
            block18: {
                if (args.size() < 2 || args.size() > 3) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "insertAfterInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertAfter call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                Object childArg = null;
                Object siblingsArg = null;
                try {
                    Node childElmt;
                    if (args.size() == 2) {
                        childArg = args.get(0);
                        siblingsArg = args.get(1);
                    } else {
                        childArg = args.get(1);
                        siblingsArg = args.get(2);
                    }
                    if (childArg instanceof List) {
                        List elmts = (List)childArg;
                        targetElmt = (Element)elmts.get(elmts.size() - 1);
                    } else if (childArg instanceof NodeWrapper) {
                        targetElmt = (Element)((NodeWrapper)childArg).getUnderlyingNode();
                    } else if (childArg instanceof Element) {
                        targetElmt = (Element)childArg;
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + childArg.getClass());
                    }
                    if (siblingsArg instanceof List) {
                        siblingNodes = (ArrayList<Node>)siblingsArg;
                        break block18;
                    }
                    if (siblingsArg instanceof NodeWrapper) {
                        childElmt = (Node)((NodeWrapper)siblingsArg).getUnderlyingNode();
                        siblingNodes = new ArrayList<Node>();
                        siblingNodes.add(childElmt);
                        break block18;
                    }
                    if (siblingsArg instanceof Element) {
                        childElmt = (Node)siblingsArg;
                        siblingNodes = new ArrayList();
                        siblingNodes.add(childElmt);
                        break block18;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + siblingsArg.getClass());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + siblingsArg, (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertAfter function MUST be passed a single element node."));
                }
            }
            Element parentElmt = (Element)targetElmt.getParentNode();
            NodeList children = parentElmt.getChildNodes();
            int position = 0;
            while (position < children.getLength() && !children.item(position++).isSameNode(targetElmt)) {
            }
            Element clonedElmt = (Element)parentElmt.cloneNode(true);
            children = clonedElmt.getChildNodes();
            Node refChild = position < children.getLength() ? children.item(position) : null;
            Document clonedDocument = clonedElmt.getOwnerDocument();
            for (int i = 0; i < siblingNodes.size(); ++i) {
                clonedElmt.insertBefore(clonedDocument.importNode((Node)siblingNodes.get(i), true), refChild);
            }
            return clonedElmt;
        }
    }

    public class InsertInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            ArrayList<Node> childNodes;
            int position;
            Element parentElmt;
            block16: {
                if (args.size() != 3) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "insertIntoInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("insertInto call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                try {
                    Node childElmt;
                    if (args.get(0) instanceof List) {
                        List elmts = (List)args.get(0);
                        if (elmts.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertInto function MUST be passed a single element node."));
                        }
                        parentElmt = (Element)elmts.get(0);
                    } else if (args.get(0) instanceof NodeWrapper) {
                        parentElmt = (Element)((NodeWrapper)args.get(0)).getUnderlyingNode();
                    } else if (args.get(0) instanceof Element) {
                        parentElmt = (Element)args.get(0);
                    } else {
                        throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                    }
                    position = Helper.extractInteger(args.get(1));
                    if (args.get(2) instanceof List) {
                        childNodes = (ArrayList<Node>)args.get(2);
                        break block16;
                    }
                    if (args.get(2) instanceof NodeWrapper) {
                        childElmt = (Node)((NodeWrapper)args.get(2)).getUnderlyingNode();
                        childNodes = new ArrayList<Node>();
                        childNodes.add(childElmt);
                        break block16;
                    }
                    if (args.get(2) instanceof Element) {
                        childElmt = (Node)args.get(2);
                        childNodes = new ArrayList();
                        childNodes.add(childElmt);
                        break block16;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnInvalidExpressionValue, "Invalid argument: URI Template expected. " + args.get(0), (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSelectionFailure, "The bpws:insertInto function MUST be passed a single element node."));
                }
            }
            Element clonedElmt = (Element)parentElmt.cloneNode(true);
            NodeList children = clonedElmt.getChildNodes();
            int childCount = children.getLength();
            Object refChild = null;
            refChild = position <= 1 ? clonedElmt.getFirstChild() : (position == childCount ? clonedElmt.getLastChild() : (position > childCount ? null : children.item(position + 1)));
            for (int i = 0; i < childNodes.size(); ++i) {
                clonedElmt.insertBefore((Node)childNodes.get(i), (Node)refChild);
            }
            return clonedElmt;
        }
    }

    public static class ComposeUrl
    implements XPathFunction {
        boolean preserveUndefinedVar = false;
        String faultLocalPart = "composeUrlInvalidSource";
        QName faultQName;

        public ComposeUrl() {
            this.faultQName = new QName("http://www.apache.org/ode/type/extension", this.faultLocalPart);
        }

        public ComposeUrl(boolean preserveUndefinedVar, String faultLocalPart) {
            this.preserveUndefinedVar = preserveUndefinedVar;
            this.faultLocalPart = faultLocalPart;
            this.faultQName = new QName("http://www.apache.org/ode/type/extension", faultLocalPart);
        }

        public Object evaluate(List args) throws XPathFunctionException {
            Map<String, String> pairs;
            String uriTemplate;
            boolean separareParameteters;
            if (args.size() == 2) {
                separareParameteters = false;
            } else if (args.size() > 2 && args.size() % 2 == 1) {
                separareParameteters = true;
            } else {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Illegal Arguments"));
            }
            try {
                uriTemplate = Helper.extractString(args.get(0));
            }
            catch (IllegalArgumentException e) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument: URI Template expected. " + args.get(0), (Throwable)e));
            }
            if (separareParameteters) {
                try {
                    pairs = Helper.buildNameValueMap(args, 1);
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument", (Throwable)e));
                }
            }
            try {
                Element elt = null;
                if (args.get(1) instanceof List) {
                    List elmts = (List)args.get(1);
                    elt = (Element)elmts.get(0);
                } else if (args.get(1) instanceof Element) {
                    elt = (Element)args.get(1);
                }
                pairs = Helper.extractNameValueMap(elt);
            }
            catch (ClassCastException e) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Expected an element similar too: <foo><name1>value1</name1><name2>value2</name2>...</foo>"));
            }
            try {
                if (this.preserveUndefinedVar) {
                    return URITemplate.expandLazily((String)uriTemplate, pairs);
                }
                return URITemplate.expand((String)uriTemplate, pairs);
            }
            catch (URIException e) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument", (Throwable)e));
            }
            catch (UnsupportedOperationException e) {
                throw new XPathFunctionException(new FaultException(this.faultQName, "Invalid argument", (Throwable)e));
            }
        }
    }

    public static class CombineUrl
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            URL baseURL;
            String relative;
            String base;
            QName FAULT_QNAME = new QName("http://www.apache.org/ode/type/extension", "combineUrlInvalidSource");
            if (args.size() != 2) {
                throw new XPathFunctionException(new FaultException(FAULT_QNAME, "Invalid arguments"));
            }
            try {
                base = Helper.extractString(args.get(0));
            }
            catch (IllegalArgumentException e) {
                throw new XPathFunctionException(new FaultException(FAULT_QNAME, "Invalid argument: " + args.get(0), (Throwable)e));
            }
            try {
                relative = Helper.extractString(args.get(1));
            }
            catch (IllegalArgumentException e) {
                throw new XPathFunctionException(new FaultException(FAULT_QNAME, "Invalid argument: " + args.get(1), (Throwable)e));
            }
            try {
                baseURL = new URL(base);
            }
            catch (MalformedURLException e) {
                throw new XPathFunctionException(new FaultException(FAULT_QNAME, "First parameter [" + base + "] MUST point to a well-formed URL.", (Throwable)e));
            }
            try {
                URL combined = new URL(baseURL, relative);
                return combined.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new XPathFunctionException(new FaultException(FAULT_QNAME, e.getMessage(), (Throwable)e));
            }
        }
    }

    public class SplitToElements
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            String[] strElmts;
            String strToSplit;
            if (args.size() <= 2 || args.size() >= 5) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "splitInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("splitToElements call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            try {
                strToSplit = Helper.extractString(args.get(0));
            }
            catch (IllegalArgumentException e) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "splitInvalidSource"), (Throwable)e));
            }
            String separator = (String)args.get(1);
            String localName = (String)args.get(2);
            String namespace = args.size() == 4 ? (String)args.get(3) : null;
            Document doc = DOMUtils.newDocument();
            Element wrapper = doc.createElement("wrapper");
            doc.appendChild(wrapper);
            for (String strElmt : strElmts = strToSplit.split(separator)) {
                Element elmt = doc.createElementNS(namespace, localName);
                elmt.setTextContent(strElmt.trim());
                wrapper.appendChild(elmt);
            }
            return wrapper;
        }
    }

    public class DomToString
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            Element varElmt;
            block8: {
                if (args.size() != 1) {
                    throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "domToStringInvalidSource"), "Invalid arguments"));
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("domToString call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
                }
                try {
                    if (args.get(0) instanceof List) {
                        List elmts = (List)args.get(0);
                        if (elmts.size() != 1) {
                            throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "The bpws:domToString function MUST be passed a single element node."));
                        }
                        varElmt = (Element)elmts.get(0);
                        break block8;
                    }
                    if (args.get(0) instanceof NodeWrapper) {
                        varElmt = (Element)((NodeWrapper)args.get(0)).getUnderlyingNode();
                        break block8;
                    }
                    if (args.get(0) instanceof Element) {
                        varElmt = (Element)args.get(0);
                        break block8;
                    }
                    throw new XPathFunctionException("Unexpected argument type: " + args.get(0).getClass());
                }
                catch (ClassCastException e) {
                    throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "The bpws:domToString function MUST be passed a single element node."));
                }
            }
            String result = DOMUtils.domToString((Node)varElmt);
            return result;
        }
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            Object result;
            URI xslUri;
            Element varElmt;
            if (args.size() < 2 || args.size() % 2 != 0) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "doXslTransformInvalidSource"), "Invalid arguments"));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            if (!(JaxpFunctionResolver.this._oxpath instanceof OXPath10ExpressionBPEL20)) {
                throw new IllegalStateException("XPath function bpws:doXslTransform not supported in BPEL 1.1!");
            }
            try {
                if (args.get(1) instanceof List) {
                    List elmts = (List)args.get(1);
                    if (elmts.size() != 1) {
                        throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
                    }
                    varElmt = (Element)elmts.get(0);
                } else {
                    varElmt = args.get(1) instanceof NodeWrapper ? (Element)((NodeWrapper)args.get(1)).getUnderlyingNode() : (Element)args.get(1);
                }
            }
            catch (ClassCastException e) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            try {
                xslUri = new URI((String)args.get(0));
            }
            catch (URISyntaxException use) {
                throw new XPathFunctionException("First parameter of the bpws:doXslTransform isn't a valid URI!");
            }
            OXslSheet xslSheet = (OXslSheet)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.xslSheets.get(xslUri);
            if (xslSheet == null) {
                throw new XPathFunctionException("Couldn't find the XSL sheet " + args.get(0) + ", process compilation or deployment was probably incomplete!");
            }
            if (!(varElmt instanceof Element)) {
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            HashMap parametersMap = null;
            if (args.size() > 2) {
                parametersMap = new HashMap();
                for (int idx = 2; idx < args.size(); idx += 2) {
                    Object paramElmt;
                    QName keyQName = ((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.namespaceCtx.derefQName((String)args.get(idx));
                    if (args.get(idx + 1) instanceof NodeWrapper) {
                        Element tmpElmt = (Element)((NodeWrapper)args.get(idx + 1)).getUnderlyingNode();
                        Document paramDoc = DOMUtils.newDocument();
                        paramDoc.appendChild(paramDoc.importNode(tmpElmt, true));
                        paramElmt = paramDoc;
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Passing parameter " + keyQName + " " + DOMUtils.domToString((Node)paramDoc)));
                        }
                    } else {
                        paramElmt = args.get(idx + 1) instanceof List ? ((List)args.get(idx + 1)).get(0) : args.get(idx + 1);
                    }
                    parametersMap.put(keyQName, paramElmt);
                }
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Executing XSL sheet " + args.get(0) + " on element " + DOMUtils.domToString((Node)varElmt)));
            }
            Document varDoc = DOMUtils.newDocument();
            varDoc.appendChild(varDoc.importNode(varElmt, true));
            DOMSource source = new DOMSource(varDoc);
            XslRuntimeUriResolver resolver = new XslRuntimeUriResolver(JaxpFunctionResolver.this._oxpath, JaxpFunctionResolver.this._ectx.getBaseResourceURI());
            XslTransformHandler.getInstance().cacheXSLSheet(JaxpFunctionResolver.this._ectx.getBaseResourceURI(), xslUri, xslSheet.sheetBody, (URIResolver)resolver);
            try {
                result = XslTransformHandler.getInstance().transform(JaxpFunctionResolver.this._ectx.getBaseResourceURI(), xslUri, (Source)source, parametersMap, (URIResolver)resolver);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new XPathFunctionException(new FaultException(((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.getOwner().constants.qnSubLanguageExecutionFault, e.toString()));
            }
            if (result instanceof Node) {
                return ((Node)result).getChildNodes();
            }
            return result;
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getVariablePropertyInvalidSource"), "Missing required arguments"));
            }
            OScope.Variable var = (OScope.Variable)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.vars.get(args.get(0));
            OProcess.OProperty property = (OProcess.OProperty)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.properties.get(args.get(1));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("function call:'bpws:getVariableProperty(" + var + "," + property + ")'"));
            }
            try {
                return JaxpFunctionResolver.this._ectx.readMessageProperty(var, property);
            }
            catch (FaultException e) {
                throw new XPathFunctionException(e);
            }
        }
    }

    public class GetVariableData
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + JaxpFunctionResolver.this._ectx + " args=" + args + ")"));
            }
            String varname = (String)args.get(0);
            String partname = args.size() > 1 ? (String)args.get(1) : null;
            String xpathStr = args.size() > 2 ? (String)args.get(2) : null;
            OXPath10Expression.OSigGetVariableData sig = JaxpFunctionResolver.this._oxpath.resolveGetVariableDataSig(varname, partname, xpathStr);
            if (sig == null) {
                String msg = "InternalError: Attempt to use an unknown getVariableData signature: " + args;
                if (__log.isFatalEnabled()) {
                    __log.fatal((Object)msg);
                }
                throw new XPathFunctionException(msg);
            }
            try {
                Node ret = JaxpFunctionResolver.this._ectx.readVariable(sig.variable, sig.part);
                if (sig.location != null) {
                    ret = JaxpFunctionResolver.this._ectx.evaluateQuery(ret, sig.location);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("bpws:getVariableData(" + args + ")' = " + ret));
                }
                return ret;
            }
            catch (FaultException e) {
                __log.error((Object)("bpws:getVariableData(" + args + ") threw FaultException"));
                throw new XPathFunctionException(e);
            }
        }
    }

    public class GetLinkStatus
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getLinkStatusInvalidSource"), "Illegal Arguments"));
            }
            OLink olink = (OLink)((JaxpFunctionResolver)JaxpFunctionResolver.this)._oxpath.links.get(args.get(0));
            try {
                return JaxpFunctionResolver.this._ectx.isLinkActive(olink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException e) {
                throw new XPathFunctionException(new FaultException(new QName("http://www.apache.org/ode/type/extension", "getLinkStatusInvalidSource"), (Throwable)e));
            }
        }
    }
}

