/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ActivityEnabledEvent;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityExecEndEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.ActivityFailureEvent;
import org.apache.ode.bpel.evt.ActivityRecoveryEvent;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v2.ACTIVITY;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.ActivityTemplateFactory;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.ExprEvaluationContextImpl;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.LinkInfo;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OFailureHandling;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ActivityRecoveryChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.LinkStatusChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TimerResponseChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class ACTIVITYGUARD
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ACTIVITYGUARD.class);
    private static final ActivityTemplateFactory __activityTemplateFactory = new ActivityTemplateFactory();
    private OActivity _oactivity;
    private Map<OLink, Boolean> _linkVals = new HashMap<OLink, Boolean>();
    private boolean _firstTime = true;
    private ActivityFailure _failure;

    public ACTIVITYGUARD(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
        this._oactivity = self.o;
    }

    public void run() {
        if (this._firstTime) {
            this.sendEvent((ActivityEvent)new ActivityEnabledEvent());
            this._firstTime = false;
        }
        if (this._linkVals.keySet().containsAll(this._oactivity.targetLinks)) {
            if (this.evaluateJoinCondition()) {
                ActivityExecStartEvent aese = new ActivityExecStartEvent();
                this.sendEvent((ActivityEvent)aese);
                ActivityInfo activity = new ActivityInfo(this.genMonotonic(), this._self.o, this._self.self, (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
                ACTIVITYGUARD.instance((JacobRunnable)this.createActivity(activity));
                ACTIVITYGUARD.instance((JacobRunnable)new TCONDINTERCEPT(activity.parent));
            } else {
                if (this._oactivity.suppressJoinFailure) {
                    this._self.parent.completed(null, CompensationHandler.emptySet());
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Join condition false, suppress join failure on activity " + this._self.aId));
                    }
                } else {
                    FaultData fault = null;
                    fault = this.createFault(this._oactivity.getOwner().constants.qnJoinFailure, this._oactivity);
                    this._self.parent.completed(fault, CompensationHandler.emptySet());
                }
                this.dpe(this._oactivity);
            }
        } else {
            HashSet<ChannelListener> mlset = new HashSet<ChannelListener>();
            mlset.add(new TerminationChannelListener(this._self.self){
                private static final long serialVersionUID = 5094153128476008961L;

                public void terminate() {
                    ACTIVITYGUARD.this._self.parent.completed(null, CompensationHandler.emptySet());
                    ACTIVITYGUARD.this.dpe(ACTIVITYGUARD.this._oactivity);
                }
            });
            for (final OLink link : this._oactivity.targetLinks) {
                mlset.add(new LinkStatusChannelListener(this._linkFrame.resolve((OLink)link).channel){
                    private static final long serialVersionUID = 1024137371118887935L;

                    public void linkStatus(boolean value) {
                        ACTIVITYGUARD.this._linkVals.put(link, value);
                        2.instance((JacobRunnable)ACTIVITYGUARD.this);
                    }
                });
            }
            ACTIVITYGUARD.object((boolean)false, mlset);
        }
    }

    private boolean evaluateTransitionCondition(OExpression transitionCondition) throws FaultException {
        if (transitionCondition == null) {
            return true;
        }
        return this.getBpelRuntime().getExpLangRuntime().evaluateAsBoolean(transitionCondition, new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntime()));
    }

    private boolean evaluateJoinCondition() {
        if (this._oactivity.targetLinks.size() == 0) {
            return true;
        }
        if (this._oactivity.joinCondition == null) {
            return this._linkVals.values().contains(Boolean.TRUE);
        }
        try {
            return this.getBpelRuntime().getExpLangRuntime().evaluateAsBoolean(this._oactivity.joinCondition, new ExprEvaluationContextImpl(null, null, this._linkVals));
        }
        catch (Exception e) {
            String msg = "Unexpected error evaluating a join condition: " + this._oactivity.joinCondition;
            __log.error((Object)msg, (Throwable)e);
            throw new InvalidProcessException(msg, (Throwable)e);
        }
    }

    private static ACTIVITY createActivity(ActivityInfo activity, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        return __activityTemplateFactory.createInstance(activity.o, activity, scopeFrame, linkFrame);
    }

    private ACTIVITY createActivity(ActivityInfo activity) {
        return ACTIVITYGUARD.createActivity(activity, this._scopeFrame, this._linkFrame);
    }

    private void startGuardedActivity() {
        ActivityInfo activity = new ActivityInfo(this.genMonotonic(), this._self.o, this._self.self, (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        ACTIVITYGUARD.instance((JacobRunnable)this.createActivity(activity));
        ACTIVITYGUARD.instance((JacobRunnable)new TCONDINTERCEPT(activity.parent));
    }

    static class ActivityFailure
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Date dateTime;
        String reason;
        Element data;
        int retryCount;

        ActivityFailure() {
        }
    }

    private class TCONDINTERCEPT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 4014873396828400441L;
        ParentScopeChannel _in;

        public TCONDINTERCEPT(ParentScopeChannel in) {
            this._in = in;
        }

        public void run() {
            TCONDINTERCEPT.object((ChannelListener)new ParentScopeChannelListener(this._in){
                private static final long serialVersionUID = 2667359535900385952L;

                @Override
                public void compensate(OScope scope, SynchChannel ret) {
                    ACTIVITYGUARD.this._self.parent.compensate(scope, ret);
                    1.instance((JacobRunnable)TCONDINTERCEPT.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                    ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityExecEndEvent());
                    if (faultData != null) {
                        ACTIVITYGUARD.this.dpe(((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.sourceLinks);
                        ACTIVITYGUARD.this._self.parent.completed(faultData, compensations);
                    } else {
                        FaultData fault = null;
                        for (OLink olink : ((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.sourceLinks) {
                            LinkInfo linfo = ACTIVITYGUARD.this._linkFrame.resolve(olink);
                            try {
                                boolean val = ACTIVITYGUARD.this.evaluateTransitionCondition(olink.transitionCondition);
                                linfo.channel.linkStatus(val);
                            }
                            catch (FaultException e) {
                                linfo.channel.linkStatus(false);
                                __log.error((Object)e);
                                if (fault != null) continue;
                                fault = TCONDINTERCEPT.this.createFault(e.getQName(), olink.transitionCondition);
                            }
                        }
                        ACTIVITYGUARD.this._self.parent.completed(fault, compensations);
                    }
                }

                @Override
                public void cancelled() {
                    ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityExecEndEvent());
                    ACTIVITYGUARD.this.dpe(((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.outgoingLinks);
                    ACTIVITYGUARD.this.dpe(((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.sourceLinks);
                    ACTIVITYGUARD.this._self.parent.cancelled();
                }

                @Override
                public void failure(String reason, Element data) {
                    if (ACTIVITYGUARD.this._failure == null) {
                        ACTIVITYGUARD.this._failure = new ActivityFailure();
                    }
                    ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.dateTime = new Date();
                    ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason = reason;
                    ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.data = data;
                    OFailureHandling failureHandling = ACTIVITYGUARD.this._oactivity.getFailureHandling();
                    if (failureHandling != null && failureHandling.faultOnFailure) {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("ActivityRecovery: Activity " + ACTIVITYGUARD.this._self.aId + " faulting on failure"));
                        }
                        FaultData faultData = TCONDINTERCEPT.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, ACTIVITYGUARD.this._oactivity, reason);
                        this.completed(faultData, CompensationHandler.emptySet());
                        return;
                    }
                    if (failureHandling == null || ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount >= failureHandling.retryFor) {
                        this.requireRecovery();
                        return;
                    }
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("ActivityRecovery: Retrying activity " + ACTIVITYGUARD.this._self.aId));
                    }
                    Date future = new Date(new Date().getTime() + (failureHandling == null ? 0L : (long)(failureHandling.retryDelay * 1000)));
                    TimerResponseChannel timerChannel = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
                    TCONDINTERCEPT.this.getBpelRuntime().registerTimer(timerChannel, future);
                    1.object((boolean)false, (ChannelListener)new TimerResponseChannelListener(timerChannel){
                        private static final long serialVersionUID = -261911108068231376L;

                        public void onTimeout() {
                            ++((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount;
                            ACTIVITYGUARD.this.startGuardedActivity();
                        }

                        public void onCancel() {
                            this.requireRecovery();
                        }
                    });
                }

                private void requireRecovery() {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("ActivityRecovery: Activity " + ACTIVITYGUARD.this._self.aId + " requires recovery"));
                    }
                    ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityFailureEvent(((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason));
                    final ActivityRecoveryChannel recoveryChannel = (ActivityRecoveryChannel)this.newChannel(ActivityRecoveryChannel.class);
                    TCONDINTERCEPT.this.getBpelRuntime().registerActivityForRecovery(recoveryChannel, ACTIVITYGUARD.this._self.aId, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.dateTime, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.data, new String[]{"retry", "cancel", "fault"}, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount);
                    1.object((boolean)false, (Set)new ActivityRecoveryChannelListener(recoveryChannel){
                        private static final long serialVersionUID = 8397883882810521685L;

                        public void retry() {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Retrying activity " + ACTIVITYGUARD.this._self.aId + " (user initiated)"));
                            }
                            ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("retry"));
                            TCONDINTERCEPT.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                            ++((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount;
                            ACTIVITYGUARD.this.startGuardedActivity();
                        }

                        public void cancel() {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Cancelling activity " + ACTIVITYGUARD.this._self.aId + " (user initiated)"));
                            }
                            ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("cancel"));
                            TCONDINTERCEPT.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                            this.cancelled();
                        }

                        public void fault(FaultData faultData) {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Faulting activity " + ACTIVITYGUARD.this._self.aId + " (user initiated)"));
                            }
                            ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("fault"));
                            TCONDINTERCEPT.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                            if (faultData == null) {
                                faultData = TCONDINTERCEPT.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, ACTIVITYGUARD.this._self.o, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason);
                            }
                            this.completed(faultData, CompensationHandler.emptySet());
                        }
                    }.or(new TerminationChannelListener(ACTIVITYGUARD.this._self.self){
                        private static final long serialVersionUID = 2148587381204858397L;

                        public void terminate() {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Cancelling activity " + ACTIVITYGUARD.this._self.aId + " (terminated by scope)"));
                            }
                            TCONDINTERCEPT.this.getBpelRuntime().unregisterActivityForRecovery(recoveryChannel);
                            this.cancelled();
                        }
                    }));
                }
            });
        }
    }
}

